/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SignalReceiver;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class SimpleSignalController
extends SignalController {
    private SignalAspect aspect = SignalAspect.BLINK_RED;

    public SimpleSignalController(String desc, TileEntity tile) {
        super(desc, tile, 1);
    }

    public SignalAspect getAspect() {
        return this.aspect;
    }

    @Override
    public SignalAspect getAspectFor(WorldCoordinate receiver) {
        if (!this.pairings.contains(receiver)) {
            return null;
        }
        return this.aspect;
    }

    private void updateReceiver() {
        for (WorldCoordinate recv : this.pairings) {
            SignalReceiver receiver = this.getReceiverAt(recv);
            if (receiver == null) continue;
            receiver.onControllerAspectChange(this, this.aspect);
        }
        this.cleanPairings();
    }

    public void setAspect(SignalAspect aspect) {
        if (this.aspect != aspect) {
            this.aspect = aspect;
            this.updateReceiver();
        }
    }

    @Override
    protected void saveNBT(NBTTagCompound data) {
        super.saveNBT(data);
        data.func_74774_a("aspect", (byte)this.aspect.ordinal());
    }

    @Override
    protected void loadNBT(NBTTagCompound data) {
        super.loadNBT(data);
        this.aspect = SignalAspect.values()[data.func_74771_c("aspect")];
    }

    public void writePacketData(DataOutputStream data) throws IOException {
        data.writeByte(this.aspect.ordinal());
    }

    public void readPacketData(DataInputStream data) throws IOException {
        this.aspect = SignalAspect.values()[data.readByte()];
    }
}

