/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.client.render.IInvRenderer;
import mods.railcraft.client.render.models.engine.ModelEngineBase;
import mods.railcraft.client.render.models.engine.ModelEngineFrame;
import mods.railcraft.client.render.models.engine.ModelEnginePiston;
import mods.railcraft.client.render.models.engine.ModelEngineTrunk;
import mods.railcraft.common.blocks.machine.beta.TileEngine;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderPneumaticEngine
extends TileEntitySpecialRenderer
implements IInvRenderer {
    public static final RenderPneumaticEngine renderHobby = new RenderPneumaticEngine("/mods/railcraft/textures/tesr/steam_hobby.png");
    public static final RenderPneumaticEngine renderLow = new RenderPneumaticEngine("/mods/railcraft/textures/tesr/steam_low.png");
    public static final RenderPneumaticEngine renderHigh = new RenderPneumaticEngine("/mods/railcraft/textures/tesr/steam_high.png");
    private static final float[] angleMap = new float[6];
    private static final ModelEngineFrame frame = new ModelEngineFrame();
    private static final ModelEngineBase base = new ModelEngineBase();
    private static final ModelEngineTrunk trunk = new ModelEngineTrunk();
    private static final ModelEnginePiston piston = new ModelEnginePiston();
    private String texture;

    private RenderPneumaticEngine(String texture) {
        this.texture = texture;
        this.func_76893_a(TileEntityRenderer.field_76963_a);
    }

    @Override
    public void renderItem(RenderBlocks render, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        this.render(TileEngine.EnergyStage.BLUE, 0.25f, ForgeDirection.UP, -0.5, -0.5, -0.5);
    }

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        TileEngine engine = (TileEngine)tileentity;
        if (engine != null) {
            this.render(engine.getEnergyStage(), engine.getProgress(), engine.getOrientation(), x, y, z);
        }
    }

    private void render(TileEngine.EnergyStage energy, float progress, ForgeDirection orientation, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{orientation.offsetX, orientation.offsetY, orientation.offsetZ};
        switch (orientation) {
            case EAST: 
            case WEST: 
            case DOWN: {
                angle[2] = angleMap[orientation.ordinal()];
                break;
            }
            case SOUTH: 
            case NORTH: {
                angle[0] = angleMap[orientation.ordinal()];
            }
        }
        base.setRotation(angle[0], angle[1], angle[2]);
        trunk.rotate(angle[0], angle[1], angle[2]);
        frame.setRotation(angle[0], angle[1], angle[2]);
        piston.setRotation(angle[0], angle[1], angle[2]);
        float factor = 0.0625f;
        this.func_76897_a(this.texture);
        trunk.render(energy, factor);
        base.render(factor);
        float step = (double)progress > 0.5 ? 7.99f - (progress - 0.5f) * 2.0f * 7.99f : progress * 2.0f * 7.99f;
        float frameTrans = step / 16.0f;
        GL11.glTranslatef((float)(translate[0] * frameTrans), (float)(translate[1] * frameTrans), (float)(translate[2] * frameTrans));
        frame.render(factor);
        GL11.glTranslatef((float)(-translate[0] * frameTrans), (float)(-translate[1] * frameTrans), (float)(-translate[2] * frameTrans));
        float pistonPrep = 0.01f;
        GL11.glTranslatef((float)(-translate[0] * pistonPrep), (float)(-translate[1] * pistonPrep), (float)(-translate[2] * pistonPrep));
        float pistonTrans = 0.125f;
        GL11.glDisable((int)2896);
        int i = 0;
        while ((float)i <= step + 2.0f) {
            piston.render(factor);
            GL11.glTranslatef((float)(translate[0] * pistonTrans), (float)(translate[1] * pistonTrans), (float)(translate[2] * pistonTrans));
            i += 2;
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    static {
        RenderPneumaticEngine.angleMap[ForgeDirection.EAST.ordinal()] = -1.5707964f;
        RenderPneumaticEngine.angleMap[ForgeDirection.WEST.ordinal()] = 1.5707964f;
        RenderPneumaticEngine.angleMap[ForgeDirection.UP.ordinal()] = 0.0f;
        RenderPneumaticEngine.angleMap[ForgeDirection.DOWN.ordinal()] = (float)Math.PI;
        RenderPneumaticEngine.angleMap[ForgeDirection.SOUTH.ordinal()] = 1.5707964f;
        RenderPneumaticEngine.angleMap[ForgeDirection.NORTH.ordinal()] = -1.5707964f;
    }
}

