/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import mods.railcraft.client.render.carts.CartModelManager;
import mods.railcraft.client.render.carts.CartModelRenderer;
import mods.railcraft.client.render.carts.RenderCart;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import org.lwjgl.opengl.GL11;

public class LocomotiveRenderer
extends CartModelRenderer {
    @Override
    public boolean render(RenderCart renderer, EntityMinecart cart, float light, float time) {
        GL11.glPushMatrix();
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        EntityLocomotive loco = (EntityLocomotive)cart;
        String[] textures = loco.getLocomotiveTextures();
        ModelBase model = CartModelManager.getCoreModel(cart.getClass());
        for (int pass = 0; pass < 3; ++pass) {
            renderer.bindTexture(textures[pass]);
            int color = 0xFFFFFF;
            switch (pass) {
                case 0: {
                    color = EnumColor.fromId(loco.getPrimaryColor()).getHexColor();
                    break;
                }
                case 1: {
                    color = EnumColor.fromId(loco.getSecondaryColor()).getHexColor();
                }
            }
            float dim = light;
            float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
            float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float c3 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(c1 * dim), (float)(c2 * dim), (float)(c3 * dim), (float)1.0f);
            model.func_78088_a((Entity)cart, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        GL11.glPopMatrix();
        return false;
    }
}

