/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.post;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.client.util.textures.SharedIconLoader;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.signals.ISignalTile;
import mods.railcraft.common.blocks.signals.MaterialStructure;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.block.StepSound;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public class BlockPost
extends Block {
    public static final Set canConnect = new HashSet();
    public static final Set noConnect = new HashSet();
    private static final float SIZE = 0.15f;
    private static final float SELECT = 0.1f;
    private final int renderType;

    public BlockPost(int id, int renderType) {
        super(id, (Material)new MaterialStructure());
        this.renderType = renderType;
        this.func_71864_b("railcraft.post");
        this.func_71884_a(new StepSound("railcraft", 1.0f, 1.0f));
        this.func_71894_b(15.0f);
        this.func_71848_c(3.0f);
        MinecraftForge.setBlockHarvestLevel((Block)this, (String)"crowbar", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)this, (int)EnumPost.WOOD.ordinal(), (String)"axe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)this, (int)EnumPost.STONE.ordinal(), (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)this, (int)EnumPost.METAL.ordinal(), (String)"pickaxe", (int)2);
        this.func_71849_a(CreativePlugin.TAB);
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumPost post : EnumPost.values()) {
            list.add(post.getItem());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        block3: for (EnumPost post : EnumPost.VALUES) {
            switch (post) {
                case STONE: {
                    continue block3;
                }
                default: {
                    post.setTexture(iconRegister.func_94245_a("railcraft:" + post.getTag()));
                }
            }
        }
        EnumPost.STONE.setTexture(SharedIconLoader.INSTANCE.getIcon(iconRegister, "railcraft:concrete"));
    }

    public Icon func_71858_a(int side, int meta) {
        return EnumPost.fromId(meta).getIcon();
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public void func_71902_a(IBlockAccess world, int i, int j, int k) {
        this.func_71905_a(0.2f, 0.0f, 0.2f, 0.8f, 1.0f, 0.8f);
    }

    public AxisAlignedBB func_71872_e(World world, int i, int j, int k) {
        if (!(world.func_72799_c(i, j - 1, k) || Block.field_71973_m[world.func_72798_a(i, j - 1, k)] instanceof BlockPost || BlockRail.func_72180_d_((World)world, (int)i, (int)(j + 1), (int)k))) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)i + 0.15f), (double)j, (double)((float)k + 0.15f), (double)((float)(i + 1) - 0.15f), (double)j + 1.5, (double)((float)(k + 1) - 0.15f));
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)i + 0.15f), (double)j, (double)((float)k + 0.15f), (double)((float)(i + 1) - 0.15f), (double)(j + 1), (double)((float)(k + 1) - 0.15f));
    }

    public AxisAlignedBB func_71911_a_(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)i + 0.1f), (double)j, (double)((float)k + 0.1f), (double)((float)(i + 1) - 0.1f), (double)((float)j + 1.0f), (double)((float)(k + 1) - 0.1f));
    }

    public boolean func_71918_c(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int i, int j, int k, ForgeDirection side) {
        return side == ForgeDirection.DOWN || side == ForgeDirection.UP;
    }

    public static boolean connectPostAt(World world, int i, int j, int k, ForgeDirection side) {
        if (world.func_72799_c(i, j, k)) {
            return false;
        }
        int id = world.func_72798_a(i, j, k);
        if (Block.field_71973_m[id] instanceof BlockPost) {
            return true;
        }
        if (Block.field_71973_m[id] instanceof IPostConnection) {
            return ((IPostConnection)Block.field_71973_m[id]).connectsAt(world, i, j, k, side);
        }
        if (Block.field_71973_m[id].isGenMineableReplaceable(world, i, j, k, Block.field_71981_t.field_71990_ca)) {
            return false;
        }
        if (Block.field_71973_m[id].isGenMineableReplaceable(world, i, j, k, Block.field_72012_bb.field_71990_ca)) {
            return false;
        }
        if (noConnect.contains(id)) {
            return false;
        }
        if (canConnect.contains(id)) {
            return true;
        }
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof ISignalTile) {
            return true;
        }
        if (world.isBlockSolidOnSide(i, j, k, side)) {
            return true;
        }
        return Block.field_71973_m[id] != null && Block.field_71973_m[id].getClass().getSimpleName().equals("BlockShapedLamp");
    }

    public boolean connectToBlockAt(World world, int i, int j, int k, ForgeDirection side) {
        return BlockPost.connectPostAt(world, i, j, k, side);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return this.renderType;
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        if (metadata == EnumPost.WOOD.ordinal()) {
            return 300;
        }
        return 0;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        if (metadata == EnumPost.WOOD.ordinal()) {
            return 5;
        }
        return 0;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return metadata == EnumPost.WOOD.ordinal();
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        int meta = world.func_72805_g(x, y, z);
        if (meta != EnumPost.METAL.ordinal()) {
            return false;
        }
        Block block = RailcraftBlocks.getBlockPostMetal();
        if (block != null) {
            world.func_72832_d(x, y, z, block.field_71990_ca, colour, 3);
            return true;
        }
        return false;
    }

    static {
        canConnect.add(Block.field_72014_bd.field_71990_ca);
        canConnect.add(Block.field_72080_bM.field_71990_ca);
        canConnect.add(Block.field_72078_bL.field_71990_ca);
        canConnect.add(Block.field_71946_M.field_71990_ca);
        canConnect.add(Block.field_72065_as.field_71990_ca);
        canConnect.add(Block.field_71963_Z.field_71990_ca);
        noConnect.add(Block.field_71979_v.field_71990_ca);
        noConnect.add(Block.field_71981_t.field_71990_ca);
        noConnect.add(Block.field_71940_F.field_71990_ca);
        noConnect.add(Block.field_71980_u.field_71990_ca);
        noConnect.add(Block.field_71939_E.field_71990_ca);
        noConnect.add(Block.field_71986_z.field_71990_ca);
        noConnect.add(Block.field_71950_I.field_71990_ca);
        noConnect.add(Block.field_72073_aw.field_71990_ca);
        noConnect.add(Block.field_72068_bR.field_71990_ca);
        noConnect.add(Block.field_71941_G.field_71990_ca);
        noConnect.add(Block.field_71949_H.field_71990_ca);
        noConnect.add(Block.field_71947_N.field_71990_ca);
        noConnect.add(Block.field_72047_aN.field_71990_ca);
        noConnect.add(Block.field_72048_aO.field_71990_ca);
        noConnect.add(Block.field_72041_aW.field_71990_ca);
        noConnect.add(Block.field_72039_aU.field_71990_ca);
        noConnect.add(Block.field_71997_br.field_71990_ca);
        noConnect.add(Block.field_72061_ba.field_71990_ca);
        noConnect.add(Block.field_72091_am.field_71990_ca);
        noConnect.add(Block.field_72013_bc.field_71990_ca);
        noConnect.add(Block.field_72012_bb.field_71990_ca);
        noConnect.add(Block.field_71945_L.field_71990_ca);
    }
}

