/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.slab;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mods.railcraft.common.blocks.aesthetics.brick.BlockBrick;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.slab.BlockRailcraftSlab;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.StepSound;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public enum EnumSlab {
    SANDY_BRICK,
    INFERNAL_BRICK,
    CONCRETE,
    SNOW,
    ICE,
    IRON,
    GOLD,
    DIAMOND,
    FROSTBOUND_BRICK,
    QUARRIED_BRICK,
    BLEACHEDBONE_BRICK,
    BLOODSTAINED_BRICK,
    ABYSSAL_BRICK,
    SANDY_FITTED,
    INFERNAL_FITTED,
    FROSTBOUND_FITTED,
    QUARRIED_FITTED,
    BLEACHEDBONE_FITTED,
    BLOODSTAINED_FITTED,
    ABYSSAL_FITTED,
    SANDY_BLOCK,
    INFERNAL_BLOCK,
    FROSTBOUND_BLOCK,
    QUARRIED_BLOCK,
    BLEACHEDBONE_BLOCK,
    BLOODSTAINED_BLOCK,
    ABYSSAL_BLOCK;

    public static final EnumSlab[] VALUES;
    public static final Map NAMES;
    public static final List creativeList;
    private StepSound sound;
    private Block source;
    private int sourceMeta = 0;

    public static void initialize() {
        EnumSlab.SANDY_BRICK.source = BlockBrick.sandy;
        EnumSlab.INFERNAL_BRICK.source = BlockBrick.infernal;
        EnumSlab.FROSTBOUND_BRICK.source = BlockBrick.frostbound;
        EnumSlab.QUARRIED_BRICK.source = BlockBrick.quarried;
        EnumSlab.BLEACHEDBONE_BRICK.source = BlockBrick.bleachedbone;
        EnumSlab.BLOODSTAINED_BRICK.source = BlockBrick.bloodstained;
        EnumSlab.ABYSSAL_BRICK.source = BlockBrick.abyssal;
        EnumSlab.SANDY_FITTED.source = BlockBrick.sandy;
        EnumSlab.SANDY_FITTED.sourceMeta = 1;
        EnumSlab.INFERNAL_FITTED.source = BlockBrick.infernal;
        EnumSlab.INFERNAL_FITTED.sourceMeta = 1;
        EnumSlab.FROSTBOUND_FITTED.source = BlockBrick.frostbound;
        EnumSlab.FROSTBOUND_FITTED.sourceMeta = 1;
        EnumSlab.QUARRIED_FITTED.source = BlockBrick.quarried;
        EnumSlab.QUARRIED_FITTED.sourceMeta = 1;
        EnumSlab.BLEACHEDBONE_FITTED.source = BlockBrick.bleachedbone;
        EnumSlab.BLEACHEDBONE_FITTED.sourceMeta = 1;
        EnumSlab.BLOODSTAINED_FITTED.source = BlockBrick.bloodstained;
        EnumSlab.BLOODSTAINED_FITTED.sourceMeta = 1;
        EnumSlab.ABYSSAL_FITTED.source = BlockBrick.abyssal;
        EnumSlab.ABYSSAL_FITTED.sourceMeta = 1;
        EnumSlab.SANDY_BLOCK.source = BlockBrick.sandy;
        EnumSlab.SANDY_BLOCK.sourceMeta = 2;
        EnumSlab.INFERNAL_BLOCK.source = BlockBrick.infernal;
        EnumSlab.INFERNAL_BLOCK.sourceMeta = 2;
        EnumSlab.FROSTBOUND_BLOCK.source = BlockBrick.frostbound;
        EnumSlab.FROSTBOUND_BLOCK.sourceMeta = 2;
        EnumSlab.QUARRIED_BLOCK.source = BlockBrick.quarried;
        EnumSlab.QUARRIED_BLOCK.sourceMeta = 2;
        EnumSlab.BLEACHEDBONE_BLOCK.source = BlockBrick.bleachedbone;
        EnumSlab.BLEACHEDBONE_BLOCK.sourceMeta = 2;
        EnumSlab.BLOODSTAINED_BLOCK.source = BlockBrick.bloodstained;
        EnumSlab.BLOODSTAINED_BLOCK.sourceMeta = 2;
        EnumSlab.ABYSSAL_BLOCK.source = BlockBrick.abyssal;
        EnumSlab.ABYSSAL_BLOCK.sourceMeta = 2;
        EnumSlab.CONCRETE.source = BlockCube.getBlock();
        EnumSlab.CONCRETE.sourceMeta = EnumCube.CONCRETE_BLOCK.ordinal();
        EnumSlab.SNOW.source = Block.field_72039_aU;
        EnumSlab.ICE.source = Block.field_72036_aT;
        EnumSlab.IRON.source = Block.field_72083_ai;
        EnumSlab.GOLD.source = Block.field_72105_ah;
        EnumSlab.DIAMOND.source = Block.field_72071_ax;
        for (EnumSlab slab : VALUES) {
            NAMES.put(slab.name(), slab);
            if (!slab.isEnabled() || slab.source == null) continue;
            switch (slab) {
                case CONCRETE: {
                    slab.sound = Block.field_71976_h;
                    break;
                }
                default: {
                    slab.sound = slab.source.field_72020_cn;
                }
            }
            switch (slab) {
                case SNOW: {
                    CraftingPlugin.addShapedRecipe(slab.getItem(3), "SSS", Character.valueOf('S'), Block.field_72037_aS);
                    break;
                }
                default: {
                    CraftingPlugin.addShapedRecipe(slab.getItem(6), "SSS", Character.valueOf('S'), slab.getSourceItem());
                }
            }
            CraftingPlugin.addShapedRecipe(slab.getSourceItem(), "S", "S", Character.valueOf('S'), slab.getItem());
        }
        creativeList.add(SNOW);
        creativeList.add(ICE);
        creativeList.add(IRON);
        creativeList.add(GOLD);
        creativeList.add(DIAMOND);
        creativeList.add(CONCRETE);
        creativeList.add(ABYSSAL_BRICK);
        creativeList.add(ABYSSAL_FITTED);
        creativeList.add(ABYSSAL_BLOCK);
        creativeList.add(INFERNAL_BRICK);
        creativeList.add(INFERNAL_FITTED);
        creativeList.add(INFERNAL_BLOCK);
        creativeList.add(BLOODSTAINED_BRICK);
        creativeList.add(BLOODSTAINED_FITTED);
        creativeList.add(BLOODSTAINED_BLOCK);
        creativeList.add(SANDY_BRICK);
        creativeList.add(SANDY_FITTED);
        creativeList.add(SANDY_BLOCK);
        creativeList.add(BLEACHEDBONE_BRICK);
        creativeList.add(BLEACHEDBONE_FITTED);
        creativeList.add(BLEACHEDBONE_BLOCK);
        creativeList.add(QUARRIED_BRICK);
        creativeList.add(QUARRIED_FITTED);
        creativeList.add(QUARRIED_BLOCK);
        creativeList.add(FROSTBOUND_BRICK);
        creativeList.add(FROSTBOUND_FITTED);
        creativeList.add(FROSTBOUND_BLOCK);
    }

    public static EnumSlab fromOrdinal(int id) {
        if (id < 0 || id >= VALUES.length) {
            return VALUES[0];
        }
        return VALUES[id];
    }

    public static EnumSlab fromName(String name) {
        EnumSlab stair = (EnumSlab)((Object)NAMES.get(name));
        if (stair != null) {
            return stair;
        }
        return SANDY_BRICK;
    }

    public Icon getTexture(int side) {
        return this.getSource().func_71858_a(side, this.sourceMeta);
    }

    public Block getSource() {
        if (this.source == null) {
            return Block.field_72007_bm;
        }
        return this.source;
    }

    public int getSourceMeta() {
        return this.sourceMeta;
    }

    public Block getBlock() {
        return BlockRailcraftSlab.getBlock();
    }

    public StepSound getSound() {
        return this.sound;
    }

    public boolean isTransparent() {
        return this == ICE;
    }

    public ItemStack getSourceItem() {
        if (this.source == null) {
            return null;
        }
        return new ItemStack(this.source, 1, this.sourceMeta);
    }

    public ItemStack getItem() {
        return this.getItem(1);
    }

    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    public String getTag() {
        return "railcraft.slab." + this.name().replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES) && RailcraftConfig.isSubBlockEnabled(this.getTag()) && this.getBlock() != null;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        switch (this) {
            case CONCRETE: {
                return EnumCube.CONCRETE_BLOCK.getHardness();
            }
        }
        Block block = this.getSource();
        if (block == null) {
            return Block.field_72081_al.func_71934_m(world, x, y, z);
        }
        return block.func_71934_m(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity) {
        switch (this) {
            case CONCRETE: {
                return EnumCube.CONCRETE_BLOCK.getResistance() * 3.0f / 5.0f;
            }
        }
        Block block = this.getSource();
        if (block == null) {
            return Block.field_72081_al.func_71904_a(entity);
        }
        return block.func_71904_a(entity);
    }

    static {
        VALUES = EnumSlab.values();
        NAMES = new HashMap();
        creativeList = new ArrayList();
    }
}

