/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.api.crafting.IBlastFurnaceRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.TileMultiBlockOven;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.AdjacentInventoryCache;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventorySorter;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;

public class TileBlastFurnace
extends TileMultiBlockOven
implements ISidedInventory {
    public static final IStackFilter INPUT_FILTER = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return RailcraftCraftingManager.blastFurnace.getRecipe(stack) != null;
        }
    };
    public static final IStackFilter FUEL_FILTER = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return stack != null && (stack.func_77973_b() == Item.field_77705_m && stack.func_77960_j() == 1 || InvTools.isItemEqual(stack, COAL_COKE) || InvTools.isItemEqual(stack, COAL_COKE_BLOCK));
        }
    };
    private static final int FUEL_PER_TICK = 5;
    private static final int COOK_STEP_LENGTH = 8;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_FUEL = 1;
    private static final int SLOT_OUTPUT = 2;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 3);
    private static final ItemStack COAL_COKE = RailcraftToolItems.getCoalCoke();
    private static final ItemStack COAL_COKE_BLOCK = EnumCube.COKE_BLOCK.getItem();
    private static final List patterns = new ArrayList();
    public int burnTime = 0;
    public int currentItemBurnTime = 0;
    private int finishedAt;
    private final IInventory invFuel = new InventoryMapper(this, 1, 1);
    private final IInventory invInput = new InventoryMapper(this, 0, 1);
    private final IInventory invOutput = new InventoryMapper(this, 2, 1);
    private AdjacentInventoryCache invCache = new AdjacentInventoryCache(this, new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            if (tile instanceof TileBlastFurnace) {
                return false;
            }
            if (tile instanceof IInventory) {
                return ((IInventory)tile).func_70302_i_() >= 27;
            }
            return false;
        }
    }, InventorySorter.SIZE_DECENDING);

    public TileBlastFurnace() {
        super("gui.blast.furnace", 3, patterns);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.BLAST_FURNACE;
    }

    @Override
    public Icon getIcon(int side) {
        if (this.getPatternMarker() == 'W' && this.isStructureValid()) {
            if (this.isBurning()) {
                return this.getMachineType().getTexture(7);
            }
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(0);
    }

    @Override
    protected boolean isMapPositionValid(int i, int j, int k, char mapPos) {
        int id = this.field_70331_k.func_72798_a(i, j, k);
        switch (mapPos) {
            case 'O': {
                if (id == RailcraftBlocks.getBlockMachineAlpha().field_71990_ca && this.field_70331_k.func_72805_g(i, j, k) == this.func_70322_n()) break;
                return true;
            }
            case 'B': 
            case 'W': {
                if (id != RailcraftBlocks.getBlockMachineAlpha().field_71990_ca || this.field_70331_k.func_72805_g(i, j, k) != this.func_70322_n()) break;
                return true;
            }
            case 'A': {
                if (!this.field_70331_k.func_72799_c(i, j, k) && this.field_70331_k.func_72803_f(i, j, k) != Material.field_76256_h) break;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onMasterReset() {
        super.onMasterReset();
        this.cookTime = 0;
        this.burnTime = 0;
        this.currentItemBurnTime = 0;
    }

    @Override
    public int getTotalCookTime() {
        ItemStack input = this.func_70301_a(0);
        IBlastFurnaceRecipe recipe = RailcraftCraftingManager.blastFurnace.getRecipe(input);
        if (recipe != null) {
            return recipe.getCookTime();
        }
        return 1;
    }

    @Override
    public int getBurnProgressScaled(int i) {
        if (this.burnTime <= 0 || this.currentItemBurnTime <= 0) {
            return 0;
        }
        int scale = this.burnTime * i / this.currentItemBurnTime;
        scale = Math.min(scale, i);
        scale = Math.max(scale, 0);
        return scale;
    }

    private void setLavaIdle() {
        int xLava = this.field_70329_l + 1;
        int yLava = this.field_70330_m + 1;
        int zLava = this.field_70327_n + 1;
        if (this.field_70331_k.func_72798_a(xLava, yLava, zLava) == 0) {
            this.field_70331_k.func_72832_d(xLava, yLava, zLava, Block.field_71938_D.field_71990_ca, 7, 3);
        }
    }

    private void setLavaBurn() {
        int xLava = this.field_70329_l + 1;
        int yLava = this.field_70330_m + 1;
        int zLava = this.field_70327_n + 1;
        if (this.field_70331_k.func_72798_a(xLava, yLava, zLava) == 0) {
            this.field_70331_k.func_72832_d(xLava, yLava, zLava, Block.field_71944_C.field_71990_ca, 1, 3);
        }
        if (this.field_70331_k.func_72798_a(xLava, ++yLava, zLava) == 0) {
            this.field_70331_k.func_72832_d(xLava, yLava, zLava, Block.field_71944_C.field_71990_ca, 1, 3);
        }
    }

    private void destroyLava() {
        int xLava = this.field_70329_l + 1;
        int yLava = this.field_70330_m + 2;
        int zLava = this.field_70327_n + 1;
        if (this.field_70331_k.func_72803_f(xLava, yLava, zLava) == Material.field_76256_h) {
            this.field_70331_k.func_94571_i(xLava, yLava, zLava);
        }
        if (this.field_70331_k.func_72803_f(xLava, --yLava, zLava) == Material.field_76256_h) {
            this.field_70331_k.func_94571_i(xLava, yLava, zLava);
        }
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.invCache.purge();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isHost(this.getWorld())) {
            TileBlastFurnace mBlock = (TileBlastFurnace)this.getMasterBlock();
            if (mBlock != null) {
                InvTools.moveOneItem(this.invCache.getAdjecentInventories(), mBlock.invFuel, FUEL_FILTER);
            }
            if (this.isMaster()) {
                int prevBurnTime = this.burnTime;
                if (this.update > this.finishedAt + 8 + 5 && this.cookTime <= 0) {
                    this.setCooking(false);
                }
                this.burnTime = this.burnTime >= 5 ? (this.burnTime -= 5) : 0;
                if (this.isBurning()) {
                    this.setLavaBurn();
                } else {
                    this.setLavaIdle();
                }
                ItemStack input = this.func_70301_a(0);
                if (input != null && input.field_77994_a > 0) {
                    ItemStack output = this.func_70301_a(2);
                    IBlastFurnaceRecipe recipe = RailcraftCraftingManager.blastFurnace.getRecipe(input);
                    if (recipe != null && recipe.isRoomForOutput(output)) {
                        int itemBurnTime;
                        ItemStack fuel;
                        if (this.paused) {
                            return;
                        }
                        if (this.burnTime <= 10 && FUEL_FILTER.matches(fuel = this.func_70301_a(1)) && (itemBurnTime = FuelPlugin.getBurnTime(fuel)) > 0) {
                            this.burnTime = this.currentItemBurnTime = itemBurnTime + this.burnTime;
                            this.func_70298_a(1, 1);
                        }
                        if (this.update % 8 == 0 && this.isBurning()) {
                            this.cookTime += 8;
                            this.setCooking(true);
                            if (this.cookTime >= recipe.getCookTime()) {
                                this.cookTime = 0;
                                this.finishedAt = this.update;
                                if (output == null) {
                                    this.func_70299_a(2, recipe.getOutput());
                                } else {
                                    output.field_77994_a += recipe.getOutputStackSize();
                                }
                                this.func_70298_a(0, 1);
                            }
                            this.sendUpdateToClient();
                        }
                    } else {
                        this.cookTime = 0;
                        this.setCooking(false);
                    }
                } else {
                    this.cookTime = 0;
                    this.setCooking(false);
                }
                if (prevBurnTime == 0 ^ this.burnTime == 0) {
                    this.sendUpdateToClient();
                }
            }
        }
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock masterBlock = this.getMasterBlock();
        if (masterBlock != null) {
            GuiHandler.openGui(EnumGui.BLAST_FURNACE, player, this.field_70331_k, masterBlock.field_70329_l, masterBlock.field_70330_m, masterBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("burnTime", this.burnTime);
        data.func_74768_a("currentItemBurnTime", this.currentItemBurnTime);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.burnTime = data.func_74762_e("burnTime");
        this.currentItemBurnTime = data.func_74762_e("currentItemBurnTime");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.burnTime);
        data.writeInt(this.currentItemBurnTime);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.burnTime = data.readInt();
        this.currentItemBurnTime = data.readInt();
    }

    @Override
    public boolean needsFuel() {
        ItemStack fuel = this.func_70301_a(1);
        return fuel == null || fuel.field_77994_a < 8;
    }

    @Override
    public boolean isBurning() {
        TileBlastFurnace mBlock = (TileBlastFurnace)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.burnTime > 0;
        }
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 2: {
                return false;
            }
            case 1: {
                return FUEL_FILTER.matches(stack);
            }
            case 0: {
                return INPUT_FILTER.matches(stack);
            }
        }
        return false;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'W', 'B', 'W', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'A', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'A', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map));
    }
}

