/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.crafting.ICokeOvenRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.TileMultiBlockOven;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.liquids.tanks.FakeTank;
import mods.railcraft.common.liquids.tanks.StandardTank;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class TileCokeOven
extends TileMultiBlockOven
implements ITankContainer,
ISidedInventory {
    private static final int COOK_STEP_LENGTH = 50;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final int SLOT_LIQUID_OUTPUT = 2;
    private static final int SLOT_LIQUID_INPUT = 3;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 4);
    private static final int TANK_CAPACITY = 64000;
    private static final List patterns = new ArrayList();
    private int finishedAt;
    private int cookTimeTotal = 3600;
    private final TankManager tankManager = new TankManager();
    private final StandardTank tank;
    private IInventory invInput = new InventoryMapper(this, 0, 1);
    private IInventory invOutput = new InventoryMapper(this, 1, 2, false);

    public TileCokeOven() {
        super("gui.coke.oven", 4, patterns);
        this.tank = new StandardTank(64000, this);
        this.tankManager.addTank(this.tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.COKE_OVEN;
    }

    public TankManager getTankManager() {
        TileCokeOven mBlock = (TileCokeOven)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public Icon getIcon(int side) {
        if (this.getPatternMarker() == 'W' && this.isStructureValid()) {
            if (this.isBurning()) {
                return this.getMachineType().getTexture(7);
            }
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(0);
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        if (this.isStructureValid() && LiquidManager.instance().handleRightClick(this, 0, player, false, true)) {
            return true;
        }
        if (LiquidManager.instance().isContainer(player.field_71071_by.func_70448_g())) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public int getTotalCookTime() {
        TileCokeOven mBlock = (TileCokeOven)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.cookTimeTotal;
        }
        return 3600;
    }

    @Override
    public int getBurnProgressScaled(int i) {
        return (this.getTotalCookTime() - this.getCookTime()) * i / this.getTotalCookTime();
    }

    @Override
    public boolean needsFuel() {
        ItemStack fuel = this.func_70301_a(0);
        return fuel == null || fuel.field_77994_a < 8;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isHost(this.getWorld()) && this.isMaster()) {
            ItemStack bottomSlot;
            ItemStack topSlot;
            ItemStack input;
            if (this.update > this.finishedAt + 50 + 5 && this.cookTime <= 0) {
                this.setCooking(false);
            }
            if ((input = this.func_70301_a(0)) != null && input.field_77994_a > 0 && !InvTools.isSynthetic(input)) {
                if (!this.paused && this.update % 50 == 0) {
                    ItemStack output = this.func_70301_a(1);
                    ICokeOvenRecipe recipe = RailcraftCraftingManager.cokeOven.getRecipe(input);
                    if (recipe != null) {
                        if ((output == null || output.func_77969_a(recipe.getOutput()) && output.field_77994_a + recipe.getOutput().field_77994_a <= output.func_77976_d()) && this.tank.fill(recipe.getLiquidOutput(), false) >= recipe.getLiquidOutput().amount) {
                            this.cookTimeTotal = recipe.getCookTime();
                            this.cookTime += 50;
                            this.setCooking(true);
                            if (this.cookTime >= recipe.getCookTime()) {
                                this.cookTime = 0;
                                this.finishedAt = this.update;
                                this.func_70298_a(0, 1);
                                if (output == null) {
                                    this.func_70299_a(1, recipe.getOutput());
                                } else {
                                    output.field_77994_a += recipe.getOutput().field_77994_a;
                                }
                                this.tank.fill(recipe.getLiquidOutput(), true);
                                this.sendUpdateToClient();
                            }
                        } else {
                            this.cookTime = 0;
                            this.setCooking(false);
                        }
                    } else {
                        this.cookTime = 0;
                        this.setCooking(false);
                        this.func_70299_a(0, null);
                        this.dropItem(input);
                    }
                }
            } else {
                this.cookTime = 0;
                this.setCooking(false);
            }
            if ((topSlot = this.func_70301_a(3)) != null && !LiquidManager.instance().isContainer(topSlot)) {
                this.func_70299_a(3, null);
                this.dropItem(topSlot);
            }
            if ((bottomSlot = this.func_70301_a(2)) != null && !LiquidManager.instance().isContainer(bottomSlot)) {
                this.func_70299_a(2, null);
                this.dropItem(bottomSlot);
            }
            if (this.update % 8 == 0) {
                LiquidManager.instance().processContainers(this.tank, this, 3, 2, false, true);
            }
        }
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock masterBlock = this.getMasterBlock();
        if (masterBlock != null && this.isStructureValid()) {
            GuiHandler.openGui(EnumGui.COKE_OVEN, player, this.field_70331_k, masterBlock.field_70329_l, masterBlock.field_70330_m, masterBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.tankManager.readTanksFromNBT(data);
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.tankManager.writeTanksToNBT(data);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (tankIndex != 0) {
            return null;
        }
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.drain(tankIndex, maxDrain, doDrain);
        }
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection dir) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTanks();
        }
        return FakeTank.ARRAY;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTank(0);
        }
        return FakeTank.INSTANCE;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return RailcraftCraftingManager.cokeOven.getRecipe(stack) != null;
            }
            case 3: {
                return LiquidManager.instance().isEmptyContainer(stack);
            }
        }
        return false;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1 || slot == 2;
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'W', 'A', 'W', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map));
    }
}

