/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.alpha.TileSteamOven;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileBoiler;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.liquids.LiquidFilter;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.AdjacentInventoryCache;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventorySorter;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class TileBoilerFireboxSolid
extends TileBoilerFirebox
implements INeedsFuel {
    private static final int SLOT_BURN = 2;
    private static final int SLOT_FUEL_A = 3;
    private static final int SLOT_FUEL_B = 4;
    private static final int SLOT_FUEL_C = 5;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 6);
    private IInventory invBurn = new InventoryMapper(this, 2, 1);
    private IInventory invStock = new InventoryMapper(this, 3, 3);
    private IInventory invFuel = new InventoryMapper(this, 2, 4);
    private ItemStack bucket = new ItemStack(Item.field_77788_aw);
    private AdjacentInventoryCache invCache = new AdjacentInventoryCache(this, new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            if (tile instanceof TileSteamOven) {
                return true;
            }
            if (tile instanceof TileBoiler) {
                return false;
            }
            if (tile instanceof IInventory) {
                return ((IInventory)tile).func_70302_i_() >= 27;
            }
            return false;
        }
    }, InventorySorter.SIZE_DECENDING);

    public TileBoilerFireboxSolid() {
        super(6);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.BOILER_FIREBOX_SOLID;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.BOILER_SOLID, player, this.field_70331_k, mBlock.field_70329_l, mBlock.field_70330_m, mBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    protected void process() {
        InvTools.moveOneItem(this.invStock, this.invBurn);
        InvTools.moveOneItem(this.invBurn, this.invWaterOutput, this.bucket);
    }

    @Override
    public void func_70316_g() {
        TileBoilerFireboxSolid mBlock;
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (this.needsFuel() && (mBlock = (TileBoilerFireboxSolid)this.getMasterBlock()) != null) {
            InvTools.moveOneItem(this.invCache.getAdjecentInventories(), mBlock.invStock, (IStackFilter)StackFilter.FUEL);
        }
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.invCache.purge();
    }

    @Override
    protected float getMoreFuel() {
        ItemStack fuel = this.func_70301_a(2);
        int burn = FuelPlugin.getBurnTime(fuel);
        if (burn > 0) {
            this.func_70299_a(2, InvTools.depleteItem(fuel));
        }
        return burn;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot >= 2) {
            return FuelPlugin.getBurnTime(stack) > 0;
        }
        if (slot == 0) {
            return LiquidManager.instance().isFilledContainer(stack) && LiquidManager.instance().containsLiquid(stack, LiquidFilter.WATER);
        }
        return false;
    }

    @Override
    public boolean needsFuel() {
        TileBoilerFireboxSolid mBlock = (TileBoilerFireboxSolid)this.getMasterBlock();
        if (mBlock != null) {
            int amount = InvTools.countItems(mBlock.invFuel);
            return amount < 64;
        }
        return false;
    }

    public boolean func_94042_c() {
        return false;
    }
}

