/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderItemBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.util.inventory.AdjacentInventoryCache;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventorySorter;
import mods.railcraft.common.util.inventory.ItemStackMap;
import mods.railcraft.common.util.inventory.ItemStackSet;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileItemLoader
extends TileLoaderItemBase {
    private final Map transferedItems = new ItemStackMap();
    private final Set checkedItems = new ItemStackSet();
    private AdjacentInventoryCache invCache = new AdjacentInventoryCache(this, new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            return !(tile instanceof TileItemLoader);
        }
    }, InventorySorter.SIZE_DECENDING);
    private final InventoryMapper invBuffer;

    public TileItemLoader() {
        this.setInventorySize(9);
        this.invBuffer = new InventoryMapper((IInventory)this, false);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.ITEM_LOADER;
    }

    @Override
    public Icon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public Slot getBufferSlot(int id, int x, int y) {
        return new Slot((IInventory)this, id, x, y);
    }

    public ForgeDirection getOrientation() {
        return ForgeDirection.DOWN;
    }

    @Override
    public void func_70316_g() {
        TileLoaderItemBase.EnumRedstoneMode state;
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.movedItemCart = false;
        EntityMinecart cart = CartTools.getMinecartOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.1f, this.getOrientation());
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.transferedItems.clear();
            this.cartWasSent();
        }
        if (cart == null) {
            return;
        }
        IInventory cartInv = null;
        if (cart instanceof IInventory) {
            cartInv = (IInventory)cart;
        }
        if (cartInv == null || cartInv.func_70302_i_() <= 0) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f) || cart.isPoweredCart()) {
                this.setPowered(true);
            }
            return;
        }
        if (this.isSendCartGateAction()) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        ItemStack minecartSlot1 = this.getCartFilters().func_70301_a(0);
        ItemStack minecartSlot2 = this.getCartFilters().func_70301_a(1);
        if (!(minecartSlot1 == null && minecartSlot2 == null || CartTools.doesCartMatchFilter(minecartSlot1, cart) || CartTools.doesCartMatchFilter(minecartSlot2, cart))) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        if (this.actions.contains(Actions.PAUSE)) {
            return;
        }
        LinkedList<InventoryMapper> chests = new LinkedList<InventoryMapper>(this.invCache.getAdjecentInventories());
        chests.addFirst(this.invBuffer);
        this.checkedItems.clear();
        block0 : switch (this.getMode()) {
            case TRANSFER: {
                ItemStack moved;
                boolean hasFilter = false;
                for (ItemStack filter : this.getItemFilters().getContents()) {
                    ItemStack moved2;
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    hasFilter = true;
                    Short numMoved = (Short)this.transferedItems.get(filter);
                    if (numMoved == null) {
                        numMoved = 0;
                    }
                    if (numMoved >= InvTools.countItems((IInventory)this.getItemFilters(), filter) || (moved2 = InvTools.moveOneItem(chests, cartInv, filter)) == null) continue;
                    this.movedItemCart = true;
                    Short s = numMoved;
                    Short s2 = numMoved = Short.valueOf((short)(numMoved + 1));
                    this.transferedItems.put(moved2, numMoved);
                    break;
                }
                if (hasFilter || (moved = InvTools.moveOneItem(chests, cartInv, new ItemStack[0])) == null) break;
                this.movedItemCart = true;
                break;
            }
            case STOCK: {
                for (ItemStack filter : this.getItemFilters().getContents()) {
                    ItemStack moved;
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    int stocked = InvTools.countItems(cartInv, filter);
                    if (stocked >= InvTools.countItems((IInventory)this.getItemFilters(), filter) || (moved = InvTools.moveOneItem(chests, cartInv, filter)) == null) continue;
                    this.movedItemCart = true;
                    break block0;
                }
                break;
            }
            case EXCESS: {
                for (ItemStack filter : this.getItemFilters().getContents()) {
                    ItemStack moved;
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    int stocked = InvTools.countItems(chests, filter);
                    if (stocked <= InvTools.countItems((IInventory)this.getItemFilters(), filter) || (moved = InvTools.moveOneItem(chests, cartInv, filter)) == null) continue;
                    this.movedItemCart = true;
                    break;
                }
                if (this.movedItemCart) break;
                this.movedItemCart = InvTools.moveOneItemExcept(chests, cartInv, this.getItemFilters().getContents()) != null;
                break;
            }
            case ALL: {
                ItemStack moved;
                boolean hasFilter = false;
                for (ItemStack filter : this.getItemFilters().getContents()) {
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    hasFilter = true;
                    ItemStack moved3 = InvTools.moveOneItem(chests, cartInv, filter);
                    if (moved3 == null) continue;
                    this.movedItemCart = true;
                    break;
                }
                if (hasFilter || (moved = InvTools.moveOneItem(chests, cartInv, new ItemStack[0])) == null) break;
                this.movedItemCart = true;
                break;
            }
        }
        if (this.movedItemCart) {
            this.setPowered(false);
        }
        if ((state = (TileLoaderItemBase.EnumRedstoneMode)this.getRedstoneModeController().getButtonState()) != TileLoaderItemBase.EnumRedstoneMode.MANUAL && !this.isPowered() && (CartTools.cartVelocityIsLessThan(cart, 0.02f) || cart.isPoweredCart())) {
            if (!this.movedItemCart && state != TileLoaderItemBase.EnumRedstoneMode.COMPLETE) {
                if (state == TileLoaderItemBase.EnumRedstoneMode.PARTIAL) {
                    if (!InvTools.isInventoryEmpty(cartInv)) {
                        this.setPowered(true);
                    }
                } else {
                    this.setPowered(true);
                }
            } else if (this.getMode() == TileLoaderItemBase.EnumTransferMode.TRANSFER && this.isTranferComplete(this.getItemFilters().getContents())) {
                this.setPowered(true);
            } else if (this.getMode() == TileLoaderItemBase.EnumTransferMode.STOCK && this.isStockComplete(cartInv, this.getItemFilters().getContents())) {
                this.setPowered(true);
            } else if (this.getMode() == TileLoaderItemBase.EnumTransferMode.EXCESS && this.isExcessComplete(chests, this.getItemFilters().getContents())) {
                this.setPowered(true);
            } else if (this.getMode() == TileLoaderItemBase.EnumTransferMode.ALL && this.isAllComplete(cartInv, this.getItemFilters().getContents())) {
                this.setPowered(true);
            } else if (!this.movedItemCart && InvTools.isInventoryFull(cartInv, this.getOrientation().getOpposite())) {
                this.setPowered(true);
            }
        }
    }

    private boolean isTranferComplete(ItemStack[] filters) {
        this.checkedItems.clear();
        boolean hasFilter = false;
        for (ItemStack filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            hasFilter = true;
            Short numMoved = (Short)this.transferedItems.get(filter);
            if (numMoved != null && numMoved >= InvTools.countItems((IInventory)this.getItemFilters(), filter)) continue;
            return false;
        }
        return hasFilter;
    }

    private boolean isStockComplete(IInventory cart, ItemStack[] filters) {
        this.checkedItems.clear();
        for (ItemStack filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            int stocked = InvTools.countItems(cart, filter);
            if (stocked >= InvTools.countItems((IInventory)this.getItemFilters(), filter)) continue;
            return false;
        }
        return true;
    }

    private boolean isExcessComplete(List chests, ItemStack[] filters) {
        this.checkedItems.clear();
        int max = 0;
        for (ItemStack filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            int stocked = InvTools.countItems(chests, filter);
            max += filter.field_77994_a;
            if (stocked <= InvTools.countItems((IInventory)this.getItemFilters(), filter)) continue;
            return false;
        }
        return InvTools.countItems(chests, new ItemStack[0]) <= max;
    }

    private boolean isAllComplete(IInventory cart, ItemStack[] filters) {
        this.checkedItems.clear();
        boolean hasFilter = false;
        for (ItemStack filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            hasFilter = true;
            if (InvTools.countItems(cart, filter) <= 0) continue;
            return false;
        }
        return hasFilter;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOADER_ITEM, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }
}

