/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SimpleSignalReceiver;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IAspectActionManager;
import mods.railcraft.common.blocks.signals.TileSwitchSecured;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TileSwitchMotor
extends TileSwitchSecured
implements IAspectActionManager,
IGuiReturnHandler,
IReceiverTile {
    private final SimpleSignalReceiver receiver = new SimpleSignalReceiver(this.func_70303_b(), this);
    private boolean[] switchOnAspects = new boolean[SignalAspect.values().length];
    private boolean switchAspect;

    public TileSwitchMotor() {
        this.switchOnAspects[SignalAspect.RED.ordinal()] = true;
    }

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.SWITCH_MOTOR;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (Game.isHost(this.field_70331_k)) {
            GuiHandler.openGui(EnumGui.SWITCH_MOTOR, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.field_70331_k)) {
            this.receiver.tickClient();
            return;
        }
        this.receiver.tickServer();
        boolean active = this.isSwitchAspect();
        if (this.switchAspect != active) {
            this.switchAspect = active;
            this.switchTrack(this.switchAspect || this.isPowered());
        }
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        boolean power = this.isBeingPowered(Block.field_72075_av.field_71990_ca == blockId);
        if (this.isPowered() != power) {
            this.setPowered(power);
            this.switchTrack(this.switchAspect || this.isPowered());
        }
    }

    @Override
    public boolean canConnectRedstone(int dir) {
        return true;
    }

    private boolean isBeingPowered(boolean testRedstone) {
        return PowerPlugin.isBlockBeingPowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n) || testRedstone && PowerPlugin.isRedstonePowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    private boolean isSwitchAspect() {
        return this.switchOnAspects[this.receiver.getAspect().ordinal()];
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        byte[] array = new byte[this.switchOnAspects.length];
        for (int i = 0; i < this.switchOnAspects.length; ++i) {
            array[i] = (byte)(this.switchOnAspects[i] ? 1 : 0);
        }
        data.func_74773_a("PowerOnAspect", array);
        data.func_74757_a("switchAspect", this.switchAspect);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        if (data.func_74764_b("PowerOnAspect")) {
            byte[] array = data.func_74770_j("PowerOnAspect");
            for (int i = 0; i < this.switchOnAspects.length; ++i) {
                this.switchOnAspects[i] = array[i] == 1;
            }
        }
        this.switchAspect = data.func_74767_n("switchAspect");
        this.receiver.readFromNBT(data);
        if (data.func_74764_b("ControllerX")) {
            int cx = data.func_74762_e("ControllerX");
            int cy = data.func_74762_e("ControllerY");
            int cz = data.func_74762_e("ControllerZ");
            this.receiver.registerLegacyController(cx, cy, cz);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
        this.writeGuiData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
        this.readGuiData(data, null);
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        super.writeGuiData(data);
        int bits = 0;
        for (int i = 0; i < this.switchOnAspects.length; ++i) {
            bits = (byte)(bits | (this.switchOnAspects[i] ? 1 : 0) << i);
        }
        data.writeByte(bits);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        super.readGuiData(data, sender);
        byte bits = data.readByte();
        for (int bit = 0; bit < this.switchOnAspects.length; ++bit) {
            this.switchOnAspects[bit] = (bits >> bit & 1) == 1;
        }
    }

    @Override
    public boolean doesActionOnAspect(SignalAspect aspect) {
        return this.switchOnAspects[aspect.ordinal()];
    }

    @Override
    public void doActionOnAspect(SignalAspect aspect, boolean trigger) {
        this.switchOnAspects[aspect.ordinal()] = trigger;
    }

    @Override
    public SimpleSignalReceiver getReceiver() {
        return this.receiver;
    }
}

