/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackTile;
import mods.railcraft.api.tracks.TrackRegistry;
import mods.railcraft.api.tracks.TrackSpec;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TileTrack
extends RailcraftTileEntity
implements ITrackTile,
IGuiReturnHandler {
    public ITrackInstance track;

    public TileTrack() {
    }

    public TileTrack(ITrackInstance t) {
        this.track = t;
        this.track.setTile(this);
    }

    @Override
    public String func_70303_b() {
        return RailcraftLanguage.translate(this.track.getTrackSpec().getTrackTag());
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("trackId", (int)this.getId());
        this.track.writeToNBT(data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        TrackSpec spec = TrackRegistry.getTrackSpec(data.func_74762_e("trackId"));
        this.track = spec.createInstanceFromSpec();
        this.track.setTile(this);
        this.track.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        if (this.track != null) {
            this.track.writePacketData(data);
        }
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        if (this.track != null) {
            this.track.readPacketData(data);
        }
    }

    public boolean canUpdate() {
        return this.track.canUpdate();
    }

    @Override
    public void func_70316_g() {
        this.track.updateEntity();
    }

    @Override
    public short getId() {
        return this.track.getTrackSpec().getTrackId();
    }

    @Override
    public ITrackInstance getTrackInstance() {
        this.track.setTile(this);
        return this.track;
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        if (this.track instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.track)).writeGuiData(data);
        }
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        if (this.track instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.track)).readGuiData(data, sender);
        }
    }
}

