/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class TrackDisembark
extends TrackBaseRailcraft
implements ITrackPowered {
    private static final int TIME_TILL_NEXT_MOUNT = 40;
    private boolean powered = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.DISEMBARK;
    }

    @Override
    public Icon getIcon() {
        if (this.isPowered()) {
            return this.getIcon(0);
        }
        return this.getIcon(1);
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (this.powered && cart.canBeRidden() && cart.field_70153_n != null) {
            cart.field_70153_n.func_70078_a(null);
            cart.getEntityData().func_74768_a("MountPrevention", 40);
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean p = data.readBoolean();
        if (p != this.powered) {
            this.powered = p;
            this.markBlockNeedsUpdate();
        }
    }
}

