/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import buildcraft.api.inventory.ISpecialInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.carts.ICartContentsTextureProvider;
import mods.railcraft.api.carts.IItemTransfer;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ItemCart;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.TransferCartBase;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryCopy;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.ChunkManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.IAnchor;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeDirection;

public class EntityCartAnchor
extends TransferCartBase
implements ICartContentsTextureProvider,
IAnchor,
ISpecialInventory,
IMinecart {
    private static final long TICK_PER_HOUR = 72000L;
    public static final byte TICKET_FLAG = 6;
    private static final byte ANCHOR_RADIUS = 1;
    private static final byte MAX_CHUNKS = 12;
    protected ForgeChunkManager.Ticket ticket;
    private Set chunks;
    private boolean first = true;
    private long anchorFuel;
    private IInventory invWrapper = new InventoryMapper(this);

    public EntityCartAnchor(World world) {
        super(world);
        this.passThrough = true;
    }

    public EntityCartAnchor(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.passThrough = true;
    }

    private boolean hasFuel() {
        return this.anchorFuel > 0L;
    }

    public void setAnchorFuel(long fuel) {
        this.anchorFuel = fuel;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            if (this.func_70083_f(6)) {
                if (this.chunks != null) {
                    EffectManager.instance.chunkLoaderEffect(this.field_70170_p, this, this.chunks);
                } else {
                    this.setupChunks(this.field_70176_ah, this.field_70164_aj);
                }
            }
            return;
        }
        if (RailcraftConfig.deleteAnchors()) {
            this.func_70106_y();
            return;
        }
        int hoursPerFeeding = this.getRefuelTime();
        if (hoursPerFeeding > 0) {
            if (this.ticket != null && this.anchorFuel > 0L) {
                --this.anchorFuel;
            }
            if (this.anchorFuel <= 0L) {
                this.stockFuel();
                ItemStack stack = this.func_70301_a(0);
                if (stack == null || stack.field_77994_a <= 0) {
                    this.func_70299_a(0, null);
                    this.releaseTicket();
                } else if (stack.field_77993_c == RailcraftConfig.anchorFuelItemID()) {
                    this.func_70298_a(0, 1);
                    this.anchorFuel = (long)hoursPerFeeding * 72000L;
                }
            }
        }
        if (this.ticket == null) {
            this.requestTicket();
        }
    }

    private void stockFuel() {
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart link = lm.getLinkedCartA((EntityMinecart)this);
        if (link instanceof IItemTransfer) {
            this.requestFuel((IItemTransfer)link);
        }
        if ((link = lm.getLinkedCartB((EntityMinecart)this)) instanceof IItemTransfer) {
            this.requestFuel((IItemTransfer)link);
        }
    }

    private void requestFuel(IItemTransfer cart) {
        ItemStack stack = this.func_70301_a(0);
        if (stack != null && stack.field_77993_c != RailcraftConfig.anchorFuelItemID()) {
            stack = cart.offerItem(this, stack);
            this.func_70299_a(0, stack);
            return;
        }
        if (stack == null && (stack = cart.requestItem((Object)this, new ItemStack(RailcraftConfig.anchorFuelItemID(), 1, 0))) != null) {
            InvTools.moveItemStack(stack, this);
        }
    }

    protected ForgeChunkManager.Ticket getTicketFromForge() {
        return ForgeChunkManager.requestTicket((Object)Railcraft.getMod(), (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
    }

    protected int getRefuelTime() {
        return RailcraftConfig.anchorRefuel();
    }

    protected boolean meetsTicketRequirements() {
        return this.hasFuel() || this.getRefuelTime() <= 0;
    }

    protected void releaseTicket() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        this.ticket = null;
        this.func_70052_a(6, false);
    }

    private boolean requestTicket() {
        ForgeChunkManager.Ticket chunkTicket;
        if (this.meetsTicketRequirements() && (chunkTicket = this.getTicketFromForge()) != null) {
            chunkTicket.getModData();
            chunkTicket.setChunkListDepth(12);
            chunkTicket.bindEntity((Entity)this);
            this.setChunkTicket(chunkTicket);
            return true;
        }
        return false;
    }

    public void setChunkTicket(ForgeChunkManager.Ticket tick) {
        if (this.ticket != tick) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
        this.ticket = tick;
        this.func_70052_a(6, this.ticket != null);
    }

    public void forceChunkLoading(int xChunk, int zChunk) {
        if (this.ticket == null) {
            return;
        }
        this.setupChunks(xChunk, zChunk);
        for (ChunkCoordIntPair chunk : this.chunks) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)chunk);
            ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)chunk);
        }
        ChunkCoordIntPair myChunk = new ChunkCoordIntPair(xChunk, zChunk);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)myChunk);
        ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)myChunk);
    }

    public void setupChunks(int xChunk, int zChunk) {
        this.chunks = this.func_70083_f(6) ? ChunkManager.getInstance().getChunksAround(xChunk, zChunk, 1) : null;
    }

    protected void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        data.func_74772_a("anchorFuel", this.anchorFuel);
    }

    protected void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        if (this.getRefuelTime() > 0) {
            this.anchorFuel = data.func_74763_f("anchorFuel");
        }
    }

    @Override
    public void func_70106_y() {
        this.releaseTicket();
        super.func_70106_y();
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p) && this.getRefuelTime() > 0) {
            GuiHandler.openGui(EnumGui.CART_ANCHOR, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    @Override
    public List getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    @Override
    public ItemStack getCartItem() {
        ItemStack drop = super.getCartItem();
        if (this.getRefuelTime() > 0 && this.hasFuel()) {
            NBTTagCompound nbt = new NBTTagCompound("tag");
            nbt.func_74772_a("fuel", this.anchorFuel);
            drop.func_77982_d(nbt);
        }
        return drop;
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return ItemCart.getCartType(stack) == EnumCart.ANCHOR;
    }

    public boolean canBeRidden() {
        return false;
    }

    public int func_70302_i_() {
        return this.getRefuelTime() > 0 ? 1 : 0;
    }

    public String func_70303_b() {
        return RailcraftLanguage.translate(EnumCart.ANCHOR.getTag());
    }

    public Block func_94089_m() {
        return RailcraftBlocks.getBlockMachineAlpha();
    }

    public int func_94098_o() {
        return EnumMachineAlpha.WORLD_ANCHOR.ordinal();
    }

    @Override
    public Icon getBlockTextureOnSide(int side) {
        if (side < 2 && !this.func_70083_f(6)) {
            return EnumMachineAlpha.WORLD_ANCHOR.getTexture(6);
        }
        return EnumMachineAlpha.WORLD_ANCHOR.getTexture(side);
    }

    @Override
    public long getAnchorFuel() {
        return this.anchorFuel;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        ItemStack remainder;
        if (!RailcraftConfig.anchorsCanInteractWithPipes()) {
            return 0;
        }
        if (stack == null) {
            return 0;
        }
        if (stack.field_77993_c != RailcraftConfig.anchorFuelItemID()) {
            return 0;
        }
        stack = stack.func_77946_l();
        IInventory inv = this.invWrapper;
        if (!doAdd) {
            inv = new InventoryCopy(inv);
        }
        if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
            return stack.field_77994_a;
        }
        return stack.field_77994_a - remainder.field_77994_a;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        IInventory inv = this.invWrapper;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return InvTools.removeItems(inv, maxItemCount);
    }

    @Override
    public double getDrag() {
        return 0.991999979019165;
    }
}

