/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.aesthetics.post.ItemPost;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.carts.CartMaintanceBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.util.misc.BallastRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class EntityCartUndercutter
extends CartMaintanceBase {
    public static final Set EXCLUDED_BLOCKS = new HashSet();
    private static final int SLOT_EXIST_UNDER_A = 0;
    private static final int SLOT_EXIST_UNDER_B = 1;
    private static final int SLOT_EXIST_SIDE_A = 2;
    private static final int SLOT_EXIST_SIDE_B = 3;
    private static final int SLOT_REPLACE_UNDER = 4;
    private static final int SLOT_REPLACE_SIDE = 5;
    public static final int SLOT_STOCK_UNDER = 0;
    public static final int SLOT_STOCK_SIDE = 1;

    public static boolean isValidBallast(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (EXCLUDED_BLOCKS.contains(stack.field_77993_c)) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBlock && Block.field_71973_m[stack.field_77993_c].func_71926_d()) {
            return true;
        }
        return stack.func_77973_b() instanceof ItemPost;
    }

    public EntityCartUndercutter(World world) {
        super(world);
    }

    public EntityCartUndercutter(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    @Override
    public void func_70071_h_() {
        int id;
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        this.stockItems(4, 0);
        this.stockItems(5, 1);
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (BlockRailBase.func_72180_d_((World)this.field_70170_p, (int)x, (int)(y - 1), (int)z)) {
            --y;
        }
        if (BlockRailBase.func_72184_d((int)(id = this.field_70170_p.func_72798_a(x, y, z)))) {
            EnumTrackMeta trackMeta = EnumTrackMeta.fromMeta(((BlockRailBase)Block.field_71973_m[id]).getBasicRailMetadata((IBlockAccess)this.field_70170_p, (EntityMinecart)this, x, y, z));
            this.replaceUnder(x, --y, z, 0);
            this.replaceUnder(x, y, z, 1);
            this.replaceSide(x, y, z, 2, trackMeta);
            this.replaceSide(x, y, z, 3, trackMeta);
        }
    }

    private void replaceUnder(int x, int y, int z, int slotExist) {
        this.replaceWith(x, y, z, slotExist, 0);
    }

    private void replaceSide(int x, int y, int z, int slotExist, EnumTrackMeta trackMeta) {
        if (trackMeta.isEastWestTrack()) {
            this.replaceWith(x, y, z + 1, slotExist, 1);
            this.replaceWith(x, y, z - 1, slotExist, 1);
        } else if (trackMeta.isNorthSouthTrack()) {
            this.replaceWith(x + 1, y, z, slotExist, 1);
            this.replaceWith(x - 1, y, z, slotExist, 1);
        }
    }

    private void replaceWith(int x, int y, int z, int slotExist, int slotStock) {
        ItemStack exist = this.patternInv.func_70301_a(slotExist);
        ItemStack stock = this.func_70301_a(slotStock);
        if (exist != null && exist.func_77973_b() instanceof ItemBlock && EntityCartUndercutter.isValidBallast(stock)) {
            ItemBlock existItem = (ItemBlock)exist.func_77973_b();
            int existMeta = 0;
            if (existItem.func_77614_k()) {
                existMeta = existItem.func_77647_b(exist.func_77960_j());
            }
            int id = this.field_70170_p.func_72798_a(x, y, z);
            int oldMeta = this.field_70170_p.func_72805_g(x, y, z);
            if ((exist.field_77993_c == id && oldMeta == existMeta || exist.field_77993_c == Block.field_71979_v.field_71990_ca && id == Block.field_71980_u.field_71990_ca) && (!BallastRegistry.isItemBallast(stock) || !this.field_70170_p.func_72799_c(x, y - 1, z) && !(Block.field_71973_m[this.field_70170_p.func_72798_a(x, y - 1, z)] instanceof BlockFluid))) {
                ArrayList drops = Block.field_71973_m[id].getBlockDropped(this.field_70170_p, x, y, z, oldMeta, 0);
                ItemBlock item = (ItemBlock)stock.func_77973_b();
                int newMeta = 0;
                if (item.func_77614_k()) {
                    newMeta = item.func_77647_b(stock.func_77960_j());
                }
                if (this.field_70170_p.func_72832_d(x, y, z, stock.field_77993_c, newMeta, 3)) {
                    SoundHelper.playBlockSound(this.field_70170_p, x, y, z, Block.field_71973_m[stock.field_77993_c].field_72020_cn.func_82593_b(), 1.0f, 0.8f, stock.field_77993_c, newMeta);
                    this.func_70298_a(slotStock, 1);
                    for (ItemStack stack : drops) {
                        CartTools.offerOrDropItem((EntityMinecart)this, stack);
                    }
                    this.blink();
                }
            }
        }
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            GuiHandler.openGui(EnumGui.CART_UNDERCUTTER, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    public String func_70303_b() {
        return RailcraftLanguage.translate(EnumCart.UNDERCUTTER.getTag());
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        return 0;
    }

    static {
        EXCLUDED_BLOCKS.add(Block.field_71939_E.field_71990_ca);
    }
}

