/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.item.IBoxable;
import java.util.List;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public class ItemCrowbar
extends ItemTool
implements IToolCrowbar,
IBoxable,
IToolWrench {
    public static final byte BOOST_DAMAGE = 3;
    private static final String ITEM_TAG = "railcraft.tool.crowbar";
    private static Item item;

    public static void registerItem() {
        int id;
        if (item == null && (id = RailcraftConfig.getItemId(ITEM_TAG)) > 0) {
            item = new ItemCrowbar(id);
            GameRegistry.registerItem((Item)item, (String)ITEM_TAG);
            MinecraftForge.setToolClass((Item)item, (String)"crowbar", (int)0);
            RailcraftLanguage.instance().registerItemName(item, ITEM_TAG);
            CraftingPlugin.addShapedOreRecipe(new ItemStack(item), " RI", "RIR", "IR ", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('R'), "dyeRed");
            LootPlugin.addLootTool(new ItemStack(item), 1, 1, ITEM_TAG);
            ItemRegistry.registerItem(ITEM_TAG, new ItemStack(item));
        }
    }

    public static ItemStack getCrowbar() {
        if (item == null) {
            return null;
        }
        return new ItemStack(item);
    }

    public ItemCrowbar(int id) {
        this(id, EnumToolMaterial.IRON);
        this.func_77655_b(ITEM_TAG);
    }

    protected ItemCrowbar(int id, EnumToolMaterial material) {
        super(id, 3, material, new Block[]{Block.field_72056_aG, Block.field_71953_U, Block.field_71954_T, Block.field_94337_cv});
    }

    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(this.func_77658_a()));
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        int blockId = world.func_72798_a(x, y, z);
        if (Block.field_71973_m[blockId].rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
            player.func_71038_i();
            stack.func_77972_a(1, (EntityLiving)player);
            return Game.isHost(world);
        }
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        return true;
    }

    @Override
    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        player.func_71045_bC().func_77972_a(1, (EntityLiving)player);
        player.func_71038_i();
    }

    @Override
    public boolean canWhack(EntityPlayer player, ItemStack crowbar, int x, int y, int z) {
        return true;
    }

    @Override
    public void onWhack(EntityPlayer player, ItemStack crowbar, int x, int y, int z) {
        crowbar.func_77972_a(1, (EntityLiving)player);
        player.func_71038_i();
    }

    @Override
    public boolean canLink(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        return player.func_70093_af();
    }

    @Override
    public void onLink(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        crowbar.func_77972_a(1, (EntityLiving)player);
        player.func_71038_i();
    }

    @Override
    public boolean canBoost(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        return !player.func_70093_af();
    }

    @Override
    public void onBoost(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        crowbar.func_77972_a(3, (EntityLiving)player);
        player.func_71038_i();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean advInfo) {
        info.add(RailcraftLanguage.translate("gui.tip.crowbar.link"));
    }
}

