/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.liquids;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mods.railcraft.common.liquids.ImmutableTankWrapper;
import mods.railcraft.common.liquids.tanks.StandardTank;
import mods.railcraft.common.util.misc.AdjacentTileCache;
import mods.railcraft.common.util.misc.ITileFilter;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TankManager
implements ITankContainer {
    public static final ITileFilter TANK_FILTER = new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            return tile instanceof ITankContainer;
        }
    };
    private static final byte NETWORK_DATA = 3;
    private List tanks = new ArrayList();
    private List prevLiquids = new ArrayList();

    public void addTank(StandardTank tank) {
        this.tanks.add(tank);
        int index = this.tanks.indexOf((Object)tank);
        tank.setTankIndex(index);
        this.prevLiquids.add(tank.getLiquid() == null ? null : tank.getLiquid().copy());
    }

    public void addTanks(Collection tanks) {
        for (StandardTank tank : tanks) {
            this.addTank(tank);
        }
    }

    public void addTanks(StandardTank[] tanks) {
        for (StandardTank tank : tanks) {
            this.addTank(tank);
        }
    }

    public void writeTanksToNBT(NBTTagCompound data) {
        NBTTagList tagList = new NBTTagList();
        for (byte slot = 0; slot < this.tanks.size(); slot = (byte)((byte)(slot + 1))) {
            StandardTank tank = (StandardTank)((Object)this.tanks.get(slot));
            if (tank.getLiquid() == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("tank", slot);
            tank.writeToNBT(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("tanks", (NBTBase)tagList);
    }

    public void readTanksFromNBT(NBTTagCompound data) {
        NBTTagList tagList = data.func_74761_m("tanks");
        for (int tagIndex = 0; tagIndex < tagList.func_74745_c(); ++tagIndex) {
            NBTTagCompound tag = (NBTTagCompound)tagList.func_74743_b(tagIndex);
            byte slot = tag.func_74771_c("tank");
            if (slot < 0 || slot >= this.tanks.size()) continue;
            ((StandardTank)((Object)this.tanks.get(slot))).readFromNBT(tag);
        }
    }

    public void writePacketData(DataOutputStream data) throws IOException {
        for (int i = 0; i < this.tanks.size(); ++i) {
            this.writePacketData(data, i);
        }
    }

    public void writePacketData(DataOutputStream data, int tankIndex) throws IOException {
        if (tankIndex >= this.tanks.size()) {
            return;
        }
        ILiquidTank tank = (ILiquidTank)this.tanks.get(tankIndex);
        LiquidStack liquid = tank.getLiquid();
        if (liquid == null) {
            liquid = new LiquidStack(0, 0, 0);
        }
        data.writeShort(liquid.itemID);
        data.writeShort(liquid.itemMeta);
        data.writeInt(liquid.amount);
    }

    public void readPacketData(DataInputStream data) throws IOException {
        for (int i = 0; i < this.tanks.size(); ++i) {
            this.readPacketData(data, i);
        }
    }

    public void readPacketData(DataInputStream data, int tankIndex) throws IOException {
        if (tankIndex >= this.tanks.size()) {
            return;
        }
        LiquidTank tank = (LiquidTank)this.tanks.get(tankIndex);
        short itemID = data.readShort();
        short itemMeta = data.readShort();
        int amount = data.readInt();
        LiquidStack liquid = new LiquidStack((int)itemID, amount, (int)itemMeta);
        if (liquid.itemID == 0) {
            liquid = null;
        }
        tank.setLiquid(liquid);
    }

    public void initGuiData(Container container, ICrafting player, int tankIndex) {
        if (tankIndex >= this.tanks.size()) {
            return;
        }
        LiquidStack liquid = ((StandardTank)((Object)this.tanks.get(tankIndex))).getLiquid();
        int liquidId = 0;
        int liquidMeta = 0;
        int liquidQty = 0;
        if (liquid != null) {
            liquidId = liquid.itemID;
            liquidMeta = liquid.itemMeta;
            liquidQty = liquid.amount;
        }
        player.func_71112_a(container, tankIndex * 3 + 0, liquidId);
        player.func_71112_a(container, tankIndex * 3 + 1, liquidMeta);
        PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayer)player, container.field_75152_c, tankIndex * 3 + 2, liquidQty);
    }

    public void updateGuiData(Container container, List crafters, int tankIndex) {
        for (int i = 0; i < crafters.size(); ++i) {
            LiquidStack prev;
            ICrafting crafter = (ICrafting)crafters.get(i);
            EntityPlayer player = (EntityPlayer)crafters.get(i);
            LiquidStack liquid = ((StandardTank)((Object)this.tanks.get(tankIndex))).getLiquid();
            if (liquid == null ^ (prev = (LiquidStack)this.prevLiquids.get(tankIndex)) == null) {
                int liquidId = 0;
                int liquidMeta = 0;
                int liquidQty = 0;
                if (liquid != null) {
                    liquidId = liquid.itemID;
                    liquidMeta = liquid.itemMeta;
                    liquidQty = liquid.amount;
                }
                crafter.func_71112_a(container, tankIndex * 3 + 0, liquidId);
                crafter.func_71112_a(container, tankIndex * 3 + 1, liquidMeta);
                PacketBuilder.instance().sendGuiIntegerPacket(player, container.field_75152_c, tankIndex * 3 + 2, liquidQty);
                continue;
            }
            if (liquid == null || prev == null) continue;
            if (liquid.itemID != prev.itemID) {
                crafter.func_71112_a(container, tankIndex * 3 + 0, liquid.itemID);
            }
            if (liquid.itemMeta != prev.itemMeta) {
                crafter.func_71112_a(container, tankIndex * 3 + 1, liquid.itemMeta);
            }
            if (liquid.amount == prev.amount) continue;
            PacketBuilder.instance().sendGuiIntegerPacket(player, container.field_75152_c, tankIndex * 3 + 2, liquid.amount);
        }
        ILiquidTank tank = (ILiquidTank)this.tanks.get(tankIndex);
        this.prevLiquids.set(tankIndex, tank.getLiquid() == null ? null : tank.getLiquid().copy());
    }

    public void processGuiUpdate(int messageId, int data) {
        int tankIndex = messageId / 3;
        if (tankIndex >= this.tanks.size()) {
            return;
        }
        LiquidStack liquid = ((StandardTank)((Object)this.tanks.get(tankIndex))).getLiquid();
        if (liquid == null) {
            liquid = new LiquidStack(0, 0);
            ((StandardTank)((Object)this.tanks.get(tankIndex))).setLiquid(liquid);
        }
        int itemId = liquid.itemID;
        int itemMeta = liquid.itemMeta;
        int amount = liquid.amount;
        boolean newLiquid = false;
        switch (messageId % 3) {
            case 0: {
                itemId = data;
                newLiquid = true;
                break;
            }
            case 1: {
                itemMeta = data;
                newLiquid = true;
                break;
            }
            case 2: {
                amount = data;
            }
        }
        if (newLiquid) {
            liquid = new LiquidStack(itemId, amount, itemMeta);
            ((StandardTank)((Object)this.tanks.get(tankIndex))).setLiquid(liquid);
        }
        liquid.amount = amount;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size() || resource == null) {
            return 0;
        }
        return ((StandardTank)((Object)this.tanks.get(tankIndex))).fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size()) {
            return null;
        }
        return ((StandardTank)((Object)this.tanks.get(tankIndex))).drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        ILiquidTank[] result = new ILiquidTank[this.tanks.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ImmutableTankWrapper((ILiquidTank)this.tanks.get(i));
        }
        return result;
    }

    public ILiquidTank[] getTanks() {
        return this.getTanks(ForgeDirection.UNKNOWN);
    }

    public StandardTank getTank(int tankIndex) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size()) {
            return null;
        }
        return (StandardTank)((Object)this.tanks.get(tankIndex));
    }

    public void setCapacity(int tankIndex, int capacity) {
        StandardTank tank = this.getTank(tankIndex);
        tank.setCapacity(capacity);
        LiquidStack liquid = tank.getLiquid();
        if (liquid != null && liquid.amount > capacity) {
            liquid.amount = capacity;
        }
    }

    public void outputLiquid(AdjacentTileCache cache, ITileFilter filter, ForgeDirection[] sides, int tankIndex, int amount) {
        for (ForgeDirection side : sides) {
            ITankContainer tank;
            TileEntity tile = cache.getTileOnSide(side);
            if (!filter.matches(tile) || (tank = TankManager.getTankFromTile(tile)) == null) continue;
            this.outputLiquid((ITankContainer)tile, side, tankIndex, amount);
        }
    }

    public void outputLiquid(ITankContainer[] outputs, int tankIndex, int amount) {
        for (int side = 0; side < 6; ++side) {
            ITankContainer nearbyTank = outputs[side];
            if (nearbyTank == null) continue;
            this.outputLiquid(nearbyTank, ForgeDirection.getOrientation((int)side), tankIndex, amount);
        }
    }

    public static ITankContainer getTankFromTile(TileEntity tile) {
        ITankContainer tank = null;
        if (tile instanceof ITankContainer) {
            tank = (ITankContainer)tile;
        }
        return tank;
    }

    private void outputLiquid(ITankContainer tank, ForgeDirection side, int tankIndex, int amount) {
        int used;
        side = side.getOpposite();
        LiquidStack available = this.drain(tankIndex, amount, false);
        if (available != null && (used = tank.fill(side, available, true)) > 0) {
            this.drain(tankIndex, used, true);
        }
    }

    private boolean tankMatchesLiquid(ILiquidTank tank, LiquidStack liquid) {
        if (liquid == null) {
            return false;
        }
        if (tank.fill(liquid, false) > 0) {
            return true;
        }
        return liquid.isLiquidEqual(tank.getLiquid());
    }

    public ILiquidTank getTank(ForgeDirection side, LiquidStack type) {
        if (type == null) {
            return null;
        }
        for (ILiquidTank tank : this.tanks) {
            if (!this.tankMatchesLiquid(tank, type)) continue;
            return tank;
        }
        return null;
    }
}

