/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import java.util.EnumSet;
import java.util.Set;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.detector.BlockDetector;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.items.ItemRoutingTable;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.items.ItemTicketGold;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.modules.AbstractModule;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.util.crafting.RoutingTableCopyRecipe;
import mods.railcraft.common.util.crafting.RoutingTicketCopyRecipe;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class ModuleRouting
extends AbstractModule {
    @Override
    public Set getDependancies() {
        return EnumSet.of(ModuleManager.Module.SIGNALS);
    }

    @Override
    public boolean canModuleLoad() {
        return true;
    }

    @Override
    public void initFirst() {
        BlockDetector.registerBlock();
        ItemRoutingTable.registerItem();
        ItemTicketGold.registerItem();
        ItemTicket.registerItem();
        MiscTools.registerTrack(EnumTrack.ROUTING);
        if (ItemRoutingTable.item != null) {
            CraftingPlugin.addRecipe(new RoutingTableCopyRecipe());
        }
        if (ItemTicket.item != null && ItemTicketGold.item != null) {
            CraftingPlugin.addRecipe(new RoutingTicketCopyRecipe());
        }
        if (EnumDetector.ROUTING.isEnabled()) {
            CraftingPlugin.addShapedRecipe(EnumDetector.ROUTING.getItem(), "XXX", "XPX", "XXX", Character.valueOf('X'), new ItemStack(Block.field_94339_ct, 1, 1), Character.valueOf('P'), Block.field_72044_aK);
            RailcraftBlocks.registerBlockSignal();
            if (RailcraftBlocks.getBlockSignal() != null && EnumSignal.SWITCH_ROUTING.isEnabled() && EnumSignal.SWITCH_MOTOR.isEnabled()) {
                ItemStack stack = EnumSignal.SWITCH_ROUTING.getItem();
                CraftingPlugin.addShapelessRecipe(stack, EnumSignal.SWITCH_MOTOR.getItem(), EnumDetector.ROUTING.getItem());
                RailcraftLanguage.instance().registerItemName(stack, EnumSignal.SWITCH_ROUTING.getTag());
            }
        }
    }
}

