/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.buildcraft.actions;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import mods.railcraft.common.lang.RailcraftLanguage;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;

public enum Actions implements IAction
{
    PAUSE(400, "pause"),
    SEND_CART(401, "sendcart");

    public static final Actions[] VALUES;
    private static final IIconProvider ICON_PROVIDER;
    private final int id;
    private final String tag;

    /*
     * WARNING - void declaration
     */
    private Actions() {
        void tag;
        void id;
        this.id = id;
        this.tag = tag;
    }

    public static void init() {
        for (Actions trigger : VALUES) {
            ActionManager.actions[trigger.id] = trigger;
        }
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final int getIconIndex() {
        return this.ordinal();
    }

    @Override
    public final IIconProvider getIconProvider() {
        return ICON_PROVIDER;
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public String getDescription() {
        return RailcraftLanguage.translate("gates.action." + this.tag);
    }

    static {
        VALUES = Actions.values();
        ICON_PROVIDER = new IconProvider();
    }

    private static class IconProvider
    implements IIconProvider {
        private Icon[] icons;

        private IconProvider() {
        }

        @Override
        public Icon getIcon(int iconIndex) {
            return this.icons[iconIndex];
        }

        @Override
        public void registerIcons(IconRegister iconRegister) {
            this.icons = new Icon[VALUES.length];
            for (Actions action : VALUES) {
                this.icons[action.ordinal()] = iconRegister.func_94245_a("railcraft:buildcraft.gate.action." + action.tag);
            }
        }
    }
}

