/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory.manipulators;

import buildcraft.api.inventory.ISelectiveInventory;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.util.inventory.filters.ArrayStackFilter;
import mods.railcraft.common.util.inventory.manipulators.SpecialManipulator;
import net.minecraft.item.ItemStack;

public class SelectiveManipulator
extends SpecialManipulator {
    private ISelectiveInventory inv;

    public SelectiveManipulator(ISelectiveInventory inv) {
        super(inv);
        this.inv = inv;
    }

    @Override
    protected ItemStack removeStackInternal(IStackFilter filter, boolean doRemove) {
        ArrayStackFilter aFilter;
        if (filter instanceof ArrayStackFilter && (aFilter = (ArrayStackFilter)filter).hasFilter()) {
            Object[] filters = aFilter.getStacks();
            ItemStack[] extracted = this.inv.extractItem(filters, false, false, this.side, 1);
            if (extracted != null && extracted.length == 1 && filter.matches(extracted[0])) {
                if (doRemove) {
                    this.inv.extractItem(filters, false, true, this.side, 1);
                }
                return extracted[0];
            }
            return null;
        }
        return super.removeStackInternal(filter, doRemove);
    }
}

