/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons;

import codechicken.nei.ItemRange;
import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import java.util.HashMap;
import java.util.Map;
import net.bdew.neiaddons.NEIAddons;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Utils {
    public static Class getAndCheckClass(String cls, Class sup) throws ClassNotFoundException {
        Class<?> c = Class.forName(cls);
        if (c != null) {
            if (sup.isAssignableFrom(c)) {
                return c;
            }
            throw new RuntimeException(cls + " doesn't extend " + sup.getName());
        }
        throw new RuntimeException("Can't get " + cls);
    }

    public static void drawCenteredString(FontRenderer f, String s, int x, int y, int color) {
        f.func_78276_b(s, x - f.func_78256_a(s) / 2, y, color);
    }

    public static void safeAddNBTItem(ItemStack item) {
        if (item == null) {
            return;
        }
        API.addNBTItem((ItemStack)item);
    }

    public static void addSubsetForItems(Class cls, String[] fields, String rangeName, int shift) {
        MultiItemRange multi = new MultiItemRange();
        for (String field : fields) {
            try {
                ItemRange range;
                Object item = cls.getField(field).get(null);
                if (item instanceof Item) {
                    range = new ItemRange(((Item)item).field_77779_bT);
                } else if (item instanceof Block) {
                    range = new ItemRange(((Block)item).field_71990_ca);
                } else if (item instanceof Integer) {
                    range = new ItemRange((Integer)item + shift);
                } else {
                    NEIAddons.logWarning("%s.%s (%s) type unknown - %s", cls.getName(), field, item.toString(), item.getClass().getName());
                    continue;
                }
                multi.add(range);
                NEIAddons.logInfo("Registered subset %s: %s", rangeName, range.toString());
            }
            catch (Throwable e) {
                NEIAddons.logWarning("Failed to get %s.%s", cls.getName(), field);
                e.printStackTrace();
            }
        }
        if (multi.ranges.size() > 0) {
            API.addSetRange((String)rangeName, (MultiItemRange)multi);
        }
    }

    public static void addSubsetForItem(Class cls, String field, String rangeName) {
        Utils.addSubsetForItems(cls, new String[]{field}, rangeName, 0);
    }

    public static void addSubsetForItems(Class cls, String[] fields, String rangeName) {
        Utils.addSubsetForItems(cls, fields, rangeName, 0);
    }

    public static boolean isSameItem(ItemStack s1, ItemStack s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.field_77993_c != s2.field_77993_c) {
            return false;
        }
        if (s1.func_77960_j() != s2.func_77960_j()) {
            return false;
        }
        if (s1.func_77978_p() == null && s2.func_77978_p() == null) {
            return true;
        }
        if (s1.func_77978_p() == null || s2.func_77978_p() == null) {
            return false;
        }
        return s1.func_77978_p().equals((Object)s2.func_77978_p());
    }

    public static Map mergeStacks(Map stacks) {
        HashMap merged = new HashMap();
        block0: for (Map.Entry stack : stacks.entrySet()) {
            for (Map.Entry mergedStack : merged.entrySet()) {
                if (!Utils.isSameItem((ItemStack)stack.getKey(), (ItemStack)mergedStack.getKey()) || stack.getValue() != mergedStack.getValue()) continue;
                ++((ItemStack)mergedStack.getKey()).field_77994_a;
                continue block0;
            }
            merged.put(((ItemStack)stack.getKey()).func_77946_l(), stack.getValue());
        }
        return merged;
    }
}

