/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.colour.Colour;
import codechicken.core.colour.ColourARGB;
import codechicken.core.render.PlaceholderTexture;
import codechicken.core.render.TextureSpecial;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Dimension;

public class TextureUtils {
    private static HashMap textureDimensions;
    private static ArrayList iconRegistrars;
    private static lx missingno;

    static {
        MinecraftForge.EVENT_BUS.register((Object)new TextureUtils());
        textureDimensions = new HashMap();
        iconRegistrars = new ArrayList();
    }

    public static void addIconRegistrar(IIconRegister registrar) {
        iconRegistrars.add(registrar);
    }

    @ForgeSubscribe
    public void textureLoad(TextureStitchEvent.Pre event) {
        missingno = event.map.a("missingno");
        for (IIconRegister reg : iconRegistrars) {
            if (reg.atlasIndex() != event.map.a) continue;
            reg.registerIcons((ly)event.map);
        }
    }

    public static lx getMissingno() {
        return missingno;
    }

    public static bio createTextureObject(String textureFile) {
        BufferedImage img = TextureUtils.loadBufferedImage(textureFile);
        return new bio(textureFile, 2, img.getWidth(), img.getHeight(), 10496, 6408, 9728, 9728, img);
    }

    public static int[] loadTextureData(String textureFile) {
        BufferedImage img = TextureUtils.loadBufferedImage(textureFile);
        int[] data = new int[img.getWidth() * img.getHeight()];
        img.getRGB(0, 0, img.getWidth(), img.getHeight(), data, 0, img.getWidth());
        return data;
    }

    public static Colour[] loadTextureColours(String textureFile) {
        int[] idata = TextureUtils.loadTextureData(textureFile);
        Colour[] data = new Colour[idata.length];
        int i = 0;
        while (i < data.length) {
            data[i] = new ColourARGB(idata[i]);
            ++i;
        }
        return data;
    }

    public static InputStream getTextureResource(String textureFile) throws IOException {
        return TextureUtils.engine().g.e().a(textureFile);
    }

    public static BufferedImage loadBufferedImage(String textureFile) {
        try {
            InputStream in = TextureUtils.getTextureResource(textureFile);
            if (in != null) {
                BufferedImage img = TextureUtils.loadBufferedImage(in);
                if (img != null) {
                    textureDimensions.put(textureFile, new Dimension(img.getWidth(), img.getHeight()));
                }
                return img;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load texture file: " + textureFile);
            e.printStackTrace();
        }
        textureDimensions.put(textureFile, new Dimension(0, 0));
        return null;
    }

    public static Dimension getTextureDimension(String textureFile) {
        Dimension dim = (Dimension)textureDimensions.get(textureFile);
        if (dim == null) {
            TextureUtils.loadBufferedImage(textureFile);
            dim = (Dimension)textureDimensions.get(textureFile);
        }
        return dim;
    }

    public static BufferedImage loadBufferedImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public static bge engine() {
        return Minecraft.x().p;
    }

    public static bio createTextureObject(String name, int w, int h) {
        return new bio(name, 2, w, h, 10496, 6408, 9728, 9728, null);
    }

    public static void copySubImg(bio fromTex, int fromX, int fromY, int width, int height, bio toTex, int toX, int toY) {
        int fromWidth = fromTex.d();
        ByteBuffer from = fromTex.h();
        bio tmp = TextureUtils.createTextureObject("tmp", width, height);
        ByteBuffer to = tmp.h();
        from.position(0);
        to.position(0);
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int fp = ((y + fromY) * fromWidth + x + fromX) * 4;
                int tp2 = (y * width + x) * 4;
                to.put(tp2, from.get(fp));
                to.put(tp2 + 1, from.get(fp + 1));
                to.put(tp2 + 2, from.get(fp + 2));
                to.put(tp2 + 3, from.get(fp + 3));
                ++x;
            }
            ++y;
        }
        toTex.a(toX, toY, tmp, false);
    }

    public static void write(byte[] data, int width, int height, bio toTex, int toX, int toY) {
        bio tmp = TextureUtils.createTextureObject("tmp", width, height);
        ByteBuffer to = tmp.h();
        to.position(0);
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int p = (y * width + x) * 4;
                to.put(p, data[p]);
                to.put(p + 1, data[p + 1]);
                to.put(p + 2, data[p + 2]);
                to.put(p + 3, data[p + 3]);
                ++x;
            }
            ++y;
        }
        toTex.a(toX, toY, tmp, false);
    }

    public static boolean refreshTexture(bir map, String name) {
        if (map.getTextureExtry(name) == null) {
            map.setTextureEntry(name, (bil)new PlaceholderTexture(name));
            return true;
        }
        return false;
    }

    public static void bindItemTexture(wm stack) {
        TextureUtils.engine().b(stack.d() == 0 ? "/terrain.png" : "/gui/items.png");
    }

    public static void bindTexture(String string) {
        TextureUtils.engine().b(string);
    }

    public static lx getIconFromTexture(String name, ly iconRegister, boolean animated) {
        bir textureMap = (bir)iconRegister;
        bil entry = textureMap.getTextureExtry(name);
        if (entry != null) {
            return entry;
        }
        TextureSpecial icon = new TextureSpecial(name).setTextureFile(name).useVanillaAnimation(animated);
        textureMap.setTextureEntry(name, (bil)icon);
        return icon;
    }

    public static lx getIconFromTexture(String name, ly iconRegister) {
        return TextureUtils.getIconFromTexture(name, iconRegister, true);
    }

    public static lx getBlankIcon(int size, ly iconRegister) {
        bir textureMap = (bir)iconRegister;
        String s = "blank_" + size;
        if (textureMap.getTextureExtry(s) == null) {
            TextureSpecial icon = new TextureSpecial(s).blank(size);
            textureMap.setTextureEntry(s, (bil)icon);
        }
        return iconRegister.a(s);
    }

    public static TextureSpecial getTextureSpecial(ly iconRegister, String name) {
        bir textureMap = (bir)iconRegister;
        bil entry = textureMap.getTextureExtry(name);
        if (entry != null) {
            throw new IllegalStateException("Texture: " + name + " is already registered");
        }
        TextureSpecial icon = new TextureSpecial(name);
        textureMap.setTextureEntry(name, (bil)icon);
        return icon;
    }

    public static void prepareTexture(int target, int texture, int min_mag_filter, int wrap) {
        GL11.glBindTexture((int)target, (int)texture);
        TextureUtils.engine().a();
        GL11.glTexParameteri((int)target, (int)10241, (int)min_mag_filter);
        GL11.glTexParameteri((int)target, (int)10240, (int)min_mag_filter);
        switch (target) {
            case 32879: {
                GL11.glTexParameteri((int)target, (int)32882, (int)wrap);
            }
            case 3553: {
                GL11.glTexParameteri((int)target, (int)10243, (int)wrap);
            }
            case 3552: {
                GL11.glTexParameteri((int)target, (int)10242, (int)wrap);
            }
        }
    }

    public static interface IIconRegister {
        public void registerIcons(ly var1);

        public int atlasIndex();
    }
}

