/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.ChatFilter;
import com.mumfrey.liteloader.ChatListener;
import com.mumfrey.liteloader.ChatRenderListener;
import com.mumfrey.liteloader.GameLoopListener;
import com.mumfrey.liteloader.InitCompleteListener;
import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.LoginListener;
import com.mumfrey.liteloader.PluginChannelListener;
import com.mumfrey.liteloader.PostRenderListener;
import com.mumfrey.liteloader.PreLoginListener;
import com.mumfrey.liteloader.RenderListener;
import com.mumfrey.liteloader.Tickable;
import com.mumfrey.liteloader.core.HookChat;
import com.mumfrey.liteloader.core.HookLogin;
import com.mumfrey.liteloader.core.HookPluginChannels;
import com.mumfrey.liteloader.core.HookProfiler;
import com.mumfrey.liteloader.core.LiteLoaderLogFormatter;
import com.mumfrey.liteloader.gui.GuiControlsPaginated;
import com.mumfrey.liteloader.util.ModUtilities;
import com.mumfrey.liteloader.util.PrivateFields;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.activity.InvalidActivityException;
import net.minecraft.client.Minecraft;

public final class LiteLoader
implements FilenameFilter,
mc {
    private static final String LOADER_VERSION = "1.5.2_01";
    private static final int LOADER_REVISION = 9;
    private static final String[] SUPPORTED_VERSIONS = new String[]{"1.5.2", "1.5.r1"};
    private static final int MAX_DISCOVERY_DEPTH = 16;
    private static LiteLoader instance;
    public static Logger logger;
    private static boolean useStdOut;
    private File modsFolder;
    private Minecraft minecraft = Minecraft.x();
    private File propertiesFile = new File(Minecraft.b(), "liteloader.properties");
    private Properties internalProperties = new Properties();
    private Properties localProperties = new Properties();
    private String branding = null;
    private boolean paginateControls = true;
    private awe minecraftTimer;
    private String loadedModsList = "none";
    private LinkedList mods = new LinkedList();
    private LinkedList tickListeners = new LinkedList();
    private LinkedList loopListeners = new LinkedList();
    private LinkedList initListeners = new LinkedList();
    private LinkedList renderListeners = new LinkedList();
    private LinkedList postRenderListeners = new LinkedList();
    private LinkedList chatRenderListeners = new LinkedList();
    private LinkedList chatListeners = new LinkedList();
    private LinkedList chatFilters = new LinkedList();
    private LinkedList loginListeners = new LinkedList();
    private LinkedList preLoginListeners = new LinkedList();
    private LinkedList pluginChannelListeners = new LinkedList();
    private HashMap pluginChannels = new HashMap();
    private Method mAddUrl;
    private boolean loaderStartupDone;
    private boolean loaderStartupComplete;
    private boolean lateInitDone;
    private boolean chatHooked;
    private boolean loginHooked;
    private boolean pluginChannelHooked;
    private boolean tickHooked;
    private HookProfiler profilerHook = new HookProfiler(this, logger);
    private axs currentResolution;

    public static final void init(File gameDirectory, File assetsDirectory, String profile) {
        if (instance == null) {
            instance = new LiteLoader();
            instance.initLoader();
        }
    }

    public static final LiteLoader getInstance() {
        if (instance == null) {
            instance = new LiteLoader();
            instance.initLoader();
        }
        return instance;
    }

    public static final Logger getLogger() {
        return logger;
    }

    public static final PrintStream getConsoleStream() {
        return useStdOut ? System.out : System.err;
    }

    public static final String getVersion() {
        return LOADER_VERSION;
    }

    public static final int getRevision() {
        return 9;
    }

    private LiteLoader() {
    }

    private void initLoader() {
        if (this.loaderStartupDone) {
            return;
        }
        this.loaderStartupDone = true;
        this.prepareClassOverrides();
        if (this.prepareLoader()) {
            logger.info(String.format("LiteLoader %s starting up...", LOADER_VERSION));
            if (this.branding != null) {
                logger.info(String.format("Active Pack: %s", this.branding));
            }
            logger.info(String.format("Java reports OS=\"%s\"", System.getProperty("os.name").toLowerCase()));
            boolean searchMods = this.localProperties.getProperty("search.mods", "true").equalsIgnoreCase("true");
            boolean searchProtectionDomain = this.localProperties.getProperty("search.jar", "true").equalsIgnoreCase("true");
            boolean searchClassPath = this.localProperties.getProperty("search.classpath", "true").equalsIgnoreCase("true");
            if (!(searchMods || searchProtectionDomain || searchClassPath)) {
                logger.warning("Invalid configuration, no search locations defined. Enabling all search locations.");
                this.localProperties.setProperty("search.mods", "true");
                this.localProperties.setProperty("search.jar", "true");
                this.localProperties.setProperty("search.classpath", "true");
                searchMods = true;
                searchProtectionDomain = true;
                searchClassPath = true;
            }
            this.prepareMods(searchMods, searchProtectionDomain, searchClassPath);
            this.initMods();
            this.initHooks();
            this.loaderStartupComplete = true;
            this.writeProperties();
        }
    }

    private void prepareClassOverrides() {
    }

    private void registerBaseClassOverride(String binaryClassName, String fileName) {
        try {
            Method mDefineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            mDefineClass.setAccessible(true);
            InputStream resourceInputStream = LiteLoader.class.getResourceAsStream("/classes/" + fileName + ".bin");
            if (resourceInputStream != null) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                int readBytes = resourceInputStream.read();
                while (readBytes >= 0) {
                    outputStream.write(readBytes);
                    readBytes = resourceInputStream.read();
                }
                byte[] data = outputStream.toByteArray();
                outputStream.close();
                resourceInputStream.close();
                logger.info("Defining class override for " + binaryClassName);
                mDefineClass.invoke((Object)Minecraft.class.getClassLoader(), binaryClassName, data, 0, data.length);
            } else {
                logger.info("Error defining class override for " + binaryClassName + ", file not found");
            }
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "Error defining class override for " + binaryClassName, th);
        }
    }

    private boolean prepareLoader() {
        try {
            this.mAddUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            this.mAddUrl.setAccessible(true);
            this.prepareProperties();
            this.prepareLogger();
            this.paginateControls = this.localProperties.getProperty("controls.pages", "true").equalsIgnoreCase("true");
            this.localProperties.setProperty("controls.pages", String.valueOf(this.paginateControls));
            this.branding = this.internalProperties.getProperty("brand", null);
            if (this.branding != null && this.branding.length() < 1) {
                this.branding = null;
            }
            if (this.branding != null) {
                this.localProperties.setProperty("brand", this.branding);
            } else {
                this.localProperties.remove("brand");
            }
        }
        catch (Throwable th) {
            logger.log(Level.SEVERE, "Error initialising LiteLoader", th);
            return false;
        }
        return true;
    }

    private void prepareLogger() throws SecurityException, IOException {
        LiteLoaderLogFormatter logFormatter = new LiteLoaderLogFormatter();
        logger.setUseParentHandlers(false);
        useStdOut = System.getProperty("liteloader.log", "stderr").equalsIgnoreCase("stdout") || this.localProperties.getProperty("log", "stderr").equalsIgnoreCase("stdout");
        StreamHandler consoleHandler = useStdOut ? new com.mumfrey.liteloader.util.log.ConsoleHandler() : new ConsoleHandler();
        consoleHandler.setFormatter(logFormatter);
        logger.addHandler(consoleHandler);
        FileHandler logFileHandler = new FileHandler(new File(Minecraft.b(), "LiteLoader.txt").getAbsolutePath());
        logFileHandler.setFormatter(logFormatter);
        logger.addHandler(logFileHandler);
    }

    private void prepareProperties() {
        try {
            InputStream propertiesStream = LiteLoader.class.getResourceAsStream("/liteloader.properties");
            if (propertiesStream != null) {
                this.internalProperties.load(propertiesStream);
                propertiesStream.close();
            }
        }
        catch (Throwable th) {
            this.internalProperties = new Properties();
        }
        try {
            this.localProperties = new Properties(this.internalProperties);
            InputStream localPropertiesStream = this.getLocalPropertiesStream();
            if (localPropertiesStream != null) {
                this.localProperties.load(localPropertiesStream);
                localPropertiesStream.close();
            }
        }
        catch (Throwable th) {
            this.localProperties = new Properties(this.internalProperties);
        }
    }

    private InputStream getLocalPropertiesStream() throws FileNotFoundException {
        if (this.propertiesFile.exists()) {
            return new FileInputStream(this.propertiesFile);
        }
        return LiteLoader.class.getResourceAsStream("/liteloader.properties");
    }

    private void writeProperties() {
        try {
            this.localProperties.store(new FileWriter(this.propertiesFile), String.format("Properties for LiteLoader %s", LOADER_VERSION));
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "Error writing liteloader properties", th);
        }
    }

    public File getModsFolder() {
        if (this.modsFolder == null) {
            this.modsFolder = new File(Minecraft.b(), "mods");
            if (!this.modsFolder.exists() || !this.modsFolder.isDirectory()) {
                try {
                    this.modsFolder.mkdirs();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.modsFolder;
    }

    public String getLoadedModsList() {
        return this.loadedModsList;
    }

    public String getBranding() {
        return this.branding;
    }

    public LiteMod getMod(String modName) throws InvalidActivityException, IllegalArgumentException {
        if (!this.loaderStartupComplete) {
            throw new InvalidActivityException("Attempted to get a reference to a mod before loader startup is complete");
        }
        if (modName == null) {
            throw new IllegalArgumentException("Attempted to get a reference to a mod without specifying a mod name");
        }
        for (LiteMod mod : this.mods) {
            if (!modName.equalsIgnoreCase(mod.getName()) && !modName.equalsIgnoreCase(mod.getClass().getSimpleName())) continue;
            return mod;
        }
        return null;
    }

    private void prepareMods(boolean searchMods, boolean searchProtectionDomain, boolean searchClassPath) {
        File modFolder;
        LinkedList modFiles = new LinkedList();
        if (searchMods && (modFolder = this.getModsFolder()).exists() && modFolder.isDirectory()) {
            logger.info("Mods folder found, searching " + modFolder.getPath());
            this.findModFiles(modFolder, modFiles);
            logger.info("Found " + modFiles.size() + " mod file(s)");
        }
        HashMap modsToLoad = null;
        try {
            logger.info("Enumerating class path...");
            String classPath = System.getProperty("java.class.path");
            String classPathSeparator = System.getProperty("path.separator");
            String[] classPathEntries = classPath.split(classPathSeparator);
            logger.info(String.format("Class path separator=\"%s\"", classPathSeparator));
            logger.info(String.format("Class path entries=(\n   classpathEntry=%s\n)", classPath.replace(classPathSeparator, "\n   classpathEntry=")));
            if (searchProtectionDomain || searchClassPath) {
                logger.info("Discovering mods on class path...");
            }
            modsToLoad = this.findModClasses(classPathEntries, modFiles, searchProtectionDomain, searchClassPath);
            logger.info("Mod class discovery completed");
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "Mod class discovery failed", th);
            return;
        }
        this.loadMods(modsToLoad);
    }

    protected void findModFiles(File modFolder, LinkedList modFiles) {
        List<String> supportedVerions = Arrays.asList(SUPPORTED_VERSIONS);
        for (File modFile : modFolder.listFiles(this)) {
            try {
                ZipFile modZip = new ZipFile(modFile);
                ZipEntry version = modZip.getEntry("version.txt");
                if (version != null) {
                    InputStream versionStream = modZip.getInputStream(version);
                    BufferedReader versionReader = new BufferedReader(new InputStreamReader(versionStream));
                    String strVersion = versionReader.readLine();
                    versionReader.close();
                    if (supportedVerions.contains(strVersion) && this.addURLToClassPath(modFile.toURI().toURL())) {
                        modFiles.add(modFile);
                    } else {
                        logger.info("Not adding invalid or outdated mod file: " + modFile.getAbsolutePath());
                    }
                }
                modZip.close();
            }
            catch (Exception ex2) {
                logger.warning("Error enumerating '" + modFile.getAbsolutePath() + "': Invalid zip file or error reading file");
            }
        }
    }

    @Override
    public boolean accept(File dir, String fileName) {
        return fileName.toLowerCase().endsWith(".litemod");
    }

    private HashMap findModClasses(String[] classPathEntries, LinkedList modFiles, boolean searchProtectionDomain, boolean searchClassPath) {
        HashMap<String, Class> modsToLoad = new HashMap<String, Class>();
        if (searchProtectionDomain) {
            try {
                logger.info("Searching protection domain code source...");
                File packagePath = null;
                URL protectionDomainLocation = LiteLoader.class.getProtectionDomain().getCodeSource().getLocation();
                if (protectionDomainLocation != null) {
                    if (protectionDomainLocation.toString().indexOf(33) > -1 && protectionDomainLocation.toString().startsWith("jar:")) {
                        protectionDomainLocation = new URL(protectionDomainLocation.toString().substring(4, protectionDomainLocation.toString().indexOf(33)));
                    }
                    packagePath = new File(protectionDomainLocation.toURI());
                } else {
                    String reflectionClassPath = LiteLoader.class.getResource("/com/mumfrey/liteloader/core/LiteLoader.class").getPath();
                    if (reflectionClassPath.indexOf(33) > -1) {
                        reflectionClassPath = URLDecoder.decode(reflectionClassPath, "UTF-8");
                        packagePath = new File(reflectionClassPath.substring(5, reflectionClassPath.indexOf(33)));
                    }
                }
                if (packagePath != null) {
                    LinkedList modClasses = LiteLoader.getSubclassesFor(packagePath, Minecraft.class.getClassLoader(), LiteMod.class, "LiteMod");
                    for (Class mod : modClasses) {
                        if (modsToLoad.containsKey(mod.getSimpleName())) {
                            logger.warning("Mod name collision for mod with class '" + mod.getSimpleName() + "', maybe you have more than one copy?");
                        }
                        modsToLoad.put(mod.getSimpleName(), mod);
                    }
                    if (modClasses.size() > 0) {
                        logger.info(String.format("Found %s potential matches", modClasses.size()));
                    }
                }
            }
            catch (Throwable th) {
                logger.warning("Error loading from local class path: " + th.getMessage());
            }
        }
        if (searchClassPath) {
            for (String classPathPart : classPathEntries) {
                logger.info(String.format("Searching %s...", classPathPart));
                File packagePath = new File(classPathPart);
                LinkedList modClasses = LiteLoader.getSubclassesFor(packagePath, Minecraft.class.getClassLoader(), LiteMod.class, "LiteMod");
                for (Class mod : modClasses) {
                    if (modsToLoad.containsKey(mod.getSimpleName())) {
                        logger.warning("Mod name collision for mod with class '" + mod.getSimpleName() + "', maybe you have more than one copy?");
                    }
                    modsToLoad.put(mod.getSimpleName(), mod);
                }
                if (modClasses.size() <= 0) continue;
                logger.info(String.format("Found %s potential matches", modClasses.size()));
            }
        }
        for (File modFile : modFiles) {
            logger.info(String.format("Searching %s...", modFile.getAbsolutePath()));
            LinkedList modClasses = LiteLoader.getSubclassesFor(modFile, Minecraft.class.getClassLoader(), LiteMod.class, "LiteMod");
            for (Class mod : modClasses) {
                if (modsToLoad.containsKey(mod.getSimpleName())) {
                    logger.warning("Mod name collision for mod with class '" + mod.getSimpleName() + "', maybe you have more than one copy?");
                }
                modsToLoad.put(mod.getSimpleName(), mod);
            }
            if (modClasses.size() <= 0) continue;
            logger.info(String.format("Found %s potential matches", modClasses.size()));
        }
        return modsToLoad;
    }

    private void loadMods(HashMap modsToLoad) {
        if (modsToLoad == null) {
            logger.info("Mod class discovery failed. Not loading any mods!");
            return;
        }
        logger.info("Discovered " + modsToLoad.size() + " total mod(s)");
        for (Class mod : modsToLoad.values()) {
            try {
                logger.info("Loading mod from " + mod.getName());
                LiteMod newMod = (LiteMod)mod.newInstance();
                this.mods.add(newMod);
                logger.info("Successfully added mod " + newMod.getName() + " version " + newMod.getVersion());
            }
            catch (Throwable th) {
                logger.warning(th.toString());
                th.printStackTrace();
            }
        }
    }

    private void initMods() {
        this.loadedModsList = "";
        int loadedModsCount = 0;
        Iterator iter = this.mods.iterator();
        while (iter.hasNext()) {
            LiteMod mod = (LiteMod)iter.next();
            try {
                logger.info("Initialising mod " + mod.getName() + " version " + mod.getVersion());
                mod.init();
                if (mod instanceof Tickable) {
                    this.addTickListener((Tickable)mod);
                }
                if (mod instanceof GameLoopListener) {
                    this.addLoopListener((GameLoopListener)((Object)mod));
                }
                if (mod instanceof InitCompleteListener) {
                    this.addInitListener((InitCompleteListener)mod);
                }
                if (mod instanceof RenderListener) {
                    this.addRenderListener((RenderListener)mod);
                }
                if (mod instanceof PostRenderListener) {
                    this.addPostRenderListener((PostRenderListener)mod);
                }
                if (mod instanceof ChatFilter) {
                    this.addChatFilter((ChatFilter)mod);
                }
                if (mod instanceof ChatListener) {
                    if (mod instanceof ChatFilter) {
                        logger.warning(String.format("Interface error initialising mod '%1s'. A mod implementing ChatFilter and ChatListener is not supported! Remove one of these interfaces", mod.getName()));
                    } else {
                        this.addChatListener((ChatListener)mod);
                    }
                }
                if (mod instanceof ChatRenderListener) {
                    this.addChatRenderListener((ChatRenderListener)mod);
                }
                if (mod instanceof PreLoginListener) {
                    this.addPreLoginListener((PreLoginListener)mod);
                }
                if (mod instanceof LoginListener) {
                    this.addLoginListener((LoginListener)mod);
                }
                if (mod instanceof PluginChannelListener) {
                    this.addPluginChannelListener((PluginChannelListener)mod);
                }
                this.loadedModsList = this.loadedModsList + String.format("\n          - %s version %s", mod.getName(), mod.getVersion());
                ++loadedModsCount;
            }
            catch (Throwable th) {
                logger.log(Level.WARNING, "Error initialising mod '" + mod.getName(), th);
                iter.remove();
            }
        }
        this.loadedModsList = String.format("%s loaded mod(s)%s", loadedModsCount, this.loadedModsList);
    }

    private void initHooks() {
        try {
            if (!(this.chatListeners.size() <= 0 && this.chatFilters.size() <= 0 || this.chatHooked)) {
                this.chatHooked = true;
                HookChat.register();
                HookChat.registerPacketHandler(this);
            }
            if (!(this.preLoginListeners.size() <= 0 && this.loginListeners.size() <= 0 || this.loginHooked)) {
                this.loginHooked = true;
                ModUtilities.registerPacketOverride(1, HookLogin.class);
                HookLogin.loader = this;
            }
            if (this.pluginChannelListeners.size() > 0 && !this.pluginChannelHooked) {
                this.pluginChannelHooked = true;
                HookPluginChannels.register();
                HookPluginChannels.registerPacketHandler(this);
            }
            if (!this.tickHooked) {
                this.tickHooked = true;
                PrivateFields.minecraftProfiler.setFinal(this.minecraft, this.profilerHook);
            }
            ma snooper = this.minecraft.F();
            PrivateFields.playerStatsCollector.setFinal(snooper, this);
        }
        catch (Exception ex2) {
            logger.log(Level.WARNING, "Error creating hooks", ex2);
            ex2.printStackTrace();
        }
    }

    public void addTickListener(Tickable tickable) {
        if (!this.tickListeners.contains(tickable)) {
            this.tickListeners.add(tickable);
            if (this.loaderStartupComplete) {
                this.initHooks();
            }
        }
    }

    public void addLoopListener(GameLoopListener loopListener) {
        if (!this.loopListeners.contains(loopListener)) {
            this.loopListeners.add(loopListener);
            if (this.loaderStartupComplete) {
                this.initHooks();
            }
        }
    }

    public void addInitListener(InitCompleteListener initCompleteListener) {
        if (!this.initListeners.contains(initCompleteListener)) {
            this.initListeners.add(initCompleteListener);
            if (this.loaderStartupComplete) {
                this.initHooks();
            }
        }
    }

    public void addRenderListener(RenderListener tickable) {
        if (!this.renderListeners.contains(tickable)) {
            this.renderListeners.add(tickable);
            if (this.loaderStartupComplete) {
                this.initHooks();
            }
        }
    }

    public void addPostRenderListener(PostRenderListener tickable) {
        if (!this.postRenderListeners.contains(tickable)) {
            this.postRenderListeners.add(tickable);
            if (this.loaderStartupComplete) {
                this.initHooks();
            }
        }
    }

    public void addChatFilter(ChatFilter chatFilter) {
        if (!this.chatFilters.contains(chatFilter)) {
            this.chatFilters.add(chatFilter);
            if (this.loaderStartupComplete) {
                this.initHooks();
            }
        }
    }

    public void addChatListener(ChatListener chatListener) {
        if (!this.chatListeners.contains(chatListener)) {
            this.chatListeners.add(chatListener);
            if (this.loaderStartupComplete) {
                this.initHooks();
            }
        }
    }

    public void addChatRenderListener(ChatRenderListener chatRenderListener) {
        if (!this.chatRenderListeners.contains(chatRenderListener)) {
            this.chatRenderListeners.add(chatRenderListener);
            if (this.loaderStartupComplete) {
                this.initHooks();
            }
        }
    }

    public void addPreLoginListener(PreLoginListener loginListener) {
        if (!this.preLoginListeners.contains(loginListener)) {
            this.preLoginListeners.add(loginListener);
            if (this.loaderStartupComplete) {
                this.initHooks();
            }
        }
    }

    public void addLoginListener(LoginListener loginListener) {
        if (!this.loginListeners.contains(loginListener)) {
            this.loginListeners.add(loginListener);
            if (this.loaderStartupComplete) {
                this.initHooks();
            }
        }
    }

    public void addPluginChannelListener(PluginChannelListener pluginChannelListener) {
        if (!this.pluginChannelListeners.contains(pluginChannelListener)) {
            this.pluginChannelListeners.add(pluginChannelListener);
            if (this.loaderStartupComplete) {
                this.initHooks();
            }
        }
    }

    private static LinkedList getSubclassesFor(File packagePath, ClassLoader classloader, Class superClass, String prefix) {
        LinkedList classes = new LinkedList();
        try {
            if (packagePath.isDirectory()) {
                LiteLoader.enumerateDirectory(prefix, superClass, classloader, classes, packagePath);
            } else if (packagePath.isFile() && (packagePath.getName().endsWith(".jar") || packagePath.getName().endsWith(".zip") || packagePath.getName().endsWith(".litemod"))) {
                LiteLoader.enumerateCompressedPackage(prefix, superClass, classloader, classes, packagePath);
            }
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "Enumeration error", th);
        }
        return classes;
    }

    private static void enumerateCompressedPackage(String prefix, Class superClass, ClassLoader classloader, LinkedList classes, File packagePath) throws FileNotFoundException, IOException {
        FileInputStream fileinputstream = new FileInputStream(packagePath);
        ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
        ZipEntry zipentry = null;
        do {
            String className;
            if ((zipentry = zipinputstream.getNextEntry()) == null || !zipentry.getName().endsWith(".class")) continue;
            String classFileName = zipentry.getName();
            String string = className = classFileName.lastIndexOf(47) > -1 ? classFileName.substring(classFileName.lastIndexOf(47) + 1) : classFileName;
            if (prefix != null && !className.startsWith(prefix)) continue;
            try {
                String fullClassName = classFileName.substring(0, classFileName.length() - 6).replaceAll("/", ".");
                LiteLoader.checkAndAddClass(classloader, superClass, classes, fullClassName);
            }
            catch (Exception ex2) {
                // empty catch block
            }
        } while (zipentry != null);
        fileinputstream.close();
    }

    private static void enumerateDirectory(String prefix, Class superClass, ClassLoader classloader, LinkedList classes, File packagePath) {
        LiteLoader.enumerateDirectory(prefix, superClass, classloader, classes, packagePath, "", 0);
    }

    private static void enumerateDirectory(String prefix, Class superClass, ClassLoader classloader, LinkedList classes, File packagePath, String packageName, int depth) {
        File[] classFiles;
        if (depth > 16) {
            return;
        }
        for (File classFile : classFiles = packagePath.listFiles()) {
            if (classFile.isDirectory()) {
                LiteLoader.enumerateDirectory(prefix, superClass, classloader, classes, classFile, packageName + classFile.getName() + ".", depth + 1);
                continue;
            }
            if (!classFile.getName().endsWith(".class") || prefix != null && !classFile.getName().startsWith(prefix)) continue;
            String classFileName = classFile.getName();
            String className = packageName + classFileName.substring(0, classFileName.length() - 6);
            LiteLoader.checkAndAddClass(classloader, superClass, classes, className);
        }
    }

    private static void checkAndAddClass(ClassLoader classloader, Class superClass, LinkedList classes, String className) {
        if (className.indexOf(36) > -1) {
            return;
        }
        try {
            Class<?> subClass = classloader.loadClass(className);
            if (subClass != null && !superClass.equals(subClass) && superClass.isAssignableFrom(subClass) && !subClass.isInterface() && !classes.contains(subClass)) {
                classes.add(subClass);
            }
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "checkAndAddClass error", th);
        }
    }

    private boolean addURLToClassPath(URL classUrl) {
        try {
            if (Minecraft.class.getClassLoader() instanceof URLClassLoader && this.mAddUrl != null && this.mAddUrl.isAccessible()) {
                URLClassLoader classLoader = (URLClassLoader)Minecraft.class.getClassLoader();
                this.mAddUrl.invoke((Object)classLoader, classUrl);
                return true;
            }
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "Error adding class path entry", th);
        }
        return false;
    }

    public void onInit() {
        if (!this.lateInitDone) {
            this.lateInitDone = true;
            for (InitCompleteListener initMod : this.initListeners) {
                try {
                    logger.info("Calling late init for mod " + initMod.getName());
                    initMod.onInitCompleted(this.minecraft, this);
                }
                catch (Throwable th) {
                    logger.log(Level.WARNING, "Error initialising mod " + initMod.getName(), th);
                }
            }
        }
    }

    public void onRender() {
        if (this.paginateControls && this.minecraft.s != null && this.minecraft.s.getClass().equals(awl.class)) {
            try {
                axr parentScreen = (axr)PrivateFields.guiControlsParentScreen.get((awl)this.minecraft.s);
                this.minecraft.a(new GuiControlsPaginated(parentScreen, this.minecraft.z));
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        for (RenderListener renderListener : this.renderListeners) {
            renderListener.onRender();
        }
    }

    public void postRenderEntities() {
        float partialTicks = this.minecraftTimer != null ? this.minecraftTimer.e : 0.0f;
        for (PostRenderListener renderListener : this.postRenderListeners) {
            renderListener.onPostRenderEntities(partialTicks);
        }
    }

    public void postRender() {
        float partialTicks = this.minecraftTimer != null ? this.minecraftTimer.e : 0.0f;
        for (PostRenderListener renderListener : this.postRenderListeners) {
            renderListener.onPostRender(partialTicks);
        }
    }

    public void onBeforeGuiRender() {
        for (RenderListener renderListener : this.renderListeners) {
            renderListener.onRenderGui(this.minecraft.s);
        }
    }

    public void onSetupCameraTransform() {
        for (RenderListener renderListener : this.renderListeners) {
            renderListener.onSetupCameraTransform();
        }
    }

    public void onBeforeChatRender() {
        this.currentResolution = new axs(this.minecraft.z, this.minecraft.c, this.minecraft.d);
        int screenWidth = this.currentResolution.a();
        int screenHeight = this.currentResolution.b();
        awh chat = this.minecraft.w.b();
        for (ChatRenderListener chatRenderListener : this.chatRenderListeners) {
            chatRenderListener.onPreRenderChat(screenWidth, screenHeight, chat);
        }
    }

    public void onAfterChatRender() {
        int screenWidth = this.currentResolution.a();
        int screenHeight = this.currentResolution.b();
        awh chat = this.minecraft.w.b();
        for (ChatRenderListener chatRenderListener : this.chatRenderListeners) {
            chatRenderListener.onPostRenderChat(screenWidth, screenHeight, chat);
        }
    }

    public void onTimerUpdate() {
        for (GameLoopListener loopListener : this.loopListeners) {
            loopListener.onRunGameLoop(this.minecraft);
        }
    }

    public void onTick(la profiler, boolean tick) {
        float partialTicks = 0.0f;
        if (tick || this.minecraftTimer == null) {
            this.minecraftTimer = (awe)PrivateFields.minecraftTimer.get(this.minecraft);
        }
        if (this.minecraftTimer != null) {
            partialTicks = this.minecraftTimer.c;
            tick = this.minecraftTimer.b > 0;
        }
        boolean inGame = this.minecraft.h != null && this.minecraft.h.q != null;
        for (Tickable tickable : this.tickListeners) {
            profiler.a(tickable.getClass().getSimpleName());
            tickable.onTick(this.minecraft, partialTicks, inGame, tick);
            profiler.b();
        }
    }

    public boolean onChat(cw chatPacket) {
        for (ChatFilter chatFilter : this.chatFilters) {
            if (chatFilter.onChat(chatPacket)) continue;
            return false;
        }
        for (ChatListener chatListener : this.chatListeners) {
            chatListener.onChat(chatPacket.b);
        }
        return true;
    }

    public boolean onPreLogin(ej netHandler, dz loginPacket) {
        boolean cancelled = false;
        for (PreLoginListener loginListener : this.preLoginListeners) {
            cancelled |= !loginListener.onPreLogin(netHandler, loginPacket);
        }
        return !cancelled;
    }

    public void onConnectToServer(ej netHandler, dz loginPacket) {
        for (LoginListener loginListener : this.loginListeners) {
            loginListener.onLogin(netHandler, loginPacket);
        }
        this.setupPluginChannels();
    }

    public void onPluginChannelMessage(HookPluginChannels hookPluginChannels) {
        if (hookPluginChannels != null && hookPluginChannels.a != null && this.pluginChannels.containsKey(hookPluginChannels.a)) {
            for (PluginChannelListener pluginChannelListener : (LinkedList)this.pluginChannels.get(hookPluginChannels.a)) {
                try {
                    pluginChannelListener.onCustomPayload(hookPluginChannels.a, hookPluginChannels.b, hookPluginChannels.c);
                }
                catch (Exception ex2) {}
            }
        }
    }

    public void sendPluginChannelMessage(String channel, byte[] data) {
        ModUtilities.sendPluginChannelMessage(channel, data);
    }

    protected void setupPluginChannels() {
        this.pluginChannels.clear();
        for (PluginChannelListener pluginChannelListener : this.pluginChannelListeners) {
            List channels = pluginChannelListener.getChannels();
            if (channels == null) continue;
            for (String channel : channels) {
                if (channel.length() > 16 || channel.toUpperCase().equals("REGISTER") || channel.toUpperCase().equals("UNREGISTER")) continue;
                if (!this.pluginChannels.containsKey(channel)) {
                    this.pluginChannels.put(channel, new LinkedList());
                }
                ((LinkedList)this.pluginChannels.get(channel)).add(pluginChannelListener);
            }
        }
        if (this.pluginChannels.keySet().size() > 0) {
            StringBuilder channelList = new StringBuilder();
            boolean separator = false;
            for (String channel : this.pluginChannels.keySet()) {
                if (separator) {
                    channelList.append("\u0000");
                }
                channelList.append(channel);
                separator = true;
            }
            byte[] registrationData = channelList.toString().getBytes(Charset.forName("UTF8"));
            this.sendPluginChannelMessage("REGISTER", registrationData);
        }
    }

    @Override
    public void a(ma var1) {
        this.minecraft.a(var1);
    }

    @Override
    public void b(ma var1) {
        this.sanityCheck();
        this.minecraft.b(var1);
    }

    @Override
    public boolean R() {
        return this.minecraft.R();
    }

    @Override
    public ku al() {
        return this.minecraft.al();
    }

    private void sanityCheck() {
        if (this.tickHooked && this.minecraft.J != this.profilerHook) {
            PrivateFields.minecraftProfiler.setFinal(this.minecraft, this.profilerHook);
        }
    }

    static {
        logger = Logger.getLogger("liteloader");
        useStdOut = false;
    }
}

