/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

final class LiteLoaderLogFormatter
extends Formatter {
    private SimpleDateFormat simpleDateFormatLogFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    LiteLoaderLogFormatter() {
    }

    @Override
    public String format(LogRecord logRecord) {
        StringBuilder sb2 = new StringBuilder();
        sb2.append(this.simpleDateFormatLogFormatter.format(logRecord.getMillis()));
        Level var3 = logRecord.getLevel();
        if (var3 == Level.SEVERE) {
            sb2.append(" [").append(var3.getLocalizedName()).append("] ");
        } else {
            sb2.append(" [").append(var3.toString().toUpperCase()).append("] ");
        }
        sb2.append(logRecord.getMessage());
        sb2.append('\n');
        Throwable th = logRecord.getThrown();
        if (th != null) {
            StringWriter var5 = new StringWriter();
            th.printStackTrace(new PrintWriter(var5));
            sb2.append(var5.toString());
        }
        return sb2.toString();
    }
}

