/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.launch;

import com.mumfrey.liteloader.launch.LiteLoaderTransformer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class LiteLoaderTweaker
implements ITweaker {
    private static final String VERSION = "1.5.2";
    public static LaunchClassLoader launchClassLoader;
    private String userName;
    private String sessionKey;
    private File gameDirectory;
    private File assetsDirectory;
    private String profile;
    private List unClassifiedArgs = new ArrayList();
    private Map classifiedArgs = new HashMap();
    private List cascadedTweaks = new ArrayList();
    private ArgumentAcceptingOptionSpec cascadedTweaksOption;
    private OptionSet parsedOptions;
    private boolean fmlIsPresent = false;
    private List passThroughArgs;

    public void acceptOptions(List args, File gameDirectory, File assetsDirectory, String profile) {
        this.userName = (String)args.get(0);
        this.sessionKey = (String)args.get(1);
        this.gameDirectory = gameDirectory;
        this.assetsDirectory = assetsDirectory;
        this.profile = profile;
        LiteLoaderTransformer.gameDirectory = gameDirectory;
        LiteLoaderTransformer.assetsDirectory = assetsDirectory;
        LiteLoaderTransformer.profile = profile;
        OptionParser optionParser = new OptionParser();
        this.cascadedTweaksOption = optionParser.accepts("cascadedTweaks", "Additional tweaks to be called by FML, implementing ITweaker").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',');
        optionParser.allowsUnrecognizedOptions();
        NonOptionArgumentSpec nonOptions = optionParser.nonOptions();
        this.parsedOptions = optionParser.parse(args.toArray(new String[args.size()]));
        this.passThroughArgs = this.parsedOptions.valuesOf((OptionSpec)nonOptions);
        this.parseArgs(this.passThroughArgs);
        if (!this.classifiedArgs.containsKey("--version")) {
            this.addClassifiedArg("--version", VERSION);
        }
        if (!this.classifiedArgs.containsKey("--gameDir") && gameDirectory != null) {
            this.addClassifiedArg("--gameDir", gameDirectory.getAbsolutePath());
        }
        if (!this.classifiedArgs.containsKey("--assetsDir") && assetsDirectory != null) {
            this.addClassifiedArg("--assetsDir", assetsDirectory.getAbsolutePath());
        }
    }

    private void parseArgs(List args) {
        String classifier = null;
        for (String arg2 : args) {
            if (arg2.startsWith("-")) {
                if (classifier != null) {
                    classifier = this.addClassifiedArg(classifier, "");
                }
                classifier = arg2;
                continue;
            }
            if (classifier != null) {
                classifier = this.addClassifiedArg(classifier, arg2);
                continue;
            }
            this.unClassifiedArgs.add(arg2);
        }
    }

    private String addClassifiedArg(String classifiedArg, String arg2) {
        this.classifiedArgs.put(classifiedArg, arg2);
        return null;
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        this.computeCascadedTweaks(classLoader);
        launchClassLoader = classLoader;
        classLoader.registerTransformer("com.mumfrey.liteloader.launch.LiteLoaderTransformer");
    }

    void computeCascadedTweaks(LaunchClassLoader classLoader) {
        if (this.parsedOptions.has((OptionSpec)this.cascadedTweaksOption)) {
            for (String tweaker : this.cascadedTweaksOption.values(this.parsedOptions)) {
                try {
                    classLoader.addClassLoaderExclusion(tweaker.substring(0, tweaker.lastIndexOf(46)));
                    Class<?> tweakClass = Class.forName(tweaker, true, (ClassLoader)classLoader);
                    ITweaker additionalTweak = (ITweaker)tweakClass.newInstance();
                    this.cascadedTweaks.add(additionalTweak);
                    if (!"cpw.mods.fml.common.launcher.FMLTweaker".equals(tweaker)) continue;
                    this.fmlIsPresent = true;
                }
                catch (Exception e2) {
                    Logger.getLogger("liteloader").info(String.format("Missing additional tweak class %s", tweaker));
                }
            }
        }
    }

    void runAdditionalTweaks(LaunchClassLoader classLoader) {
        ArrayList<String> cascadedArgs = new ArrayList<String>(this.passThroughArgs);
        if (this.fmlIsPresent) {
            cascadedArgs.add("--fmlIsPresent");
        }
        for (ITweaker tweak : this.cascadedTweaks) {
            tweak.acceptOptions(cascadedArgs, this.gameDirectory, this.assetsDirectory, this.profile);
            tweak.injectIntoClassLoader(classLoader);
        }
    }

    public String getLaunchTarget() {
        return "net.minecraft.client.Minecraft";
    }

    public String[] getLaunchArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.userName);
        args.add(this.sessionKey);
        for (Map.Entry classifiedArg : this.classifiedArgs.entrySet()) {
            args.add(((String)classifiedArg.getKey()).trim());
            args.add(((String)classifiedArg.getValue()).trim());
        }
        for (String unClassifiedArg : this.unClassifiedArgs) {
            args.add(unClassifiedArg);
        }
        return args.toArray(new String[args.size()]);
    }

    public File getGameDirectory() {
        return this.gameDirectory;
    }

    public File getAssetsDirectory() {
        return this.assetsDirectory;
    }

    public String getProfile() {
        return this.profile;
    }
}

