/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins;

import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import forestry.api.apiculture.IArmorApiarist;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.BlockInterface;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.IGenericCrate;
import forestry.storage.items.ItemBackpack;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.IPlugin;
import mods.neiplugins.common.ItemApiHelper;
import mods.neiplugins.common.RecipeHandlerUtils;
import mods.neiplugins.common.Registry;
import mods.neiplugins.forestry.BiogasFuelHandler;
import mods.neiplugins.forestry.CarpenterRecipeHandler;
import mods.neiplugins.forestry.CentrifugeRecipeHandler;
import mods.neiplugins.forestry.FabricatorRecipeHandler;
import mods.neiplugins.forestry.FermenterRecipeHandler;
import mods.neiplugins.forestry.ForestryFuelHelper;
import mods.neiplugins.forestry.GuiBackpackContentlist;
import mods.neiplugins.forestry.MoistenerRecipeHandler;
import mods.neiplugins.forestry.PeatFuelHandler;
import mods.neiplugins.forestry.ShapedCustomRecipeHandler;
import mods.neiplugins.forestry.SqueezerRecipeHandler;
import mods.neiplugins.forestry.StillRecipeHandler;
import mods.neiplugins.lists.SimpleListElement;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NEIPlugins_Forestry
implements IPlugin {
    public static final String PLUGIN_NAME = "Forestry";
    public static final String PLUGIN_VERSION = "1.4.5";
    public static final String REQUIRED_MOD = "Forestry";

    @Override
    public String getPluginName() {
        return "Forestry";
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod("Forestry");
    }

    @Override
    public void init() {
    }

    @Override
    public void loadConfig() {
        this.addHandlers();
        this.configureItemPanel();
    }

    private void addHandlers() {
        API.registerRecipeHandler((ICraftingHandler)new FabricatorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new FabricatorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CarpenterRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CarpenterRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new MoistenerRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new MoistenerRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CentrifugeRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CentrifugeRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new SqueezerRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new SqueezerRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new StillRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new StillRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new FermenterRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new FermenterRecipeHandler());
        RecipeHandlerUtils.addToRecipeList("Forestry", "Centrifuge", 0, "forestry.centrifuge", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Forestry", "Carpenter", 0, "forestry.carpenter", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Forestry", "Thermionic Fabricator", 0, "forestry.fabricator", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Forestry", "Fermenter", 0, "forestry.fermenter", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Forestry", "Moistener", 0, "forestry.moistener", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Forestry", "Squeezer", 0, "forestry.squeezer", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Forestry", "Still", 0, "forestry.still", new Object[0]);
        API.registerRecipeHandler((ICraftingHandler)new ShapedCustomRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new ShapedCustomRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new BiogasFuelHandler());
        API.registerUsageHandler((IUsageHandler)new BiogasFuelHandler());
        API.registerRecipeHandler((ICraftingHandler)new PeatFuelHandler());
        API.registerUsageHandler((IUsageHandler)new PeatFuelHandler());
        ForestryFuelHelper.registerFuelHelpers();
        FermenterRecipeHandler.loadFuels();
        FabricatorRecipeHandler.buildMoltensCache();
        Registry.infoListMenu.add(new SimpleListElement("Forestry Backpacks"){

            @Override
            public boolean click(int button) {
                return button == 0 ? GuiBackpackContentlist.showList(this.title) : false;
            }
        });
    }

    private void configureItemPanel() {
        try {
            this.hideExtra();
            this.addSubsets();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void hideExtraBlock(String name, int maxDamage) {
        ItemStack res = BlockInterface.getBlock((String)name);
        if (res != null) {
            API.setMaxDamageException((int)res.field_77993_c, (int)0);
        }
    }

    private void hideExtraItem(String name, int maxDamage) {
        ItemStack res = ItemInterface.getItem((String)name);
        if (res != null) {
            API.setMaxDamageException((int)res.field_77993_c, (int)0);
        }
    }

    public void hideExtra() {
        ItemApiHelper.hideItem(ItemInterface.getItem((String)"beeQueenGE"));
        ItemApiHelper.hideItem(BlockInterface.getBlock((String)"saplingGE"));
        ItemApiHelper.hideItem(BlockInterface.getBlock((String)"leaves"));
        ItemApiHelper.hideItem(BlockInterface.getBlock((String)"pods"));
    }

    public void addSetRangeFromItem(String setname, ItemStack stack) {
        MultiItemRange t = new MultiItemRange();
        if (stack != null) {
            t.add(stack.field_77993_c);
            API.addSetRange((String)setname, (MultiItemRange)t);
        }
    }

    public void addItemToRange(MultiItemRange range, String name) {
        ItemStack res = ItemInterface.getItem((String)name);
        if (res != null) {
            range.add(res.field_77993_c);
        }
    }

    public void addItemWithDamageToRange(MultiItemRange range, String name, int damageStart, int damageEnd) {
        ItemStack res = ItemInterface.getItem((String)name);
        if (res != null) {
            range.add(res.field_77993_c, damageStart, damageEnd);
        }
    }

    public void addBlockToRange(MultiItemRange range, String name) {
        ItemStack res = BlockInterface.getBlock((String)name);
        if (res != null) {
            range.add(res.field_77993_c);
        }
    }

    public void addSubsets() {
        int i;
        MultiItemRange crated = new MultiItemRange();
        MultiItemRange apiaryFrames = new MultiItemRange();
        MultiItemRange armorApiarist = new MultiItemRange();
        MultiItemRange circuits = new MultiItemRange();
        MultiItemRange can = new MultiItemRange();
        MultiItemRange waxCapsule = new MultiItemRange();
        MultiItemRange refractoryCapsule = new MultiItemRange();
        MultiItemRange beeitems = new MultiItemRange();
        MultiItemRange tools = new MultiItemRange();
        MultiItemRange backpacks = new MultiItemRange();
        MultiItemRange wovenBackpacks = new MultiItemRange();
        MultiItemRange slabs = new MultiItemRange();
        MultiItemRange logs = new MultiItemRange();
        MultiItemRange planks = new MultiItemRange();
        MultiItemRange fences = new MultiItemRange();
        MultiItemRange alvearyParts = new MultiItemRange();
        MultiItemRange otherBlocks = new MultiItemRange();
        MultiItemRange liquids = new MultiItemRange();
        MultiItemRange parts = new MultiItemRange();
        MultiItemRange liquidContainers = new MultiItemRange();
        MultiItemRange foods = new MultiItemRange();
        MultiItemRange otherItems = new MultiItemRange();
        MultiItemRange carpenterItems = new MultiItemRange();
        for (Item i2 : Item.field_77698_e) {
            if (i2 instanceof IGenericCrate) {
                crated.add(i2.field_77779_bT);
            }
            if (i2 instanceof IHiveFrame) {
                apiaryFrames.add(i2.field_77779_bT);
            }
            if (i2 instanceof IArmorApiarist) {
                armorApiarist.add(i2.field_77779_bT);
            }
            if (!(i2 instanceof ItemBackpack)) continue;
        }
        can.add(ItemInterface.getItem((String)"canWater"));
        can.add(ItemInterface.getItem((String)"canBiomass"));
        can.add(ItemInterface.getItem((String)"canBiofuel"));
        can.add(ItemInterface.getItem((String)"canOil"));
        can.add(ItemInterface.getItem((String)"canFuel"));
        can.add(ItemInterface.getItem((String)"canLava"));
        can.add(ItemInterface.getItem((String)"canSeedOil"));
        can.add(ItemInterface.getItem((String)"canHoney"));
        can.add(ItemInterface.getItem((String)"canJuice"));
        can.add(ItemInterface.getItem((String)"canIce"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryWater"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryBiomass"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryBiofuel"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryOil"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryFuel"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryLava"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractorySeedOil"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryHoney"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryJuice"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryIce"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleWater"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleBiomass"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleBiofuel"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleOil"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleFuel"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleSeedOil"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleHoney"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleJuice"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleIce"));
        this.addItemToRange(tools, "wrench");
        this.addItemToRange(tools, "pipette");
        this.addItemToRange(tools, "solderingIron");
        this.addItemToRange(tools, "biomeFinder");
        this.addItemToRange(tools, "imprinter");
        this.addItemToRange(tools, "beealyzer");
        this.addItemToRange(tools, "treealyzer");
        this.addItemToRange(tools, "flutterlyzer");
        this.addItemToRange(tools, "grafter");
        this.addItemToRange(tools, "grafterProven");
        this.addItemToRange(tools, "infuser");
        this.addItemToRange(tools, "scoop");
        this.addItemToRange(tools, "bronzePickaxe");
        this.addItemToRange(tools, "bronzeShovel");
        this.addItemToRange(tools, "catalogue");
        this.addItemToRange(backpacks, "apiaristBackpack");
        this.addItemToRange(backpacks, "lepidopteristBackpack");
        this.addItemToRange(backpacks, "minerBackpack");
        this.addItemToRange(backpacks, "diggerBackpack");
        this.addItemToRange(backpacks, "foresterBackpack");
        this.addItemToRange(backpacks, "hunterBackpack");
        this.addItemToRange(backpacks, "builderBackpack");
        this.addItemToRange(backpacks, "dyerBackpack");
        this.addItemToRange(backpacks, "railroaderBackpack");
        this.addItemToRange(backpacks, "tinkererBackpack");
        this.addItemToRange(backpacks, "adventurerBackpack");
        this.addItemToRange(wovenBackpacks, "minerBackpackT2");
        this.addItemToRange(wovenBackpacks, "diggerBackpackT2");
        this.addItemToRange(wovenBackpacks, "foresterBackpackT2");
        this.addItemToRange(wovenBackpacks, "hunterBackpackT2");
        this.addItemToRange(wovenBackpacks, "builderBackpackT2");
        this.addItemToRange(wovenBackpacks, "dyerBackpackT2");
        this.addItemToRange(wovenBackpacks, "railroaderBackpackT2");
        this.addItemToRange(wovenBackpacks, "tinkererBackpackT2");
        this.addItemToRange(wovenBackpacks, "adventurerBackpackT2");
        this.addItemToRange(beeitems, "waxCast");
        this.addItemToRange(beeitems, "refractoryWax");
        this.addItemToRange(beeitems, "phosphor");
        this.addItemToRange(beeitems, "royalJelly");
        this.addItemToRange(beeitems, "honeydew");
        this.addItemToRange(beeitems, "propolis");
        this.addItemToRange(beeitems, "pollen");
        this.addItemToRange(beeitems, "beeswax");
        this.addItemToRange(beeitems, "honeyDrop");
        this.addItemWithDamageToRange(beeitems, "craftingMaterial", 5, 5);
        this.addItemWithDamageToRange(beeitems, "craftingMaterial", 2, 2);
        this.addItemToRange(apiaryFrames, "frameUntreated");
        this.addItemToRange(apiaryFrames, "frameImpregnated");
        this.addItemToRange(apiaryFrames, "frameProven");
        this.addItemWithDamageToRange(otherItems, "craftingMaterial", 0, 1);
        this.addItemWithDamageToRange(otherItems, "craftingMaterial", 3, 4);
        this.addItemToRange(otherItems, "iodineCharge");
        this.addItemToRange(otherItems, "fertilizerBio");
        this.addItemToRange(otherItems, "fertilizerCompound");
        this.addItemToRange(otherItems, "apatite");
        this.addItemToRange(otherItems, "ingotCopper");
        this.addItemToRange(otherItems, "ingotTin");
        this.addItemToRange(otherItems, "ingotBronze");
        this.addItemToRange(otherItems, "letters");
        this.addItemToRange(otherItems, "vialCatalyst");
        this.addItemToRange(otherItems, "mouldyWheat");
        this.addItemToRange(otherItems, "decayingWheat");
        this.addItemToRange(otherItems, "mulch");
        this.addItemToRange(otherItems, "peat");
        this.addItemToRange(otherItems, "bituminousPeat");
        this.addItemToRange(otherItems, "ash");
        this.addItemToRange(carpenterItems, "stickImpregnated");
        this.addItemToRange(carpenterItems, "woodPulp");
        this.addItemToRange(carpenterItems, "carton");
        this.addItemToRange(carpenterItems, "crate");
        this.addItemToRange(carpenterItems, "kitPickaxe");
        this.addItemToRange(carpenterItems, "kitShovel");
        this.addItemToRange(carpenterItems, "brokenBronzeShovel");
        this.addItemToRange(carpenterItems, "brokenBronzePickaxe");
        this.addItemToRange(liquids, "bucketBiomass");
        this.addItemToRange(liquids, "bucketBiofuel");
        this.addItemToRange(liquids, "liquidBiomass");
        this.addItemToRange(liquids, "liquidBiofuel");
        this.addItemToRange(liquids, "liquidSeedOil");
        this.addItemToRange(liquids, "liquidJuice");
        this.addItemToRange(liquids, "liquidHoney");
        this.addItemToRange(liquids, "liquidMead");
        this.addItemToRange(liquids, "liquidGlass");
        this.addItemToRange(liquids, "liquidIce");
        this.addItemToRange(liquids, "liquidMilk");
        for (i = 1; i <= 4; ++i) {
            this.addBlockToRange(slabs, "slabs" + i);
        }
        for (i = 1; i <= 8; ++i) {
            this.addBlockToRange(logs, "log" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addBlockToRange(planks, "planks" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addBlockToRange(fences, "fences" + i);
        }
        this.addBlockToRange(alvearyParts, "alveary");
        this.addBlockToRange(otherBlocks, "candle");
        this.addBlockToRange(otherBlocks, "stump");
        this.addItemToRange(parts, "gearBronze");
        this.addItemToRange(parts, "gearCopper");
        this.addItemToRange(parts, "gearTin");
        this.addItemToRange(parts, "sturdyCasing");
        this.addItemToRange(parts, "hardenedCasing");
        this.addItemToRange(parts, "impregnatedCasing");
        this.addItemWithDamageToRange(parts, "craftingMaterial", 6, 6);
        this.addItemToRange(foods, "ambrosia");
        this.addItemToRange(foods, "honeyedSlice");
        this.addItemToRange(foods, "honeyPot");
        this.addItemToRange(foods, "beverage");
        this.addItemToRange(liquidContainers, "canEmpty");
        this.addItemToRange(liquidContainers, "waxCapsule");
        this.addItemToRange(liquidContainers, "refractoryEmpty");
        API.addSetRange((String)"Forestry.Machines.Alveary", (MultiItemRange)alvearyParts);
        this.addSetRangeFromItem("Forestry.Machines.Farms", BlockInterface.getBlock((String)"farm"));
        this.addSetRangeFromItem("Forestry.Machines.Core", BlockInterface.getBlock((String)"core"));
        this.addSetRangeFromItem("Forestry.Machines.Apiculture", BlockInterface.getBlock((String)"apiculture"));
        this.addSetRangeFromItem("Forestry.Machines.Mail", BlockInterface.getBlock((String)"mail"));
        this.addSetRangeFromItem("Forestry.Machines.Energy", BlockInterface.getBlock((String)"engine"));
        this.addSetRangeFromItem("Forestry.Machines.Factory", BlockInterface.getBlock((String)"factoryPlain"));
        this.addSetRangeFromItem("Forestry.Machines.Factory 2", BlockInterface.getBlock((String)"factoryTESR"));
        this.addSetRangeFromItem("Forestry.Machines.Lepidopterology", BlockInterface.getBlock((String)"lepidopterology"));
        API.addSetRange((String)"Forestry.Building Blocks.Logs", (MultiItemRange)logs);
        API.addSetRange((String)"Forestry.Building Blocks.Planks", (MultiItemRange)planks);
        API.addSetRange((String)"Forestry.Building Blocks.Fences", (MultiItemRange)fences);
        this.addSetRangeFromItem("Forestry.Building Blocks.Stairs", BlockInterface.getBlock((String)"stairs"));
        this.addSetRangeFromItem("Forestry.Building Blocks.Glass", BlockInterface.getBlock((String)"glass"));
        API.addSetRange((String)"Forestry.Building Blocks.Slabs", (MultiItemRange)slabs);
        API.addSetRange((String)"Forestry.Building Blocks.Other", (MultiItemRange)otherBlocks);
        this.addSetRangeFromItem("Forestry.Bees.Drones", ItemInterface.getItem((String)"beeDroneGE"));
        this.addSetRangeFromItem("Forestry.Bees.Princesses", ItemInterface.getItem((String)"beePrincessGE"));
        this.addSetRangeFromItem("Forestry.Bees.Combs", ItemInterface.getItem((String)"beeComb"));
        this.addSetRangeFromItem("Forestry.Trees.Saplings", ItemInterface.getItem((String)"sapling"));
        this.addSetRangeFromItem("Forestry.Trees.Fruits", ItemInterface.getItem((String)"fruits"));
        this.addSetRangeFromItem("Forestry.Trees.Pollen", ItemInterface.getItem((String)"pollenFertile"));
        this.addSetRangeFromItem("Forestry.Butterflies", ItemInterface.getItem((String)"butterflyGE"));
        this.addSetRangeFromItem("Forestry.Butterflies.Pollen", ItemInterface.getItem((String)"serumGE"));
        API.addSetRange((String)"Forestry.Items.Apiculture", (MultiItemRange)beeitems);
        this.addSetRangeFromItem("Forestry.Items.Tubes", ItemInterface.getItem((String)"tubes"));
        this.addSetRangeFromItem("Forestry.Items.Circuit Boards", ItemInterface.getItem((String)"circuitboards"));
        API.addSetRange((String)"Forestry.Items.Apiary Frames", (MultiItemRange)apiaryFrames);
        API.addSetRange((String)"Forestry.Items.Parts", (MultiItemRange)parts);
        this.addSetRangeFromItem("Forestry.Items.Stamps", ItemInterface.getItem((String)"stamps"));
        this.addSetRangeFromItem("Forestry.World.Ores", BlockInterface.getBlock((String)"resources"));
        this.addSetRangeFromItem("Forestry.World.Soils", BlockInterface.getBlock((String)"soil"));
        this.addSetRangeFromItem("Forestry.World.Hives", BlockInterface.getBlock((String)"beehives"));
        API.addSetRange((String)"Forestry.Items.Tools", (MultiItemRange)tools);
        API.addSetRange((String)"Forestry.Items.Carpenter", (MultiItemRange)carpenterItems);
        API.addSetRange((String)"Forestry.Items.Other", (MultiItemRange)otherItems);
        API.addSetRange((String)"Forestry.Armor.Apiarist", (MultiItemRange)armorApiarist);
        API.addSetRange((String)"Forestry.Backpacks", (MultiItemRange)backpacks);
        API.addSetRange((String)"Forestry.Backpacks.Woven", (MultiItemRange)wovenBackpacks);
        API.addSetRange((String)"Forestry.Crated", (MultiItemRange)crated);
        API.addSetRange((String)"Forestry.Foods", (MultiItemRange)foods);
        API.addSetRange((String)"Forestry.Liquids.Containers", (MultiItemRange)liquidContainers);
        API.addSetRange((String)"Forestry.Liquids.Cans", (MultiItemRange)can);
        API.addSetRange((String)"Forestry.Liquids.Wax Capsules", (MultiItemRange)waxCapsule);
        API.addSetRange((String)"Forestry.Liquids.Refractory", (MultiItemRange)refractoryCapsule);
        API.addSetRange((String)"Forestry.Liquids", (MultiItemRange)liquids);
    }
}

