/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins;

import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.forge.IContainerTooltipHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.IPlugin;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.Utils;
import mods.neiplugins.forge.LiquidDictionaryList;
import mods.neiplugins.forge.OreDictionaryList;
import mods.neiplugins.forge.OreDictionaryTooltipHandler;
import mods.neiplugins.options.OptionsForge;
import net.minecraft.block.Block;
import net.minecraftforge.liquids.ILiquid;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;

public class NEIPlugins_Forge
implements IPlugin {
    public static final String PLUGIN_NAME = "Forge";
    public static final String PLUGIN_VERSION = "1.3.5";
    public static final String REQUIRED_MOD = "Forge";

    @Override
    public String getPluginName() {
        return "Forge";
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod("Forge");
    }

    @Override
    public void init() {
    }

    @Override
    public void loadConfig() {
        this.addLiquidContainerSubset();
        API.registerUsageHandler((IUsageHandler)new OreDictionaryList());
        API.registerRecipeHandler((ICraftingHandler)new OreDictionaryList());
        API.registerUsageHandler((IUsageHandler)new LiquidDictionaryList());
        API.registerRecipeHandler((ICraftingHandler)new LiquidDictionaryList());
        OreDictionaryTooltipHandler.resetCache();
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)new OreDictionaryTooltipHandler());
        MultiItemRange liquids = new MultiItemRange();
        for (Block i : Block.field_71973_m) {
            if (!(i instanceof ILiquid)) continue;
            liquids.add(i.field_71990_ca);
        }
        API.addSetRange((String)"Blocks.Liquids", (MultiItemRange)liquids);
        OptionsForge.addOptions();
    }

    private void addLiquidContainerSubset() {
        HashSet<List<Integer>> setContainerValidation = new HashSet<List<Integer>>();
        HashMap<List<Integer>, MultiItemRange> mapMultiItemRangeFromLiquid = new HashMap<List<Integer>, MultiItemRange>();
        MultiItemRange containers = new MultiItemRange();
        for (LiquidContainerData data : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            if (!setContainerValidation.contains(Arrays.asList(data.container.field_77993_c, data.container.func_77960_j()))) {
                setContainerValidation.add(Arrays.asList(data.container.field_77993_c, data.container.func_77960_j()));
                containers.add(data.container);
            }
            if (!LiquidHelper.isSafeLiquidStack(data.stillLiquid, "NEIPlugins_Forge.addLiquidContainerSubset() for filled liquid container " + Utils.getItemStackDebug(data.filled))) continue;
            MultiItemRange range = (MultiItemRange)mapMultiItemRangeFromLiquid.get(Arrays.asList(data.stillLiquid.itemID, data.stillLiquid.itemMeta));
            if (range == null) {
                String liquidName = LiquidHelper.getLiquidName(data.stillLiquid);
                range = new MultiItemRange();
                mapMultiItemRangeFromLiquid.put(Arrays.asList(data.stillLiquid.itemID, data.stillLiquid.itemMeta), range);
                if (!liquidName.isEmpty()) {
                    API.addSetRange((String)("Items.Liquid Containers." + liquidName), (MultiItemRange)range);
                }
            }
            range.add(data.filled);
        }
        API.addSetRange((String)"Items.Liquid Containers", (MultiItemRange)containers);
    }
}

