/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins;

import codechicken.nei.MultiItemRange;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.EnumMap;
import java.util.EnumSet;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.ClientUtils;
import mods.neiplugins.common.IPlugin;
import mods.neiplugins.common.RecipeHandlerUtils;
import mods.neiplugins.common.Utils;
import mods.neiplugins.thaumcraft.ArcaneRecipeHandler;
import mods.neiplugins.thaumcraft.CrucibleRecipeHandler;
import mods.neiplugins.thaumcraft.InfuserRecipeHandler;
import net.minecraft.item.ItemStack;
import thaumcraft.api.EnumTag;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApiHelper;

public class NEIPlugins_Thaumcraft
implements IPlugin {
    public static final String PLUGIN_NAME = "Thaumcraft";
    public static final String PLUGIN_VERSION = "1.0.0";
    public static final String REQUIRED_MOD = "Thaumcraft";

    @Override
    public String getPluginName() {
        return "Thaumcraft";
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod("Thaumcraft");
    }

    @Override
    public void init() {
    }

    @Override
    public void loadConfig() {
        NEIClientConfig.globalConfig.getTag("mistaqur.addThaumcraftAspectsSubsets").setDefaultValue("false");
        this.addHandlers();
        if (Utils.getBooleanSetting("mistaqur.addThaumcraftAspectsSubsets")) {
            this.addAspectSubsets();
        }
    }

    public void addAspectSubsets() {
        EnumMap<EnumTag, MultiItemRange> tagMap = new EnumMap<EnumTag, MultiItemRange>(EnumTag.class);
        for (EnumTag tag : EnumSet.allOf(EnumTag.class)) {
            tagMap.put(tag, new MultiItemRange());
        }
        for (ItemStack stack : ClientUtils.getItemList()) {
            ObjectTags tags = ThaumcraftApiHelper.getObjectTags((ItemStack)stack);
            tags = ThaumcraftApiHelper.getBonusObjectTags((ItemStack)stack, (ObjectTags)tags);
            for (EnumTag tag : tags.getAspects()) {
                if (tag == null) continue;
                ((MultiItemRange)tagMap.get(tag)).add(stack);
            }
        }
        for (EnumTag tag : EnumSet.allOf(EnumTag.class)) {
            if (((MultiItemRange)tagMap.get((Object)tag)).ranges.isEmpty()) continue;
            API.addSetRange((String)("Thaumcraft.Aspects." + tag.name), (MultiItemRange)((MultiItemRange)tagMap.get(tag)));
        }
    }

    private void addHandlers() {
        API.registerRecipeHandler((ICraftingHandler)new CrucibleRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CrucibleRecipeHandler());
        RecipeHandlerUtils.addToRecipeList("Thaumcraft", "Crucible", 0, "thaumcraft.crucible", new Object[0]);
        API.registerRecipeHandler((ICraftingHandler)new ArcaneRecipeHandler.ArcaneShapedRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new ArcaneRecipeHandler.ArcaneShapedRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new ArcaneRecipeHandler.ArcaneShapelessRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new ArcaneRecipeHandler.ArcaneShapelessRecipeHandler());
        RecipeHandlerUtils.addToRecipeList("Thaumcraft", "Arcane Worktable", 0, "thaumcraft.arcane", new Object[0]);
        API.registerRecipeHandler((ICraftingHandler)new InfuserRecipeHandler.InfuserShapedRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new InfuserRecipeHandler.InfuserShapedRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new InfuserRecipeHandler.InfuserShapelessRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new InfuserRecipeHandler.InfuserShapelessRecipeHandler());
        RecipeHandlerUtils.addToRecipeList("Thaumcraft", "Infusion Altar", 0, "thaumcraft.infuser", new Object[0]);
    }
}

