/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.common;

import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.Utils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public abstract class LiquidHelper {
    private static Map mapFilledContainersFromLiquid = new HashMap();
    private static Map mapEmptyContainersFromLiquid = new HashMap();

    public static boolean isSafeLiquidStack(LiquidStack liquid, String source) {
        if (liquid == null) {
            return false;
        }
        if (Item.field_77698_e[liquid.itemID] == null) {
            NEIPlugins.log(Level.WARNING, "Detected liquid {0}:{1} with invalid itemID in \"{2}\"", liquid.itemID, liquid.itemMeta, source);
            return false;
        }
        LiquidStack canonical = liquid.canonical();
        if (canonical == null) {
            NEIPlugins.log(Level.WARNING, "Detected liquid {0}:{1} that don't have canonical liquid in \"{2}\"", liquid.itemID, liquid.itemMeta, source);
            return false;
        }
        return true;
    }

    public static String getLiquidName(LiquidStack liquid) {
        if (Item.field_77698_e[liquid.itemID] == null) {
            NEIPlugins.log(Level.WARNING, "Detected liquid {0}:{1} with invalid itemID", liquid.itemID, liquid.itemMeta);
            return "";
        }
        String res = Item.field_77698_e[liquid.itemID].func_77628_j(liquid.asItemStack());
        if (res.isEmpty() && !(res = LiquidHelper.getCanonicalLiquidName(liquid)).isEmpty()) {
            res = "\u00a73" + res;
        }
        return res;
    }

    public static String getCanonicalLiquidName(LiquidStack liquid) {
        return LiquidDictionary.findLiquidName((LiquidStack)liquid);
    }

    public static Icon bindLiquidTexture(GuiContainerManager gui, LiquidStack liquid) {
        if (liquid == null || liquid.amount <= 0 || liquid.itemID == 0) {
            return null;
        }
        Icon liquidIcon = null;
        String texture = "/terrain.png";
        LiquidStack canonical = liquid.canonical();
        if (canonical != null) {
            liquidIcon = canonical.getRenderingIcon();
            texture = canonical.getTextureSheet();
            liquid = canonical;
        }
        if (texture == null) {
            texture = "/terrain.png";
        }
        if (liquidIcon == null) {
            if (liquid.itemID < Block.field_71973_m.length && Block.field_71973_m[liquid.itemID] != null) {
                liquidIcon = Block.field_71973_m[liquid.itemID].func_71851_a(0);
            } else {
                liquidIcon = Item.field_77698_e[liquid.itemID].func_77617_a(liquid.itemMeta);
                texture = "/gui/items.png";
            }
        }
        gui.bindTexture(texture);
        Item liquidItem = liquid.asItemStack().func_77973_b();
        if (liquidItem != null) {
            int color = liquidItem.func_82790_a(liquid.asItemStack(), 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return liquidIcon;
    }

    public static boolean isLiquid(LiquidStack test) {
        if (test == null) {
            return false;
        }
        return LiquidDictionary.findLiquidName((LiquidStack)test) != null;
    }

    public static LiquidStack getLiquidStack(ItemStack item) {
        if (item == null) {
            return null;
        }
        LiquidStack test = new LiquidStack(item.field_77993_c, 1000, item.func_77960_j());
        if (LiquidContainerRegistry.isLiquid((ItemStack)item)) {
            return test;
        }
        if (LiquidDictionary.findLiquidName((LiquidStack)test) != null) {
            return test;
        }
        LiquidStack result = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)item);
        if (result != null) {
            return result;
        }
        return null;
    }

    public static PositionedStack[] generateStacksForLiquid(LiquidStack liquid, int x1, int y1, int x2, int y2) {
        List<Integer> key;
        if (mapFilledContainersFromLiquid.isEmpty()) {
            LiquidHelper.generateLiquidCache();
        }
        if (!mapFilledContainersFromLiquid.containsKey(key = Arrays.asList(liquid.itemID, liquid.itemMeta))) {
            ItemStack stack = liquid.asItemStack();
            if (Utils.isSafeItemStack(stack, "LiquidHelper.generateStacksForLiquid")) {
                return new PositionedStack[]{null, new PositionedStack((Object)stack, x2, y2)};
            }
            return new PositionedStack[]{null, null};
        }
        return new PositionedStack[]{new PositionedStack(mapEmptyContainersFromLiquid.get(key), x1, y1), new PositionedStack(mapFilledContainersFromLiquid.get(key), x2, y2)};
    }

    public static boolean areSameLiquid(LiquidStack liquid, LiquidStack liquid2) {
        if (liquid == null || liquid2 == null) {
            return false;
        }
        return liquid.isLiquidEqual(liquid2);
    }

    public static PositionedStack getSeqCycledStack(int cycle, PositionedStack origstack) {
        if (origstack == null) {
            return null;
        }
        PositionedStack stack = origstack.copy();
        if (stack.items.length > 1) {
            stack.setPermutationToRender(cycle % stack.items.length);
        }
        return stack;
    }

    public static void generateLiquidCache() {
        mapFilledContainersFromLiquid.clear();
        mapEmptyContainersFromLiquid.clear();
        for (LiquidContainerData data : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            List<Integer> key = Arrays.asList(data.stillLiquid.itemID, data.stillLiquid.itemMeta);
            if (!mapFilledContainersFromLiquid.containsKey(key)) {
                mapFilledContainersFromLiquid.put(key, new ArrayList());
                mapEmptyContainersFromLiquid.put(key, new ArrayList());
            }
            if (!Utils.isSafeItemStack(data.filled.func_77946_l(), "LiquidContainerRegistry.getRegisteredLiquidContainerData[].filled") || !Utils.isSafeItemStack(data.container.func_77946_l(), "LiquidContainerRegistry.getRegisteredLiquidContainerData[].container")) continue;
            ((ArrayList)mapFilledContainersFromLiquid.get(key)).add(data.filled.func_77946_l());
            ((ArrayList)mapEmptyContainersFromLiquid.get(key)).add(data.container.func_77946_l());
        }
    }
}

