/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.common;

import codechicken.nei.forge.GuiContainerManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.List;
import mods.neiplugins.common.LiquidHelper;
import net.minecraft.util.Icon;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidTank {
    public LiquidStack liquid;
    public Rectangle position;
    public Point overlay;
    public int capacity;
    public boolean showCapacity = true;
    public boolean showAmount = true;
    public boolean showMillBuckets = false;
    public String overrideTitle = null;
    public boolean ignoreCapacity = false;
    public static DecimalFormat liquidAmountFormat = new DecimalFormat("0.000");

    public LiquidTank(LiquidStack liquid, int capacity, Rectangle position, Point overlay) {
        this.liquid = liquid != null ? liquid.copy() : new LiquidStack(0, 0);
        this.capacity = capacity;
        this.position = position;
        this.overlay = overlay;
    }

    public LiquidTank(LiquidStack liquid, int capacity, Rectangle position) {
        this(liquid, capacity, position, null);
    }

    public void draw(GuiContainerManager gui, String guiTexture) {
        this.drawLiquidTank(gui, this.position, this.liquid, this.capacity, this.overlay, guiTexture);
    }

    public String amountToString(int amount) {
        if (this.showMillBuckets) {
            return amount + " mB";
        }
        return liquidAmountFormat.format((double)amount * 1.0 / 1000.0);
    }

    public List handleTooltip(List currenttip) {
        if (this.liquid.itemID > 0) {
            if (this.overrideTitle != null) {
                currenttip.add(this.overrideTitle);
            } else {
                currenttip.add(LiquidHelper.getLiquidName(this.liquid));
            }
            if (this.showAmount) {
                currenttip.add("\u00a77Amount: " + this.amountToString(this.liquid.amount));
            }
            if (this.showCapacity) {
                currenttip.add("\u00a77Capacity: " + this.amountToString(this.capacity));
            }
            this.additionalHandleTooltip(currenttip);
        } else {
            currenttip.add("Empty");
        }
        return currenttip;
    }

    public List additionalHandleTooltip(List currenttip) {
        return currenttip;
    }

    public void drawLiquidTank(GuiContainerManager gui, Rectangle position, LiquidStack liquid, int capacity, Point overlay, String guiTexture) {
        Icon liquidIcon;
        if (liquid == null) {
            return;
        }
        int scale = liquid.amount * position.height / capacity;
        if (liquid.amount > 0 && this.ignoreCapacity || scale > position.height) {
            scale = position.height;
        }
        if ((liquidIcon = LiquidHelper.bindLiquidTexture(gui, liquid)) == null) {
            return;
        }
        for (int col = 0; col < position.width / 16; ++col) {
            int x;
            int start = 0;
            int s = scale;
            do {
                x = 0;
                if (s > 16) {
                    x = 16;
                    s -= 16;
                } else {
                    x = s;
                    s = 0;
                }
                gui.window.func_94065_a(position.x + col * 16, position.y + position.height - x - start, liquidIcon, 16, 16 - (16 - x));
                start += 16;
            } while (x != 0 && s != 0);
        }
        if (position.width % 16 != 0) {
            int x;
            int start = 0;
            int s = scale;
            do {
                x = 0;
                if (s > 16) {
                    x = 16;
                    s -= 16;
                } else {
                    x = s;
                    s = 0;
                }
                gui.window.func_94065_a(position.x + position.width - position.width % 16, position.y + position.height - x - start, liquidIcon, position.width % 16, 16 - (16 - x));
                start += 16;
            } while (x != 0 && s != 0);
        }
        if (overlay != null) {
            gui.bindTexture(guiTexture);
            gui.drawTexturedModalRect(position.x, position.y, overlay.x, overlay.y, position.width, position.height);
        }
    }
}

