/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forestry;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.gadgets.MachineSqueezer;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.common.PositionedStackWithTooltip;
import mods.neiplugins.forestry.ForestryRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

public class SqueezerRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle outputTank = new Rectangle(80, 4, 16, 58);
    static Point overlayTank = new Point(176, 0);
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};

    @Override
    public String getRecipeId() {
        return "forestry.squeezer";
    }

    public String getRecipeName() {
        return "Squeezer";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(98, 9, 15, 15), this.getRecipeId(), new Object[0]));
    }

    public ArrayList getRecipes() {
        MachineSqueezer.RecipeManager cfr_ignored_0 = (MachineSqueezer.RecipeManager)RecipeManagers.squeezerManager;
        return MachineSqueezer.RecipeManager.recipes;
    }

    @Override
    public void loadCraftingRecipes(LiquidStack result) {
        for (MachineSqueezer.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(irecipe.liquid, result)) continue;
            this.arecipes.add(new CachedSqueezerRecipe(irecipe));
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (MachineSqueezer.Recipe irecipe : this.getRecipes()) {
            this.arecipes.add(new CachedSqueezerRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        LiquidStack t = LiquidHelper.getLiquidStack(result);
        for (MachineSqueezer.Recipe irecipe : this.getRecipes()) {
            if ((irecipe.remnants == null || !NEIClientUtils.areStacksSameTypeCrafting((ItemStack)irecipe.remnants, (ItemStack)result)) && !LiquidHelper.areSameLiquid(irecipe.liquid, t)) continue;
            this.arecipes.add(new CachedSqueezerRecipe(irecipe).replaceMetaOnBottlerSlots(result));
        }
    }

    public boolean containsIngredient(ItemStack[] resources, ItemStack ingredient) {
        for (ItemStack stack : resources) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)ingredient)) continue;
            return true;
        }
        return false;
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (MachineSqueezer.Recipe irecipe : this.getRecipes()) {
            if (!this.containsIngredient(irecipe.resources, ingredient)) continue;
            CachedSqueezerRecipe recipe = new CachedSqueezerRecipe(irecipe);
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        this.drawProgressBar(gui, 70, 9, 176, 60, 43, 18, ((CachedSqueezerRecipe)this.arecipes.get((int)recipe)).timePerItem * 5, 0);
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/squeezer.png";
    }

    public class CachedSqueezerRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        ArrayList ingredients;
        int timePerItem;
        PositionedStack slot_output;
        PositionedStack slot_can;
        PositionedStackWithTooltip remnants;
        LiquidTank output;

        public CachedSqueezerRecipe(MachineSqueezer.Recipe recipe) {
            super((TemplateRecipeHandler)SqueezerRecipeHandler.this);
            this.ingredients = new ArrayList();
            this.setIngredients(Arrays.asList(recipe.resources));
            this.output = new LiquidTank(recipe.liquid, 10000, outputTank, overlayTank);
            this.timePerItem = recipe.timePerItem;
            this.output.showCapacity = false;
            PositionedStack[] containers = LiquidHelper.generateStacksForLiquid(this.output.liquid, 101, 44, 135, 44);
            this.slot_can = containers[0];
            this.slot_output = containers[1];
            this.remnants = null;
            if (recipe.remnants != null) {
                this.remnants = new PositionedStackWithTooltip(recipe.remnants.func_77946_l(), 118, 8);
                this.remnants.setIntegerChanceTooltip(recipe.chance);
            }
        }

        public void setIngredients(List items) {
            for (int ingred = 0; ingred < items.size(); ++ingred) {
                this.ingredients.add(new PositionedStack((Object)((ItemStack)items.get(ingred)).func_77946_l(), 14 + stackorder[ingred][0] * 18, 7 + stackorder[ingred][1] * 18));
            }
        }

        public CachedSqueezerRecipe replaceMetaOnBottlerSlots(ItemStack ingredient) {
            if (this.slot_output.items.length == 1 && this.slot_can == null) {
                return this;
            }
            for (int i = 0; i < this.slot_output.items.length; ++i) {
                if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)this.slot_output.items[i])) continue;
                this.slot_output.item = this.slot_output.items[i];
                this.slot_output.item.func_77964_b(ingredient.func_77960_j());
                this.slot_output.items = new ItemStack[]{this.slot_output.item};
                this.slot_output.setPermutationToRender(0);
                this.slot_can.item = this.slot_can.items[i];
                this.slot_can.items = new ItemStack[]{this.slot_can.item};
                this.slot_can.setPermutationToRender(0);
                break;
            }
            return this;
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(SqueezerRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public boolean contains(ItemStack ingredient) {
            return this.contains(this.ingredients, ingredient);
        }

        public PositionedStack getResult() {
            return LiquidHelper.getSeqCycledStack(SqueezerRecipeHandler.this.cycleticks / 20, this.slot_output);
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.remnants != null) {
                stacks.add(this.remnants);
            }
            if (this.slot_can != null) {
                stacks.add(LiquidHelper.getSeqCycledStack(SqueezerRecipeHandler.this.cycleticks / 20, this.slot_can));
            }
            return stacks;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.output);
            return res;
        }
    }
}

