/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forge;

import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import mods.neiplugins.common.Utils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryList
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Ore Dictionary";
    }

    public String getRecipeId() {
        return "forge.oredictionary";
    }

    public String getGuiTexture() {
        return "/mods/neiplugins/gfx/Item2Item.png";
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        gui.drawTextCentered(((CachedOreDictionaryEntry)((Object)this.arecipes.get((int)recipe))).name, 85, 9, -8355712, false);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 25, 16), this.getRecipeId(), new Object[0]));
    }

    protected ArrayList getAllItems() {
        ArrayList<CachedOreDictionaryEntry> result = new ArrayList<CachedOreDictionaryEntry>();
        Object[] oreNames = OreDictionary.getOreNames();
        Arrays.sort(oreNames);
        for (Object oreName : oreNames) {
            for (ItemStack ore : OreDictionary.getOres((String)oreName)) {
                result.add(new CachedOreDictionaryEntry(ore, (String)oreName));
            }
        }
        return result;
    }

    protected ArrayList getItemsByID(int id) {
        ArrayList<CachedOreDictionaryEntry> result = new ArrayList<CachedOreDictionaryEntry>();
        for (ItemStack ore : OreDictionary.getOres((Integer)id)) {
            result.add(new CachedOreDictionaryEntry(ore, OreDictionary.getOreName((int)id)));
        }
        return result;
    }

    public void loadCraftingRecipes(String outputId, Object[] results) {
        if (outputId.equals(this.getRecipeId())) {
            for (CachedOreDictionaryEntry recipe : this.getAllItems()) {
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (!Utils.getBooleanSetting("mistaqur.showUsageInOreDictionary")) {
            return;
        }
        int oreID = OreDictionary.getOreID((ItemStack)ingredient);
        if (oreID != -1) {
            for (CachedOreDictionaryEntry recipe : this.getItemsByID(oreID)) {
                if (!recipe.contains(recipe.content, ingredient)) continue;
                this.arecipes.add(recipe);
            }
        }
    }

    public class CachedOreDictionaryEntry
    extends TemplateRecipeHandler.CachedRecipe {
        public String name;
        public ArrayList content;

        public CachedOreDictionaryEntry(ItemStack ore, String name) {
            super((TemplateRecipeHandler)OreDictionaryList.this);
            this.name = name;
            this.content = new ArrayList();
            this.content.add(new PositionedStack((Object)ore, 51, 24));
            this.content.add(new PositionedStack((Object)OreDictionary.getOres((String)name), 111, 24));
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(OreDictionaryList.this.cycleticks / 20, this.content);
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

