/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.gregtech;

import gregtechmod.api.util.GT_Recipe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.FuelTooltip;
import mods.neiplugins.common.IFuelContextHelper;
import mods.neiplugins.common.SimpleFuelContextHelper;
import mods.neiplugins.common.SimpleFuelHelper;
import mods.neiplugins.common.Utils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class GregTechFuelHelper
implements IFuelContextHelper {
    public static HashMap sDieselFuels = new HashMap();
    public static HashMap sTurbineFuels = new HashMap();
    public static HashMap sHotFuels = new HashMap();
    public static HashMap sDenseLiquidFuels = new HashMap();
    public static HashMap sPlasmaFuels = new HashMap();
    public static HashMap sMagicFuels = new HashMap();
    public static HashMap tooltipRemover = new HashMap();
    private static boolean isAPI307;

    @Override
    public String getName() {
        return "Gregtech Generators";
    }

    @Override
    public String getKey() {
        return "gregtech.fuels";
    }

    @Override
    public List getDescription() {
        return null;
    }

    @Override
    public List getContextTooltip(GuiContainer gui, ItemStack stack, List currenttip) {
        return currenttip;
    }

    @Override
    public boolean haveContextTooltip(GuiContainer gui) {
        return false;
    }

    @Override
    public boolean displayFuelTooltip(GuiContainer gui) {
        return true;
    }

    public static void registerFuelHelpers() {
        FuelTooltip.addFuelHelper(new GTFuelHelper("gregtech.diesel", "Diesel Generator", null, sDieselFuels, "at 12 EU/t (Diesel Generator)"));
        FuelTooltip.addFuelHelper(new GTFuelHelper("gregtech.turbine", "Gas Turbine", null, sTurbineFuels, "at 16 EU/t (Gas Turbine)"));
        FuelTooltip.addFuelHelper(new GTFuelHelper("gregtech.hot", "Thermal Generator", null, sHotFuels, "at 24 EU/t (Thermal Generator)"));
        FuelTooltip.addFuelHelper(new GTFuelHelper("gregtech.denseliquid", "Semi Fluid Generator", null, sDenseLiquidFuels, "at 8 EU/t (Semi Fluid Generator)"));
        FuelTooltip.addFuelHelper(new GTFuelHelper("gregtech.plasma", "Plasma Generator", null, sPlasmaFuels, "at 2048 EU/t (Plasma Generator)"));
        FuelTooltip.addFuelHelper(new GTFuelHelper("gregtech.magic", "Magic Energy Converter", null, sMagicFuels, "at 24 EU/t (Magic Energy Converter)"));
        HashMap<Class, String> map = new HashMap<Class, String>();
        Class cls = Utils.findClass("gregtechmod.common.gui.GT_GUIContainer_DieselGenerator");
        if (cls != null) {
            map.put(cls, "gregtech.diesel");
        }
        if ((cls = Utils.findClass("gregtechmod.common.gui.GT_GUIContainer_GasTurbine")) != null) {
            map.put(cls, "gregtech.turbine");
        }
        if ((cls = Utils.findClass("gregtechmod.common.gui.GT_GUIContainer_ThermalGenerator")) != null) {
            map.put(cls, "gregtech.hot");
        }
        if ((cls = Utils.findClass("gregtechmod.common.gui.GT_GUIContainer_SemifluidGenerator")) != null) {
            map.put(cls, "gregtech.denseliquid");
        }
        if ((cls = Utils.findClass("gregtechmod.common.gui.GT_GUIContainer_PlasmaGenerator")) != null) {
            map.put(cls, "gregtech.plasma");
        }
        if ((cls = Utils.findClass("gregtechmod.common.gui.GT_GUIContainer_MagicEnergyConverter")) != null) {
            map.put(cls, "gregtech.magic");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("gregtech.all", "GregTech", null, map));
        }
    }

    public static List findFuelTooltip(List key, HashMap map, int amount, String suffix, List currenttip) {
        GT_Recipe recipe = (GT_Recipe)map.get(key);
        if (recipe != null) {
            currenttip.add("\u00a77" + FuelTooltip.compactValue(recipe.mStartEU * amount) + " EU " + suffix);
        }
        return currenttip;
    }

    public static ItemStack getFuelItemStack(GT_Recipe recipe) {
        if (isAPI307) {
            return recipe.getRepresentativeInput1();
        }
        return recipe.mInput1;
    }

    public static boolean buildCache() {
        LiquidStack liquid;
        boolean bl = isAPI307 = Utils.findMethod(GT_Recipe.class, "getRepresentativeInput1", new Class[0]) != null;
        if (!isAPI307 && Utils.findField(GT_Recipe.class, "mInput1") == null) {
            NEIPlugins.logWarning("Failed to build cache for gregtech fuels", new Object[0]);
            return false;
        }
        for (GT_Recipe recipe : GT_Recipe.sDieselFuels) {
            liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)GregTechFuelHelper.getFuelItemStack(recipe));
            if (liquid == null) {
                sDieselFuels.put(Arrays.asList(GregTechFuelHelper.getFuelItemStack((GT_Recipe)recipe).field_77993_c, GregTechFuelHelper.getFuelItemStack(recipe).func_77960_j()), recipe);
                tooltipRemover.put(Arrays.asList(GregTechFuelHelper.getFuelItemStack((GT_Recipe)recipe).field_77993_c, GregTechFuelHelper.getFuelItemStack(recipe).func_77960_j()), recipe);
                continue;
            }
            sDieselFuels.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
            tooltipRemover.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sTurbineFuels) {
            liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)GregTechFuelHelper.getFuelItemStack(recipe));
            if (liquid == null) {
                sTurbineFuels.put(Arrays.asList(GregTechFuelHelper.getFuelItemStack((GT_Recipe)recipe).field_77993_c, GregTechFuelHelper.getFuelItemStack(recipe).func_77960_j()), recipe);
                tooltipRemover.put(Arrays.asList(GregTechFuelHelper.getFuelItemStack((GT_Recipe)recipe).field_77993_c, GregTechFuelHelper.getFuelItemStack(recipe).func_77960_j()), recipe);
                continue;
            }
            sTurbineFuels.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
            tooltipRemover.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sHotFuels) {
            liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)GregTechFuelHelper.getFuelItemStack(recipe));
            if (liquid == null) {
                tooltipRemover.put(Arrays.asList(GregTechFuelHelper.getFuelItemStack((GT_Recipe)recipe).field_77993_c, GregTechFuelHelper.getFuelItemStack(recipe).func_77960_j()), recipe);
                sHotFuels.put(Arrays.asList(GregTechFuelHelper.getFuelItemStack((GT_Recipe)recipe).field_77993_c, GregTechFuelHelper.getFuelItemStack(recipe).func_77960_j()), recipe);
                continue;
            }
            sHotFuels.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
            tooltipRemover.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sDenseLiquidFuels) {
            liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)GregTechFuelHelper.getFuelItemStack(recipe));
            if (liquid == null) {
                sDenseLiquidFuels.put(Arrays.asList(GregTechFuelHelper.getFuelItemStack((GT_Recipe)recipe).field_77993_c, GregTechFuelHelper.getFuelItemStack(recipe).func_77960_j()), recipe);
                tooltipRemover.put(Arrays.asList(GregTechFuelHelper.getFuelItemStack((GT_Recipe)recipe).field_77993_c, GregTechFuelHelper.getFuelItemStack(recipe).func_77960_j()), recipe);
                continue;
            }
            sDenseLiquidFuels.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
            tooltipRemover.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sPlasmaFuels) {
            liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)GregTechFuelHelper.getFuelItemStack(recipe));
            if (liquid == null) {
                sPlasmaFuels.put(Arrays.asList(GregTechFuelHelper.getFuelItemStack((GT_Recipe)recipe).field_77993_c, GregTechFuelHelper.getFuelItemStack(recipe).func_77960_j()), recipe);
                tooltipRemover.put(Arrays.asList(GregTechFuelHelper.getFuelItemStack((GT_Recipe)recipe).field_77993_c, GregTechFuelHelper.getFuelItemStack(recipe).func_77960_j()), recipe);
                continue;
            }
            sPlasmaFuels.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
            tooltipRemover.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sMagicFuels) {
            liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)GregTechFuelHelper.getFuelItemStack(recipe));
            if (liquid == null) {
                sMagicFuels.put(Arrays.asList(GregTechFuelHelper.getFuelItemStack((GT_Recipe)recipe).field_77993_c, GregTechFuelHelper.getFuelItemStack(recipe).func_77960_j()), recipe);
                tooltipRemover.put(Arrays.asList(GregTechFuelHelper.getFuelItemStack((GT_Recipe)recipe).field_77993_c, GregTechFuelHelper.getFuelItemStack(recipe).func_77960_j()), recipe);
                continue;
            }
            sMagicFuels.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
            tooltipRemover.put(Arrays.asList(liquid.itemID, liquid.itemMeta), recipe);
        }
        return true;
    }

    static class GTFuelHelper
    extends SimpleFuelHelper {
        HashMap map;
        String suffix;

        public GTFuelHelper(String key, String name, List desc, HashMap map, String suffix) {
            super(key, name, desc);
            this.map = map;
            this.suffix = suffix;
        }

        @Override
        public List getLiquidStackFuelTooltip(LiquidStack liquid, List currenttip) {
            GregTechFuelHelper.findFuelTooltip(Arrays.asList(liquid.itemID, liquid.itemMeta), this.map, liquid.amount, this.suffix, currenttip);
            return currenttip;
        }

        @Override
        public List getItemStackFuelTooltip(ItemStack stack, List currenttip) {
            GregTechFuelHelper.findFuelTooltip(Arrays.asList(stack.field_77993_c, stack.func_77960_j()), this.map, 1000, this.suffix, currenttip);
            return currenttip;
        }
    }
}

