/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.ic2;

import ic2.api.info.Info;
import java.util.HashMap;
import java.util.List;
import mods.neiplugins.common.FuelTooltip;
import mods.neiplugins.common.SimpleFuelContextHelper;
import mods.neiplugins.common.SimpleFuelHelper;
import mods.neiplugins.common.Utils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public abstract class IC2FuelHelper {
    public static int energyGeneratorBase;
    public static int energyGeneratorGeo;

    public static void registerFuelHelpers() {
        Class IC2 = Utils.findClass("ic2.core.IC2");
        if (IC2 == null) {
            return;
        }
        energyGeneratorBase = Utils.getFieldInt(IC2, "energyGeneratorBase", null);
        energyGeneratorGeo = Utils.getFieldInt(IC2, "energyGeneratorGeo", null);
        if (energyGeneratorBase > 0) {
            FuelTooltip.addFuelHelper(new SimpleFuelHelper("ic2.generator", "IC2 Generator", null){

                @Override
                public List getItemStackFuelTooltip(ItemStack stack, List currenttip) {
                    int energy = Info.itemFuel.getFuelValue(stack, false) / 4;
                    if (energy > 0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(energy * energyGeneratorBase) + " EU at " + energyGeneratorBase + " EU/t (Generator)");
                    }
                    return currenttip;
                }
            });
        }
        if (energyGeneratorGeo > 0) {
            FuelTooltip.addFuelHelper(new SimpleFuelHelper("ic2.geothermal", "Geothermal Generator", null){

                @Override
                public List getLiquidStackFuelTooltip(LiquidStack liquid, List currenttip) {
                    if (liquid.itemID == Block.field_71938_D.field_71990_ca) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(liquid.amount * energyGeneratorGeo) + " EU at " + energyGeneratorGeo + " EU/t (Geothermal Generator)");
                    }
                    return currenttip;
                }
            });
        }
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("ic2.watermill", "Water Mill", null){

            @Override
            public List getItemStackFuelTooltip(ItemStack stack, List currenttip) {
                LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)stack);
                if (liquid != null && liquid.itemID == Block.field_71943_B.field_71990_ca) {
                    if (stack.func_77973_b().func_77634_r()) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(500) + " EU at " + 1 + " EU/t (Water Mill)");
                    } else {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(1000) + " EU at " + 2 + " EU/t (Water Mill)");
                    }
                }
                return currenttip;
            }
        });
        HashMap<Class, String> map = new HashMap<Class, String>();
        Class cls = Utils.findClass("ic2.core.block.generator.gui.GuiGenerator");
        if (cls != null && energyGeneratorBase > 0) {
            map.put(cls, "ic2.generator");
        }
        if ((cls = Utils.findClass("ic2.core.block.generator.gui.GuiGeoGenerator")) != null && energyGeneratorGeo > 0) {
            map.put(cls, "ic2.geothermal");
        }
        if ((cls = Utils.findClass("ic2.core.block.generator.gui.GuiWaterGenerator")) != null) {
            map.put(cls, "ic2.watermill");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("ic2.all", "IC2", null, map));
        }
    }
}

