/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.mfr;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomItem;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import powercrystals.core.random.WeightedRandomItemStack;
import powercrystals.minefactoryreloaded.MFRRegistry;

public class SludgeRecipeHandler
extends LiquidTemplateRecipeHandler {
    public static Rectangle inputTank = new Rectangle(42, 20, 24, 24);
    public static LiquidTank input = null;
    public static DecimalFormat chanceFormat = new DecimalFormat("0.##%");
    public static int totalWeight = 1;

    protected List getRecipeList() {
        List recipes = MFRRegistry.getSludgeDrops();
        totalWeight = WeightedRandom.func_76272_a((Collection)recipes);
        return recipes;
    }

    public static boolean loadLiquid() {
        LiquidStack liquid = LiquidDictionary.getCanonicalLiquid((String)"sludge");
        if (liquid == null) {
            return false;
        }
        input = new LiquidTank(liquid, 1000, inputTank);
        SludgeRecipeHandler.input.liquid.amount = 1000;
        SludgeRecipeHandler.input.showCapacity = false;
        return true;
    }

    public String getRecipeName() {
        return "Sludge Boiler";
    }

    @Override
    public String getRecipeId() {
        return "mfr.sludge";
    }

    public String getGuiTexture() {
        return "/mods/neiplugins/gfx/Liquid2Item.png";
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        Float chance = ((CachedSludgeRecipe)this.arecipes.get(recipe)).getChance();
        String chanceString = chanceFormat.format(chance);
        gui.drawTextCentered(chanceString, 85, 11, -8355712, false);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 25, 16), this.getRecipeId(), new Object[0]));
    }

    @Override
    public void loadSameRecipeId() {
        for (WeightedRandomItem irecipe : this.getRecipeList()) {
            if (!(irecipe instanceof WeightedRandomItemStack)) continue;
            this.arecipes.add(new CachedSludgeRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (WeightedRandomItem irecipe : this.getRecipeList()) {
            if (!(irecipe instanceof WeightedRandomItemStack) || !NEIClientUtils.areStacksSameTypeCrafting((ItemStack)((WeightedRandomItemStack)irecipe).getStack(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedSludgeRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        LiquidStack t = LiquidHelper.getLiquidStack(ingredient);
        if (t != null) {
            this.loadUsageRecipes(t);
        }
    }

    @Override
    public void loadUsageRecipes(LiquidStack ingredient) {
        if (input != null && LiquidHelper.areSameLiquid(ingredient, SludgeRecipeHandler.input.liquid)) {
            this.loadSameRecipeId();
        }
    }

    public class CachedSludgeRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        public PositionedStack result;
        public int weight;

        public CachedSludgeRecipe(WeightedRandomItem entry) {
            super((TemplateRecipeHandler)SludgeRecipeHandler.this);
            this.result = new PositionedStack((Object)((WeightedRandomItemStack)entry).getStack(), 111, 24);
            this.weight = entry.field_76292_a;
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public Float getChance() {
            if (totalWeight > 0) {
                return Float.valueOf(1.0f * (float)this.weight / (float)totalWeight);
            }
            return Float.valueOf(0.0f);
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            if (input != null) {
                res.add(input);
            }
            return res;
        }
    }
}

