/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.tconstruct;

import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import mods.tinker.tconstruct.library.crafting.AlloyMix;
import mods.tinker.tconstruct.library.crafting.Smeltery;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class AlloySmelteryRecipeHandler
extends LiquidTemplateRecipeHandler {
    public static final int xOffset = 0;
    static Rectangle outputTank = new Rectangle(118, 9, 18, 32);

    public String getRecipeName() {
        return "Alloy Smeltery";
    }

    @Override
    public String getRecipeId() {
        return "tconstruct.alloysmeltery";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(76, 21, 22, 15), this.getRecipeId(), new Object[0]));
    }

    private boolean isValidRecipe(AlloyMix recipe) {
        return !recipe.mixers.isEmpty();
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (AlloyMix recipe : Smeltery.getAlloyList()) {
                if (!this.isValidRecipe(recipe)) continue;
                this.arecipes.add(new CachedAlloyMixRecipe(recipe));
            }
        } else if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)results[0];
            for (AlloyMix recipe : Smeltery.getAlloyList()) {
                if (!recipe.result.isLiquidEqual(t) || !this.isValidRecipe(recipe)) continue;
                this.arecipes.add(new CachedAlloyMixRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)ingredients[0];
            block0: for (AlloyMix recipe : Smeltery.getAlloyList()) {
                for (LiquidStack liquid : recipe.mixers) {
                    if (!liquid.isLiquidEqual(t) || !this.isValidRecipe(recipe)) continue;
                    this.arecipes.add(new CachedAlloyMixRecipe(recipe));
                    continue block0;
                }
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingred) {
        LiquidStack t = LiquidHelper.getLiquidStack(ingred);
        if (t != null) {
            block0: for (AlloyMix recipe : Smeltery.getAlloyList()) {
                for (LiquidStack liquid : recipe.mixers) {
                    if (!liquid.isLiquidEqual(t) || !this.isValidRecipe(recipe)) continue;
                    this.arecipes.add(new CachedAlloyMixRecipe(recipe));
                    continue block0;
                }
            }
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        LiquidStack t = LiquidHelper.getLiquidStack(result);
        if (t != null) {
            for (AlloyMix recipe : Smeltery.getAlloyList()) {
                if (!recipe.result.isLiquidEqual(t) || !this.isValidRecipe(recipe)) continue;
                this.arecipes.add(new CachedAlloyMixRecipe(recipe));
            }
        }
    }

    public void drawBackground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTexture(this.getGuiTexture());
        gui.drawTexturedModalRect(0, 0, 0, 62, 160, 65);
    }

    public String getGuiTexture() {
        return "/mods/neiplugins/gfx/tc_smeltery.png";
    }

    public class CachedAlloyMixRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        ArrayList tanks;
        int minAmount;

        public CachedAlloyMixRecipe(AlloyMix recipe) {
            super((TemplateRecipeHandler)AlloySmelteryRecipeHandler.this);
            this.tanks = new ArrayList();
            int maxAmount = ((LiquidStack)recipe.mixers.get((int)0)).amount;
            int mult = 1;
            this.minAmount = maxAmount;
            for (LiquidStack stack : recipe.mixers) {
                if (stack.amount > maxAmount) {
                    maxAmount = stack.amount;
                }
                if (stack.amount >= this.minAmount) continue;
                this.minAmount = stack.amount;
            }
            LiquidTank tank = new LiquidTank(recipe.result, maxAmount * mult, outputTank);
            tank.showMillBuckets = true;
            tank.liquid.amount *= mult;
            tank.showCapacity = false;
            this.tanks.add(tank);
            int width = 36 / recipe.mixers.size();
            int counter = 0;
            for (LiquidStack stack : recipe.mixers) {
                tank = counter == recipe.mixers.size() - 1 ? new LiquidTank(stack, maxAmount * mult, new Rectangle(21 + width * counter, 9, 36 - width * counter, 32)) : new LiquidTank(stack, maxAmount * mult, new Rectangle(21 + width * counter, 9, width, 32));
                tank.showMillBuckets = true;
                tank.liquid.amount *= mult;
                tank.showCapacity = false;
                this.tanks.add(tank);
                ++counter;
            }
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getIngredient() {
            return null;
        }

        @Override
        public ArrayList getLiquidTanks() {
            return this.tanks;
        }
    }
}

