/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.thaumcraft;

import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import mods.neiplugins.common.Utils;
import mods.neiplugins.thaumcraft.TCUtils;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.EnumTag;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.IInfusionRecipe;
import thaumcraft.api.crafting.ShapedInfusionCraftingRecipes;
import thaumcraft.api.crafting.ShapelessInfusionCraftingRecipes;

public abstract class InfuserRecipeHandler
extends LiquidTemplateRecipeHandler {
    static final int xoffset = 3;
    static final int yoffset = 7;
    static final int xgridoffset = 12;
    static final int ygridoffset = 13;
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}, {0, 2}, {1, 2}, {2, 0}, {2, 1}, {2, 2}};

    public abstract String getRecipeNameSub();

    public abstract boolean isValidRecipe(IInfusionRecipe var1);

    public abstract boolean containIngredient(IInfusionRecipe var1, ItemStack var2);

    public abstract void setIngredient(CachedInfuserRecipe var1, IInfusionRecipe var2);

    public String getRecipeName() {
        return "Infusion Altar";
    }

    @Override
    public String getRecipeId() {
        return "thaumcraft.infuser";
    }

    public String getGuiTexture() {
        return "/mods/thaumcraft/textures/gui/gui_researchbook_overlay.png";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(115, 63, 24, 24), this.getRecipeId(), new Object[0]));
    }

    public void drawBackground(GuiContainerManager gui, int recipe) {
        gui.bindTexture(this.getGuiTexture());
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)3.0f, (float)7.0f, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        gui.drawTexturedModalRect(0, 0, 112, 15, 52, 52);
        gui.drawTexturedModalRect(0, 52, 112, 70, 52, 9);
        gui.drawTexturedModalRect(58, 8, 20, 3, 16, 16);
        gui.drawTexturedModalRect(56, 28, 68, 76, 12, 12);
        GL11.glPopMatrix();
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        if (recipe % this.recipiesPerPage() == 0) {
            gui.drawTextCentered(this.getRecipeNameSub(), gui.window.field_74194_b / 2 - 5, -1, 0x404040, false);
        }
        IInfusionRecipe rc = ((CachedInfuserRecipe)((Object)this.arecipes.get((int)recipe))).recipe;
        ObjectTags tags = rc.getTags();
        gui.drawText(125, 78, rc.getCost() + " vis", -8355712, false);
        if (tags != null && tags.size() > 0) {
            int count = 0;
            for (EnumTag tag : tags.getAspects()) {
                TCUtils.drawTag(gui.window, 13 + 18 * count + (5 - tags.size()) * 8, 112, tag, tags.getAmount(tag), false, true);
                ++count;
            }
        }
    }

    @Override
    public List handleTooltip(GuiRecipe guiRecipe, List currenttip, int recipe) {
        currenttip = super.handleTooltip(guiRecipe, currenttip, recipe);
        IInfusionRecipe rc = ((CachedInfuserRecipe)((Object)this.arecipes.get((int)recipe))).recipe;
        ObjectTags tags = rc.getTags();
        if (tags != null && tags.size() > 0) {
            Point mousepos = guiRecipe.manager.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.field_74198_m - offset.x, mousepos.y - guiRecipe.field_74197_n - offset.y);
            int count = 0;
            for (EnumTag tag : tags.getAspects()) {
                int tx = 13 + 18 * count + (5 - tags.size()) * 8;
                int ty = 112;
                if (relMouse.x >= tx && relMouse.y >= ty && relMouse.x < tx + 16 && relMouse.y < ty + 16) {
                    currenttip.add("\u00a7B" + tag.name);
                    currenttip.add("\u00a77" + tag.meaning);
                }
                ++count;
            }
        }
        return currenttip;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public ArrayList getRecipeList() {
        ArrayList<IInfusionRecipe> result = new ArrayList<IInfusionRecipe>();
        for (Object recipe : ThaumcraftApi.getCraftingRecipes()) {
            if (!(recipe instanceof IInfusionRecipe) || !TCUtils.isResearchComplete(((IInfusionRecipe)recipe).getKey()) || !this.isValidRecipe((IInfusionRecipe)recipe)) continue;
            result.add((IInfusionRecipe)recipe);
        }
        return result;
    }

    @Override
    public void loadSameRecipeId() {
        for (IInfusionRecipe irecipe : this.getRecipeList()) {
            this.arecipes.add(new CachedInfuserRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IInfusionRecipe irecipe : this.getRecipeList()) {
            if (!Utils.areStacksSameTypeCrafting(irecipe.getRecipeOutput(), result)) continue;
            this.arecipes.add(new CachedInfuserRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IInfusionRecipe irecipe : this.getRecipeList()) {
            if (!this.containIngredient(irecipe, ingredient)) continue;
            this.arecipes.add(new CachedInfuserRecipe(irecipe));
        }
    }

    public static class InfuserShapelessRecipeHandler
    extends InfuserRecipeHandler {
        @Override
        public String getRecipeNameSub() {
            return "Shapeless";
        }

        @Override
        public boolean isValidRecipe(IInfusionRecipe irecipe) {
            return irecipe instanceof ShapelessInfusionCraftingRecipes;
        }

        @Override
        public boolean containIngredient(IInfusionRecipe recipe, ItemStack stack) {
            ShapelessInfusionCraftingRecipes irecipe = (ShapelessInfusionCraftingRecipes)recipe;
            for (Object recipeStack : irecipe.recipeItems) {
                if (!(recipeStack instanceof ItemStack) || !Utils.areStacksSameTypeCrafting((ItemStack)recipeStack, stack)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setIngredient(CachedInfuserRecipe cachedRecipe, IInfusionRecipe recipe) {
            ShapelessInfusionCraftingRecipes irecipe = (ShapelessInfusionCraftingRecipes)recipe;
            int counter = 0;
            for (Object recipeStack : irecipe.recipeItems) {
                if (!(recipeStack instanceof ItemStack)) continue;
                PositionedStack stack = new PositionedStack((Object)((ItemStack)recipeStack).func_77946_l(), 15 + stackorder[counter][0] * 32, 20 + stackorder[counter][1] * 32);
                stack.setMaxSize(1);
                cachedRecipe.ingredients.add(stack);
                ++counter;
            }
        }
    }

    public static class InfuserShapedRecipeHandler
    extends InfuserRecipeHandler {
        @Override
        public String getRecipeNameSub() {
            return "Shaped";
        }

        @Override
        public boolean isValidRecipe(IInfusionRecipe irecipe) {
            return irecipe instanceof ShapedInfusionCraftingRecipes;
        }

        @Override
        public boolean containIngredient(IInfusionRecipe recipe, ItemStack stack) {
            ShapedInfusionCraftingRecipes irecipe = (ShapedInfusionCraftingRecipes)recipe;
            for (int i = 0; i < irecipe.recipeWidth; ++i) {
                for (int j = 0; j < irecipe.recipeHeight; ++j) {
                    if (!Utils.areStacksSameTypeCrafting(irecipe.recipeItems[i + j * irecipe.recipeWidth], stack)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setIngredient(CachedInfuserRecipe cachedRecipe, IInfusionRecipe recipe) {
            ShapedInfusionCraftingRecipes irecipe = (ShapedInfusionCraftingRecipes)recipe;
            for (int i = 0; i < irecipe.recipeWidth; ++i) {
                for (int j = 0; j < irecipe.recipeHeight; ++j) {
                    ItemStack ingredient = irecipe.recipeItems[i + j * irecipe.recipeWidth];
                    if (ingredient == null) continue;
                    PositionedStack stack = new PositionedStack((Object)ingredient.func_77946_l(), 15 + i * 32, 20 + j * 32);
                    stack.setMaxSize(1);
                    cachedRecipe.ingredients.add(stack);
                }
            }
        }
    }

    public class CachedInfuserRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack result;
        public ArrayList ingredients;
        public IInfusionRecipe recipe;

        public CachedInfuserRecipe(IInfusionRecipe irecipe) {
            super((TemplateRecipeHandler)InfuserRecipeHandler.this);
            this.recipe = irecipe;
            this.result = new PositionedStack((Object)irecipe.getRecipeOutput(), 127, 31);
            this.ingredients = new ArrayList();
            InfuserRecipeHandler.this.setIngredient(this, irecipe);
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(InfuserRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

