/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.bottombar;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.kc.main.Main;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.events.RefreshedProfilesListener;
import net.minecraft.launcher.events.RefreshedVersionsListener;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.profile.ProfileManager;
import net.minecraft.launcher.updater.VersionManager;
import net.minecraft.launcher.updater.VersionSyncInfo;

public class PlayerInfoPanel
extends JPanel
implements RefreshedProfilesListener,
RefreshedVersionsListener {
    private final Launcher launcher;
    private final JLabel welcomeText = new JLabel("", 0);
    private final JLabel versionText = new JLabel("", 0);
    private final JButton logOutButton = new JButton("Log Out");
    private final JButton supportButton = new JButton(Main.cbuttontext);

    public PlayerInfoPanel(final Launcher launcher) {
        this.launcher = launcher;
        launcher.getProfileManager().addRefreshedProfilesListener(this);
        this.checkState();
        this.createInterface();
        this.logOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                launcher.getProfileManager().getSelectedProfile().setPlayerUUID(null);
                launcher.getProfileManager().trimAuthDatabase();
                launcher.showLoginPrompt();
            }
        });
        this.supportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(Main.cbuttonlink));
                }
                catch (IOException ex) {
                    Logger.getLogger(PlayerInfoPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(PlayerInfoPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    protected void createInterface() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 2;
        this.add((Component)this.welcomeText, constraints);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.gridwidth = 2;
        this.add((Component)this.versionText, constraints);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        ++constraints.gridy;
        constraints.weightx = 0.5;
        constraints.fill = 0;
        this.add((Component)this.logOutButton, constraints);
        constraints.weightx = 0.0;
        ++constraints.gridy;
        if (!Main.cbuttontext.equalsIgnoreCase("")) {
            constraints.weightx = 0.5;
            constraints.fill = 0;
            this.add((Component)this.supportButton, constraints);
            constraints.weightx = 0.0;
            ++constraints.gridy;
        }
    }

    @Override
    public void onProfilesRefreshed(ProfileManager manager) {
        this.checkState();
    }

    public void checkState() {
        VersionSyncInfo version;
        Profile profile = this.launcher.getProfileManager().getProfiles().isEmpty() ? null : this.launcher.getProfileManager().getSelectedProfile();
        AuthenticationService auth = profile == null ? null : this.launcher.getProfileManager().getAuthDatabase().getByUUID(profile.getPlayerUUID());
        List<VersionSyncInfo> versions = profile == null ? null : this.launcher.getVersionManager().getVersions(profile.getVersionFilter());
        VersionSyncInfo versionSyncInfo = version = profile == null || versions.isEmpty() ? null : versions.get(0);
        if (profile != null && profile.getLastVersionId() != null) {
            version = this.launcher.getVersionManager().getVersionSyncInfo(profile.getLastVersionId());
        }
        if (auth == null) {
            this.welcomeText.setText("Welcome, guest! Please log in.");
            this.logOutButton.setEnabled(false);
        } else if (auth.getSelectedProfile() == null) {
            this.welcomeText.setText("<html>Welcome, player!</html>");
            this.logOutButton.setEnabled(true);
        } else {
            this.welcomeText.setText("<html>Welcome, <b>" + auth.getSelectedProfile().getName() + "</b></html>");
            this.logOutButton.setEnabled(true);
        }
        if (version == null) {
            this.versionText.setText("Loading versions...");
        } else if (version.isUpToDate()) {
            this.versionText.setText("Ready to play Minecraft " + version.getLatestVersion().getId());
        } else if (version.isInstalled()) {
            this.versionText.setText("Ready to update & play Minecraft " + version.getLatestVersion().getId());
        } else if (version.isOnRemote()) {
            this.versionText.setText("Ready to download & play Minecraft " + version.getLatestVersion().getId());
        }
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        this.checkState();
    }

    @Override
    public boolean shouldReceiveEventsInUIThread() {
        return true;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }
}

