/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.launcher.OperatingSystem;

public class Rule {
    private Action action = Action.ALLOW;
    private OSRestriction os;

    public Rule() {
    }

    public Rule(Rule rule) {
        this.action = rule.action;
        if (rule.os != null) {
            this.os = new OSRestriction(rule.os);
        }
    }

    public Action getAppliedAction() {
        if (this.os != null && !this.os.isCurrentOperatingSystem()) {
            return null;
        }
        return this.action;
    }

    public Action getAction() {
        return this.action;
    }

    public OSRestriction getOs() {
        return this.os;
    }

    public String toString() {
        return "Rule{action=" + (Object)((Object)this.action) + ", os=" + this.os + '}';
    }

    public class OSRestriction {
        private OperatingSystem name;
        private String version;

        public OSRestriction() {
        }

        public OperatingSystem getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public OSRestriction(OSRestriction osRestriction) {
            this.name = osRestriction.name;
            this.version = osRestriction.version;
        }

        public boolean isCurrentOperatingSystem() {
            if (this.name != null && this.name != OperatingSystem.getCurrentPlatform()) {
                return false;
            }
            if (this.version != null) {
                try {
                    Pattern pattern = Pattern.compile(this.version);
                    Matcher matcher = pattern.matcher(System.getProperty("os.version"));
                    if (!matcher.matches()) {
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }

        public String toString() {
            return "OSRestriction{name=" + (Object)((Object)this.name) + ", version='" + this.version + '\'' + '}';
        }
    }

    public static enum Action {
        ALLOW,
        DISALLOW;

    }
}

