/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.ComboBox;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditFieldAutoCompletionWindow;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.FileTable;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ListBox;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TableBase;
import de.matthiasmann.twl.TreeComboBox;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BitfieldBooleanModel;
import de.matthiasmann.twl.model.FileSystemAutoCompletionDataSource;
import de.matthiasmann.twl.model.FileSystemModel;
import de.matthiasmann.twl.model.FileSystemTreeModel;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.MRUListModel;
import de.matthiasmann.twl.model.PersistentIntegerModel;
import de.matthiasmann.twl.model.PersistentMRUListModel;
import de.matthiasmann.twl.model.SimpleIntegerModel;
import de.matthiasmann.twl.model.SimpleListModel;
import de.matthiasmann.twl.model.SimpleMRUListModel;
import de.matthiasmann.twl.model.ToggleButtonModel;
import de.matthiasmann.twl.model.TreeTableModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twl.utils.NaturalSortComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.prefs.Preferences;

public class FileSelector
extends DialogLayout {
    public static final NamedFileFilter AllFilesFilter = new NamedFileFilter("All files", null);
    private final IntegerModel flags;
    private final MRUListModel folderMRU;
    final MRUListModel filesMRU;
    private final TreeComboBox currentFolder;
    private final Label labelCurrentFolder;
    private final FileTable fileTable;
    private final ScrollPane fileTableSP;
    private final Button btnUp;
    private final Button btnHome;
    private final Button btnFolderMRU;
    private final Button btnFilesMRU;
    private final Button btnOk;
    private final Button btnCancel;
    private final Button btnRefresh;
    private final Button btnShowFolders;
    private final Button btnShowHidden;
    private final ComboBox fileFilterBox;
    private final FileFiltersModel fileFiltersModel;
    private final EditFieldAutoCompletionWindow autoCompletion;
    private boolean allowFolderSelection;
    private Callback[] callbacks;
    private NamedFileFilter activeFileFilter;
    FileSystemModel fsm;
    private FileSystemTreeModel model;
    private Widget userWidgetBottom;
    private Widget userWidgetRight;
    private Object fileToSelectOnSetCurrentNode;

    public FileSelector() {
        this(null, null);
    }

    public FileSelector(Preferences prefs, String prefsKey) {
        if (prefs == null != (prefsKey == null)) {
            throw new IllegalArgumentException("'prefs' and 'prefsKey' must both be valid or both null");
        }
        if (prefs != null) {
            this.flags = new PersistentIntegerModel(prefs, prefsKey.concat("_Flags"), 0, 65535, 0);
            this.folderMRU = new PersistentMRUListModel(10, String.class, prefs, prefsKey.concat("_foldersMRU"));
            this.filesMRU = new PersistentMRUListModel(20, String.class, prefs, prefsKey.concat("_filesMRU"));
        } else {
            this.flags = new SimpleIntegerModel(0, 65535, 0);
            this.folderMRU = new SimpleMRUListModel(10);
            this.filesMRU = new SimpleMRUListModel(20);
        }
        this.currentFolder = new TreeComboBox();
        this.currentFolder.setTheme("currentFolder");
        this.fileTable = new FileTable();
        this.fileTable.setTheme("fileTable");
        this.fileTable.addCallback(new FileTable.Callback(){

            @Override
            public void selectionChanged() {
                FileSelector.this.selectionChanged();
            }

            @Override
            public void sortingChanged() {
            }
        });
        this.btnUp = new Button();
        this.btnUp.setTheme("buttonUp");
        this.btnUp.addCallback(new Runnable(){

            @Override
            public void run() {
                FileSelector.this.goOneLevelUp();
            }
        });
        this.btnHome = new Button();
        this.btnHome.setTheme("buttonHome");
        this.btnHome.addCallback(new Runnable(){

            @Override
            public void run() {
                FileSelector.this.goHome();
            }
        });
        this.btnFolderMRU = new Button();
        this.btnFolderMRU.setTheme("buttonFoldersMRU");
        this.btnFolderMRU.addCallback(new Runnable(){

            @Override
            public void run() {
                FileSelector.this.showFolderMRU();
            }
        });
        this.btnFilesMRU = new Button();
        this.btnFilesMRU.setTheme("buttonFilesMRU");
        this.btnFilesMRU.addCallback(new Runnable(){

            @Override
            public void run() {
                FileSelector.this.showFilesMRU();
            }
        });
        this.btnOk = new Button();
        this.btnOk.setTheme("buttonOk");
        this.btnOk.addCallback(new Runnable(){

            @Override
            public void run() {
                FileSelector.this.acceptSelection();
            }
        });
        this.btnCancel = new Button();
        this.btnCancel.setTheme("buttonCancel");
        this.btnCancel.addCallback(new Runnable(){

            @Override
            public void run() {
                FileSelector.this.fireCanceled();
            }
        });
        this.currentFolder.setPathResolver(new TreeComboBox.PathResolver(){

            @Override
            public TreeTableNode resolvePath(TreeTableModel model, String path) throws IllegalArgumentException {
                return FileSelector.this.resolvePath(path);
            }
        });
        this.currentFolder.addCallback(new TreeComboBox.Callback(){

            @Override
            public void selectedNodeChanged(TreeTableNode node, TreeTableNode previousChildNode) {
                FileSelector.this.setCurrentNode(node, previousChildNode);
            }
        });
        this.autoCompletion = new EditFieldAutoCompletionWindow(this.currentFolder.getEditField());
        this.autoCompletion.setUseInvokeAsync(true);
        this.currentFolder.getEditField().setAutoCompletionWindow(this.autoCompletion);
        this.fileTable.setAllowMultiSelection(true);
        this.fileTable.addCallback(new TableBase.Callback(){

            @Override
            public void mouseDoubleClicked(int row, int column) {
                FileSelector.this.acceptSelection();
            }

            @Override
            public void mouseRightClick(int row, int column, Event evt) {
            }

            @Override
            public void columnHeaderClicked(int column) {
            }
        });
        this.activeFileFilter = AllFilesFilter;
        this.fileFiltersModel = new FileFiltersModel();
        this.fileFilterBox = new ComboBox(this.fileFiltersModel);
        this.fileFilterBox.setTheme("fileFiltersBox");
        this.fileFilterBox.setComputeWidthFromModel(true);
        this.fileFilterBox.setVisible(false);
        this.fileFilterBox.addCallback(new Runnable(){

            @Override
            public void run() {
                FileSelector.this.fileFilterChanged();
            }
        });
        this.labelCurrentFolder = new Label("Folder");
        this.labelCurrentFolder.setLabelFor(this.currentFolder);
        this.fileTableSP = new ScrollPane(this.fileTable);
        Runnable showBtnCallback = new Runnable(){

            @Override
            public void run() {
                FileSelector.this.refreshFileTable();
            }
        };
        this.btnRefresh = new Button();
        this.btnRefresh.setTheme("buttonRefresh");
        this.btnRefresh.addCallback(showBtnCallback);
        this.btnShowFolders = new Button(new ToggleButtonModel(new BitfieldBooleanModel(this.flags, 0), true));
        this.btnShowFolders.setTheme("buttonShowFolders");
        this.btnShowFolders.addCallback(showBtnCallback);
        this.btnShowHidden = new Button(new ToggleButtonModel(new BitfieldBooleanModel(this.flags, 1), false));
        this.btnShowHidden.setTheme("buttonShowHidden");
        this.btnShowHidden.addCallback(showBtnCallback);
        this.addActionMapping("goOneLevelUp", "goOneLevelUp", new Object[0]);
        this.addActionMapping("acceptSelection", "acceptSelection", new Object[0]);
    }

    protected void createLayout() {
        this.setHorizontalGroup(null);
        this.setVerticalGroup(null);
        this.removeAllChildren();
        this.add(this.fileTableSP);
        this.add(this.fileFilterBox);
        this.add(this.btnOk);
        this.add(this.btnCancel);
        this.add(this.btnRefresh);
        this.add(this.btnShowFolders);
        this.add(this.btnShowHidden);
        this.add(this.labelCurrentFolder);
        this.add(this.currentFolder);
        this.add(this.btnFolderMRU);
        this.add(this.btnUp);
        DialogLayout.Group hCurrentFolder = this.createSequentialGroup().addWidget(this.labelCurrentFolder).addWidget(this.currentFolder).addWidget(this.btnFolderMRU).addWidget(this.btnUp).addWidget(this.btnHome);
        DialogLayout.Group vCurrentFolder = this.createParallelGroup().addWidget(this.labelCurrentFolder).addWidget(this.currentFolder).addWidget(this.btnFolderMRU).addWidget(this.btnUp).addWidget(this.btnHome);
        DialogLayout.Group hButtonGroup = this.createSequentialGroup().addWidget(this.btnRefresh).addGap(-2).addWidget(this.btnShowFolders).addWidget(this.btnShowHidden).addWidget(this.fileFilterBox).addGap("buttonBarLeft").addWidget(this.btnFilesMRU).addGap("buttonBarSpacer").addWidget(this.btnOk).addGap("buttonBarSpacer").addWidget(this.btnCancel).addGap("buttonBarRight");
        DialogLayout.Group vButtonGroup = this.createParallelGroup().addWidget(this.btnRefresh).addWidget(this.btnShowFolders).addWidget(this.btnShowHidden).addWidget(this.fileFilterBox).addWidget(this.btnFilesMRU).addWidget(this.btnOk).addWidget(this.btnCancel);
        DialogLayout.Group horz = this.createParallelGroup().addGroup(hCurrentFolder).addWidget(this.fileTableSP);
        DialogLayout.Group vert = this.createSequentialGroup().addGroup(vCurrentFolder).addWidget(this.fileTableSP);
        if (this.userWidgetBottom != null) {
            horz.addWidget(this.userWidgetBottom);
            vert.addWidget(this.userWidgetBottom);
        }
        if (this.userWidgetRight != null) {
            horz = this.createParallelGroup().addGroup(this.createSequentialGroup().addGroup(horz).addWidget(this.userWidgetRight));
            vert = this.createSequentialGroup().addGroup(this.createParallelGroup().addGroup(vert).addWidget(this.userWidgetRight));
        }
        this.setHorizontalGroup(horz.addGroup(hButtonGroup));
        this.setVerticalGroup(vert.addGroup(vButtonGroup));
    }

    @Override
    protected void afterAddToGUI(GUI gui) {
        super.afterAddToGUI(gui);
        this.createLayout();
    }

    public FileSystemModel getFileSystemModel() {
        return this.fsm;
    }

    public void setFileSystemModel(FileSystemModel fsm) {
        this.fsm = fsm;
        if (fsm == null) {
            this.model = null;
            this.currentFolder.setModel(null);
            this.fileTable.setCurrentFolder(null, null);
            this.autoCompletion.setDataSource(null);
        } else {
            this.model = new FileSystemTreeModel(fsm);
            this.model.setSorter(new NameSorter(fsm));
            this.currentFolder.setModel(this.model);
            this.currentFolder.setSeparator(fsm.getSeparator());
            this.autoCompletion.setDataSource(new FileSystemAutoCompletionDataSource(fsm, FileSystemTreeModel.FolderFilter.instance));
            if (!this.gotoFolderFromMRU(0) && !this.goHome()) {
                this.setCurrentNode(this.model);
            }
        }
    }

    public boolean getAllowMultiSelection() {
        return this.fileTable.getAllowMultiSelection();
    }

    public void setAllowMultiSelection(boolean allowMultiSelection) {
        this.fileTable.setAllowMultiSelection(allowMultiSelection);
    }

    public boolean getAllowFolderSelection() {
        return this.allowFolderSelection;
    }

    public void setAllowFolderSelection(boolean allowFolderSelection) {
        this.allowFolderSelection = allowFolderSelection;
        this.selectionChanged();
    }

    public boolean getAllowHorizontalScrolling() {
        return this.fileTableSP.getFixed() != ScrollPane.Fixed.HORIZONTAL;
    }

    public void setAllowHorizontalScrolling(boolean allowHorizontalScrolling) {
        this.fileTableSP.setFixed(allowHorizontalScrolling ? ScrollPane.Fixed.NONE : ScrollPane.Fixed.HORIZONTAL);
    }

    public void addCallback(Callback callback) {
        this.callbacks = (Callback[])CallbackSupport.addCallbackToList(this.callbacks, callback, Callback.class);
    }

    public void removeCallback(Callback callback) {
        this.callbacks = (Callback[])CallbackSupport.removeCallbackFromList((Object[])this.callbacks, callback);
    }

    public Widget getUserWidgetBottom() {
        return this.userWidgetBottom;
    }

    public void setUserWidgetBottom(Widget userWidgetBottom) {
        this.userWidgetBottom = userWidgetBottom;
        this.createLayout();
    }

    public Widget getUserWidgetRight() {
        return this.userWidgetRight;
    }

    public void setUserWidgetRight(Widget userWidgetRight) {
        this.userWidgetRight = userWidgetRight;
        this.createLayout();
    }

    public FileTable getFileTable() {
        return this.fileTable;
    }

    public void setOkButtonEnabled(boolean enabled) {
        this.btnOk.setEnabled(enabled);
    }

    public Object getCurrentFolder() {
        TreeTableNode node = this.currentFolder.getCurrentNode();
        if (node instanceof FileSystemTreeModel.FolderNode) {
            return ((FileSystemTreeModel.FolderNode)node).getFolder();
        }
        return null;
    }

    public boolean setCurrentFolder(Object folder) {
        FileSystemTreeModel.FolderNode node = this.model.getNodeForFolder(folder);
        if (node != null) {
            this.setCurrentNode(node);
            return true;
        }
        return false;
    }

    public boolean selectFile(Object file) {
        if (this.fsm == null) {
            return false;
        }
        Object parent = this.fsm.getParent(file);
        if (this.setCurrentFolder(parent)) {
            return this.fileTable.setSelection(file);
        }
        return false;
    }

    public void clearSelection() {
        this.fileTable.clearSelection();
    }

    public void addFileFilter(NamedFileFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        this.fileFiltersModel.addFileFilter(filter);
        this.fileFilterBox.setVisible(this.fileFiltersModel.getNumEntries() > 0);
        if (this.fileFilterBox.getSelected() < 0) {
            this.fileFilterBox.setSelected(0);
        }
    }

    public void removeFileFilter(NamedFileFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        this.fileFiltersModel.removeFileFilter(filter);
        if (this.fileFiltersModel.getNumEntries() == 0) {
            this.fileFilterBox.setVisible(false);
            this.setFileFilter(AllFilesFilter);
        }
    }

    public void removeAllFileFilters() {
        this.fileFiltersModel.removeAll();
        this.fileFilterBox.setVisible(false);
        this.setFileFilter(AllFilesFilter);
    }

    public void setFileFilter(NamedFileFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        int idx = this.fileFiltersModel.findFilter(filter);
        if (idx < 0) {
            throw new IllegalArgumentException("filter not registered");
        }
        this.fileFilterBox.setSelected(idx);
    }

    public NamedFileFilter getFileFilter() {
        return this.activeFileFilter;
    }

    public boolean getShowFolders() {
        return this.btnShowFolders.getModel().isSelected();
    }

    public void setShowFolders(boolean showFolders) {
        this.btnShowFolders.getModel().setSelected(showFolders);
    }

    public boolean getShowHidden() {
        return this.btnShowHidden.getModel().isSelected();
    }

    public void setShowHidden(boolean showHidden) {
        this.btnShowHidden.getModel().setSelected(showHidden);
    }

    public void goOneLevelUp() {
        TreeTableNode node = this.currentFolder.getCurrentNode();
        TreeTableNode parent = node.getParent();
        if (parent != null) {
            this.setCurrentNode(parent, node);
        }
    }

    public boolean goHome() {
        Object folder;
        if (this.fsm != null && (folder = this.fsm.getSpecialFolder("user.home")) != null) {
            return this.setCurrentFolder(folder);
        }
        return false;
    }

    public void acceptSelection() {
        FileTable.Entry entry;
        FileTable.Entry[] selection = this.fileTable.getSelection();
        if (selection.length == 1 && (entry = selection[0]) != null && entry.isFolder) {
            this.setCurrentFolder(entry.obj);
            return;
        }
        this.fireAcceptCallback(selection);
    }

    void fileFilterChanged() {
        int idx = this.fileFilterBox.getSelected();
        if (idx >= 0) {
            NamedFileFilter filter;
            this.activeFileFilter = filter = this.fileFiltersModel.getFileFilter(idx);
            this.fileTable.setFileFilter(filter.getFileFilter());
        }
    }

    void fireAcceptCallback(FileTable.Entry[] selection) {
        if (this.callbacks != null) {
            Object[] objects = new Object[selection.length];
            for (int i = 0; i < selection.length; ++i) {
                FileTable.Entry e = selection[i];
                if (e.isFolder && !this.allowFolderSelection) {
                    return;
                }
                objects[i] = e.obj;
            }
            this.addToMRU(selection);
            for (Callback cb : this.callbacks) {
                cb.filesSelected(objects);
            }
        }
    }

    void fireCanceled() {
        if (this.callbacks != null) {
            for (Callback cb : this.callbacks) {
                cb.canceled();
            }
        }
    }

    void selectionChanged() {
        boolean foldersSelected = false;
        boolean filesSelected = false;
        FileTable.Entry[] selection = this.fileTable.getSelection();
        for (FileTable.Entry entry : selection) {
            if (entry.isFolder) {
                foldersSelected = true;
                continue;
            }
            filesSelected = true;
        }
        if (this.allowFolderSelection) {
            this.btnOk.setEnabled(filesSelected || foldersSelected);
        } else {
            this.btnOk.setEnabled(filesSelected && !foldersSelected);
        }
        if (this.callbacks != null) {
            for (Callback cb : this.callbacks) {
                if (!(cb instanceof Callback2)) continue;
                ((Callback2)cb).selectionChanged(selection);
            }
        }
    }

    protected void setCurrentNode(TreeTableNode node, TreeTableNode childToSelect) {
        if (childToSelect instanceof FileSystemTreeModel.FolderNode) {
            this.fileToSelectOnSetCurrentNode = ((FileSystemTreeModel.FolderNode)childToSelect).getFolder();
        }
        this.setCurrentNode(node);
    }

    protected void setCurrentNode(TreeTableNode node) {
        this.currentFolder.setCurrentNode(node);
        this.refreshFileTable();
        if (this.callbacks != null) {
            Object curFolder = this.getCurrentFolder();
            for (Callback cb : this.callbacks) {
                if (!(cb instanceof Callback2)) continue;
                ((Callback2)cb).folderChanged(curFolder);
            }
        }
        if (this.fileToSelectOnSetCurrentNode != null) {
            this.fileTable.setSelection(this.fileToSelectOnSetCurrentNode);
            this.fileToSelectOnSetCurrentNode = null;
        }
    }

    void refreshFileTable() {
        this.fileTable.setShowFolders(this.btnShowFolders.getModel().isSelected());
        this.fileTable.setShowHidden(this.btnShowHidden.getModel().isSelected());
        this.fileTable.setCurrentFolder(this.fsm, this.getCurrentFolder());
    }

    TreeTableNode resolvePath(String path) throws IllegalArgumentException {
        Object obj = this.fsm.getFile(path);
        this.fileToSelectOnSetCurrentNode = null;
        if (obj != null) {
            FileSystemTreeModel.FolderNode node;
            if (this.fsm.isFile(obj)) {
                this.fileToSelectOnSetCurrentNode = obj;
                obj = this.fsm.getParent(obj);
            }
            if ((node = this.model.getNodeForFolder(obj)) != null) {
                return node;
            }
        }
        throw new IllegalArgumentException("Could not resolve: " + path);
    }

    void showFolderMRU() {
        final PopupWindow popup = new PopupWindow(this);
        final ListBox listBox = new ListBox(this.folderMRU);
        popup.setTheme("fileselector-folderMRUpopup");
        popup.add(listBox);
        if (popup.openPopup()) {
            popup.setInnerSize(this.getInnerWidth() * 2 / 3, this.getInnerHeight() * 2 / 3);
            popup.setPosition(this.btnFolderMRU.getX() - popup.getWidth(), this.btnFolderMRU.getY());
            listBox.addCallback(new CallbackWithReason(){

                public void callback(ListBox.CallbackReason reason) {
                    if (reason.actionRequested()) {
                        popup.closePopup();
                        int idx = listBox.getSelected();
                        if (idx >= 0) {
                            FileSelector.this.gotoFolderFromMRU(idx);
                        }
                    }
                }
            });
        }
    }

    void showFilesMRU() {
        final PopupWindow popup = new PopupWindow(this);
        DialogLayout layout = new DialogLayout();
        final ListBox listBox = new ListBox(this.filesMRU);
        Button popupBtnOk = new Button();
        Button popupBtnCancel = new Button();
        popupBtnOk.setTheme("buttonOk");
        popupBtnCancel.setTheme("buttonCancel");
        popup.setTheme("fileselector-filesMRUpopup");
        popup.add(layout);
        layout.add(listBox);
        layout.add(popupBtnOk);
        layout.add(popupBtnCancel);
        DialogLayout.Group hBtnGroup = layout.createSequentialGroup().addGap().addWidget(popupBtnOk).addWidget(popupBtnCancel);
        DialogLayout.Group vBtnGroup = layout.createParallelGroup().addWidget(popupBtnOk).addWidget(popupBtnCancel);
        layout.setHorizontalGroup(layout.createParallelGroup().addWidget(listBox).addGroup(hBtnGroup));
        layout.setVerticalGroup(layout.createSequentialGroup().addWidget(listBox).addGroup(vBtnGroup));
        if (popup.openPopup()) {
            popup.setInnerSize(this.getInnerWidth() * 2 / 3, this.getInnerHeight() * 2 / 3);
            popup.setPosition(this.getInnerX() + (this.getInnerWidth() - popup.getWidth()) / 2, this.btnFilesMRU.getY() - popup.getHeight());
            final Runnable okCB = new Runnable(){

                @Override
                public void run() {
                    int idx = listBox.getSelected();
                    if (idx >= 0) {
                        Object obj = FileSelector.this.fsm.getFile((String)FileSelector.this.filesMRU.getEntry(idx));
                        if (obj != null) {
                            popup.closePopup();
                            FileSelector.this.fireAcceptCallback(new FileTable.Entry[]{new FileTable.Entry(FileSelector.this.fsm, obj, FileSelector.this.fsm.getParent(obj) == null)});
                        } else {
                            FileSelector.this.filesMRU.removeEntry(idx);
                        }
                    }
                }
            };
            popupBtnOk.addCallback(okCB);
            popupBtnCancel.addCallback(new Runnable(){

                @Override
                public void run() {
                    popup.closePopup();
                }
            });
            listBox.addCallback(new CallbackWithReason(){

                public void callback(ListBox.CallbackReason reason) {
                    if (reason.actionRequested()) {
                        okCB.run();
                    }
                }
            });
        }
    }

    private void addToMRU(FileTable.Entry[] selection) {
        for (FileTable.Entry entry : selection) {
            this.filesMRU.addEntry(entry.getPath());
        }
        this.folderMRU.addEntry(this.fsm.getPath(this.getCurrentFolder()));
    }

    boolean gotoFolderFromMRU(int idx) {
        if (idx >= this.folderMRU.getNumEntries()) {
            return false;
        }
        String path = (String)this.folderMRU.getEntry(idx);
        try {
            TreeTableNode node = this.resolvePath(path);
            this.setCurrentNode(node);
            return true;
        }
        catch (IllegalArgumentException ex) {
            this.folderMRU.removeEntry(idx);
            return false;
        }
    }

    public static class NameSorter
    implements Comparator {
        private final FileSystemModel fsm;
        private final Comparator nameComparator;

        public NameSorter(FileSystemModel fsm) {
            this.fsm = fsm;
            this.nameComparator = NaturalSortComparator.stringComparator;
        }

        public NameSorter(FileSystemModel fsm, Comparator nameComparator) {
            this.fsm = fsm;
            this.nameComparator = nameComparator;
        }

        public int compare(Object o1, Object o2) {
            return this.nameComparator.compare(this.fsm.getName(o1), this.fsm.getName(o2));
        }
    }

    static class FileFiltersModel
    extends SimpleListModel {
        private final ArrayList filters = new ArrayList();

        FileFiltersModel() {
        }

        public NamedFileFilter getFileFilter(int index) {
            return (NamedFileFilter)this.filters.get(index);
        }

        @Override
        public String getEntry(int index) {
            NamedFileFilter filter = this.getFileFilter(index);
            return filter.getDisplayName();
        }

        @Override
        public int getNumEntries() {
            return this.filters.size();
        }

        public void addFileFilter(NamedFileFilter filter) {
            int index = this.filters.size();
            this.filters.add(filter);
            this.fireEntriesInserted(index, index);
        }

        public void removeFileFilter(NamedFileFilter filter) {
            int idx = this.filters.indexOf(filter);
            if (idx >= 0) {
                this.filters.remove(idx);
                this.fireEntriesDeleted(idx, idx);
            }
        }

        public int findFilter(NamedFileFilter filter) {
            return this.filters.indexOf(filter);
        }

        void removeAll() {
            this.filters.clear();
            this.fireAllChanged();
        }
    }

    public static class NamedFileFilter {
        private final String name;
        private final FileSystemModel.FileFilter fileFilter;

        public NamedFileFilter(String name, FileSystemModel.FileFilter fileFilter) {
            this.name = name;
            this.fileFilter = fileFilter;
        }

        public String getDisplayName() {
            return this.name;
        }

        public FileSystemModel.FileFilter getFileFilter() {
            return this.fileFilter;
        }
    }

    public static interface Callback2
    extends Callback {
        public void folderChanged(Object var1);

        public void selectionChanged(FileTable.Entry[] var1);
    }

    public static interface Callback {
        public void filesSelected(Object[] var1);

        public void canceled();
    }
}

