/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Alignment;
import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.BoxLayout;
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Container;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.HasCallback;
import de.matthiasmann.twl.renderer.AnimationState;
import java.util.ArrayList;

public class TabbedPane
extends Widget {
    public static final AnimationState.StateKey STATE_FIRST_TAB = AnimationState.StateKey.get("firstTab");
    public static final AnimationState.StateKey STATE_LAST_TAB = AnimationState.StateKey.get("lastTab");
    private final ArrayList tabs = new ArrayList();
    private final BoxLayout tabBox = new BoxLayout();
    private final Widget tabBoxClip = new Widget();
    private final Container container = new Container();
    final Container innerContainer = new Container();
    DialogLayout scrollControlls;
    Button btnScrollLeft;
    Button btnScrollRight;
    boolean scrollTabs;
    int tabScrollPosition;
    TabPosition tabPosition = TabPosition.TOP;
    Tab activeTab;

    public TabbedPane() {
        this.tabBox.setTheme("tabbox");
        this.tabBoxClip.setTheme("");
        this.innerContainer.setTheme("");
        this.innerContainer.setClip(true);
        this.tabBoxClip.add(this.tabBox);
        this.container.add(this.innerContainer);
        super.insertChild(this.container, 0);
        super.insertChild(this.tabBoxClip, 1);
        this.addActionMapping("nextTab", "cycleTabs", 1);
        this.addActionMapping("prevTab", "cycleTabs", -1);
        this.setCanAcceptKeyboardFocus(false);
    }

    public TabPosition getTabPosition() {
        return this.tabPosition;
    }

    public void setTabPosition(TabPosition tabPosition) {
        if (tabPosition == null) {
            throw new NullPointerException("tabPosition");
        }
        if (this.tabPosition != tabPosition) {
            this.tabPosition = tabPosition;
            this.tabBox.setDirection(tabPosition.horz ? BoxLayout.Direction.HORIZONTAL : BoxLayout.Direction.VERTICAL);
            this.invalidateLayout();
        }
    }

    public boolean isScrollTabs() {
        return this.scrollTabs;
    }

    public void setScrollTabs(boolean scrollTabs) {
        if (this.scrollTabs != scrollTabs) {
            this.scrollTabs = scrollTabs;
            if (this.scrollControlls == null && scrollTabs) {
                this.createScrollControlls();
            }
            this.tabBoxClip.setClip(scrollTabs);
            if (this.scrollControlls != null) {
                this.scrollControlls.setVisible(scrollTabs);
            }
            this.invalidateLayout();
        }
    }

    public Tab addTab(String title, Widget pane) {
        Tab tab = new Tab();
        tab.setTitle(title);
        tab.setPane(pane);
        this.tabBox.add(tab.button);
        this.tabs.add(tab);
        if (this.tabs.size() == 1) {
            this.setActiveTab(tab);
        }
        this.updateTabStates();
        return tab;
    }

    public Tab getActiveTab() {
        return this.activeTab;
    }

    public void setActiveTab(Tab tab) {
        if (tab != null) {
            this.validateTab(tab);
        }
        if (this.activeTab != tab) {
            Tab prevTab = this.activeTab;
            this.activeTab = tab;
            if (prevTab != null) {
                prevTab.doCallback();
            }
            if (tab != null) {
                tab.doCallback();
            }
            if (this.scrollTabs) {
                int size;
                int end;
                int pos;
                this.validateLayout();
                if (this.tabPosition.horz) {
                    pos = tab.button.getX() - this.tabBox.getX();
                    end = tab.button.getWidth() + pos;
                    size = this.tabBoxClip.getWidth();
                } else {
                    pos = tab.button.getY() - this.tabBox.getY();
                    end = tab.button.getHeight() + pos;
                    size = this.tabBoxClip.getHeight();
                }
                int border = (size + 19) / 20;
                end += border;
                if ((pos -= border) < this.tabScrollPosition) {
                    this.setScrollPos(pos);
                } else if (end > this.tabScrollPosition + size) {
                    this.setScrollPos(end - size);
                }
            }
            if (tab != null && tab.pane != null) {
                tab.pane.requestKeyboardFocus();
            }
        }
    }

    public void removeTab(Tab tab) {
        this.validateTab(tab);
        int idx = tab == this.activeTab ? this.tabs.indexOf(tab) : -1;
        tab.setPane(null);
        this.tabBox.removeChild(tab.button);
        this.tabs.remove(tab);
        if (idx >= 0 && !this.tabs.isEmpty()) {
            this.setActiveTab((Tab)this.tabs.get(Math.min(this.tabs.size() - 1, idx)));
        }
        this.updateTabStates();
    }

    public void removeAllTabs() {
        this.innerContainer.removeAllChildren();
        this.tabBox.removeAllChildren();
        this.tabs.clear();
        this.activeTab = null;
    }

    public int getNumTabs() {
        return this.tabs.size();
    }

    public Tab getTab(int index) {
        return (Tab)this.tabs.get(index);
    }

    public int getActiveTabIndex() {
        if (this.tabs.isEmpty()) {
            return -1;
        }
        return this.tabs.indexOf(this.activeTab);
    }

    public void cycleTabs(int direction) {
        if (!this.tabs.isEmpty()) {
            int idx = this.tabs.indexOf(this.activeTab);
            if (idx < 0) {
                idx = 0;
            } else {
                idx += direction;
                idx %= this.tabs.size();
                idx += this.tabs.size();
                idx %= this.tabs.size();
            }
            this.setActiveTab((Tab)this.tabs.get(idx));
        }
    }

    @Override
    public int getMinWidth() {
        int minWidth;
        if (this.tabPosition.horz) {
            int tabBoxWidth = this.scrollTabs ? this.tabBox.getBorderHorizontal() + BoxLayout.computeMinWidthVertical(this.tabBox) + this.scrollControlls.getPreferredWidth() : this.tabBox.getMinWidth();
            minWidth = Math.max(this.container.getMinWidth(), tabBoxWidth);
        } else {
            minWidth = this.container.getMinWidth() + this.tabBox.getMinWidth();
        }
        return Math.max(super.getMinWidth(), minWidth + this.getBorderHorizontal());
    }

    @Override
    public int getMinHeight() {
        int minHeight = this.tabPosition.horz ? this.container.getMinHeight() + this.tabBox.getMinHeight() : Math.max(this.container.getMinHeight(), this.tabBox.getMinHeight());
        return Math.max(super.getMinHeight(), minHeight + this.getBorderVertical());
    }

    @Override
    public int getPreferredInnerWidth() {
        if (this.tabPosition.horz) {
            int tabBoxWidth = this.scrollTabs ? this.tabBox.getBorderHorizontal() + BoxLayout.computePreferredWidthVertical(this.tabBox) + this.scrollControlls.getPreferredWidth() : this.tabBox.getPreferredWidth();
            return Math.max(this.container.getPreferredWidth(), tabBoxWidth);
        }
        return this.container.getPreferredWidth() + this.tabBox.getPreferredWidth();
    }

    @Override
    public int getPreferredInnerHeight() {
        if (this.tabPosition.horz) {
            return this.container.getPreferredHeight() + this.tabBox.getPreferredHeight();
        }
        return Math.max(this.container.getPreferredHeight(), this.tabBox.getPreferredHeight());
    }

    @Override
    protected void layout() {
        int scrollCtrlsWidth = 0;
        int scrollCtrlsHeight = 0;
        int tabBoxWidth = this.tabBox.getPreferredWidth();
        int tabBoxHeight = this.tabBox.getPreferredHeight();
        if (this.scrollTabs) {
            scrollCtrlsWidth = this.scrollControlls.getPreferredWidth();
            scrollCtrlsHeight = this.scrollControlls.getPreferredHeight();
        }
        if (this.tabPosition.horz) {
            tabBoxHeight = Math.max(scrollCtrlsHeight, tabBoxHeight);
        } else {
            tabBoxWidth = Math.max(scrollCtrlsWidth, tabBoxWidth);
        }
        this.tabBox.setSize(tabBoxWidth, tabBoxHeight);
        switch (this.tabPosition) {
            case TOP: {
                this.tabBoxClip.setPosition(this.getInnerX(), this.getInnerY());
                this.tabBoxClip.setSize(Math.max(0, this.getInnerWidth() - scrollCtrlsWidth), tabBoxHeight);
                this.container.setSize(this.getInnerWidth(), Math.max(0, this.getInnerHeight() - tabBoxHeight));
                this.container.setPosition(this.getInnerX(), this.tabBoxClip.getBottom());
                break;
            }
            case LEFT: {
                this.tabBoxClip.setPosition(this.getInnerX(), this.getInnerY());
                this.tabBoxClip.setSize(tabBoxWidth, Math.max(0, this.getInnerHeight() - scrollCtrlsHeight));
                this.container.setSize(Math.max(0, this.getInnerWidth() - tabBoxWidth), this.getInnerHeight());
                this.container.setPosition(this.tabBoxClip.getRight(), this.getInnerY());
                break;
            }
            case RIGHT: {
                this.tabBoxClip.setPosition(this.getInnerX() - tabBoxWidth, this.getInnerY());
                this.tabBoxClip.setSize(tabBoxWidth, Math.max(0, this.getInnerHeight() - scrollCtrlsHeight));
                this.container.setSize(Math.max(0, this.getInnerWidth() - tabBoxWidth), this.getInnerHeight());
                this.container.setPosition(this.getInnerX(), this.getInnerY());
                break;
            }
            case BOTTOM: {
                this.tabBoxClip.setPosition(this.getInnerX(), this.getInnerY() - tabBoxHeight);
                this.tabBoxClip.setSize(Math.max(0, this.getInnerWidth() - scrollCtrlsWidth), tabBoxHeight);
                this.container.setSize(this.getInnerWidth(), Math.max(0, this.getInnerHeight() - tabBoxHeight));
                this.container.setPosition(this.getInnerX(), this.getInnerY());
            }
        }
        if (this.scrollControlls != null) {
            if (this.tabPosition.horz) {
                this.scrollControlls.setPosition(this.tabBoxClip.getRight(), this.tabBoxClip.getY());
                this.scrollControlls.setSize(scrollCtrlsWidth, tabBoxHeight);
            } else {
                this.scrollControlls.setPosition(this.tabBoxClip.getX(), this.tabBoxClip.getBottom());
                this.scrollControlls.setSize(tabBoxWidth, scrollCtrlsHeight);
            }
            this.setScrollPos(this.tabScrollPosition);
        }
    }

    private void createScrollControlls() {
        this.scrollControlls = new DialogLayout();
        this.scrollControlls.setTheme("scrollControls");
        this.btnScrollLeft = new Button();
        this.btnScrollLeft.setTheme("scrollLeft");
        this.btnScrollLeft.addCallback(new CB(-1));
        this.btnScrollRight = new Button();
        this.btnScrollRight.setTheme("scrollRight");
        this.btnScrollRight.addCallback(new CB(1));
        DialogLayout.Group horz = this.scrollControlls.createSequentialGroup().addWidget(this.btnScrollLeft).addGap("scrollButtons").addWidget(this.btnScrollRight);
        DialogLayout.Group vert = this.scrollControlls.createParallelGroup().addWidget(this.btnScrollLeft).addWidget(this.btnScrollRight);
        this.scrollControlls.setHorizontalGroup(horz);
        this.scrollControlls.setVerticalGroup(vert);
        super.insertChild(this.scrollControlls, 2);
    }

    void scrollTabs(int dir) {
        this.setScrollPos(this.tabScrollPosition + (dir *= Math.max(1, this.tabBoxClip.getWidth() / 10)));
    }

    private void setScrollPos(int pos) {
        int maxPos = this.tabPosition.horz ? this.tabBox.getWidth() - this.tabBoxClip.getWidth() : this.tabBox.getHeight() - this.tabBoxClip.getHeight();
        this.tabScrollPosition = pos = Math.max(0, Math.min(pos, maxPos));
        if (this.tabPosition.horz) {
            this.tabBox.setPosition(this.tabBoxClip.getX() - pos, this.tabBoxClip.getY());
        } else {
            this.tabBox.setPosition(this.tabBoxClip.getX(), this.tabBoxClip.getY() - pos);
        }
        if (this.scrollControlls != null) {
            this.btnScrollLeft.setEnabled(pos > 0);
            this.btnScrollRight.setEnabled(pos < maxPos);
        }
    }

    @Override
    public void insertChild(Widget child, int index) {
        throw new UnsupportedOperationException("use addTab/removeTab");
    }

    @Override
    public void removeAllChildren() {
        throw new UnsupportedOperationException("use addTab/removeTab");
    }

    @Override
    public Widget removeChild(int index) {
        throw new UnsupportedOperationException("use addTab/removeTab");
    }

    protected void updateTabStates() {
        int n = this.tabs.size();
        for (int i = 0; i < n; ++i) {
            Tab tab = (Tab)this.tabs.get(i);
            AnimationState animationState = tab.button.getAnimationState();
            animationState.setAnimationState(STATE_FIRST_TAB, i == 0);
            animationState.setAnimationState(STATE_LAST_TAB, i == n - 1);
        }
    }

    private void validateTab(Tab tab) {
        if (tab.button.getParent() != this.tabBox) {
            throw new IllegalArgumentException("Invalid tab");
        }
    }

    private class CB
    implements Runnable {
        final int dir;

        CB(int dir) {
            this.dir = dir;
        }

        @Override
        public void run() {
            TabbedPane.this.scrollTabs(this.dir);
        }
    }

    private static class TabButton
    extends ToggleButton {
        Button closeButton;
        Alignment closeButtonAlignment;
        int closeButtonOffsetX;
        int closeButtonOffsetY;
        String userTheme;

        TabButton(BooleanModel model) {
            super(model);
            this.setCanAcceptKeyboardFocus(false);
            this.closeButtonAlignment = Alignment.RIGHT;
        }

        public void setUserTheme(String userTheme) {
            this.userTheme = userTheme;
            this.doSetTheme();
        }

        private void doSetTheme() {
            if (this.userTheme != null) {
                this.setTheme(this.userTheme);
            } else if (this.closeButton != null) {
                this.setTheme("tabbuttonWithCloseButton");
            } else {
                this.setTheme("tabbutton");
            }
            this.reapplyTheme();
        }

        @Override
        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            if (this.closeButton != null) {
                this.closeButtonAlignment = (Alignment)themeInfo.getParameter("closeButtonAlignment", Alignment.RIGHT);
                this.closeButtonOffsetX = themeInfo.getParameter("closeButtonOffsetX", 0);
                this.closeButtonOffsetY = themeInfo.getParameter("closeButtonOffsetY", 0);
            } else {
                this.closeButtonAlignment = Alignment.RIGHT;
                this.closeButtonOffsetX = 0;
                this.closeButtonOffsetY = 0;
            }
        }

        void setCloseButton(Runnable callback) {
            this.closeButton = new Button();
            this.closeButton.setTheme("closeButton");
            this.doSetTheme();
            this.add(this.closeButton);
            this.closeButton.addCallback(callback);
        }

        void removeCloseButton() {
            this.removeChild(this.closeButton);
            this.closeButton = null;
            this.doSetTheme();
        }

        @Override
        public int getPreferredInnerHeight() {
            return this.computeTextHeight();
        }

        @Override
        public int getPreferredInnerWidth() {
            return this.computeTextWidth();
        }

        @Override
        protected void layout() {
            if (this.closeButton != null) {
                this.closeButton.adjustSize();
                this.closeButton.setPosition(this.getX() + this.closeButtonOffsetX + this.closeButtonAlignment.computePositionX(this.getWidth(), this.closeButton.getWidth()), this.getY() + this.closeButtonOffsetY + this.closeButtonAlignment.computePositionY(this.getHeight(), this.closeButton.getHeight()));
            }
        }
    }

    public class Tab
    extends HasCallback
    implements BooleanModel {
        final TabButton button = new TabButton(this);
        Widget pane;
        Runnable closeCallback;
        Object userValue;

        Tab() {
        }

        @Override
        public boolean getValue() {
            return TabbedPane.this.activeTab == this;
        }

        @Override
        public void setValue(boolean value) {
            if (value) {
                TabbedPane.this.setActiveTab(this);
            }
        }

        public Widget getPane() {
            return this.pane;
        }

        public void setPane(Widget pane) {
            if (this.pane != pane) {
                if (this.pane != null) {
                    TabbedPane.this.innerContainer.removeChild(this.pane);
                }
                this.pane = pane;
                if (pane != null) {
                    pane.setVisible(this.getValue());
                    TabbedPane.this.innerContainer.add(pane);
                }
            }
        }

        public Tab setTitle(String title) {
            this.button.setText(title);
            return this;
        }

        public String getTitle() {
            return this.button.getText();
        }

        public Object getUserValue() {
            return this.userValue;
        }

        public void setUserValue(Object userValue) {
            this.userValue = userValue;
        }

        public Tab setTheme(String theme) {
            this.button.setUserTheme(theme);
            return this;
        }

        public Runnable getCloseCallback() {
            return this.closeCallback;
        }

        public void setCloseCallback(Runnable closeCallback) {
            if (this.closeCallback != null) {
                this.button.removeCloseButton();
            }
            this.closeCallback = closeCallback;
            if (closeCallback != null) {
                this.button.setCloseButton(closeCallback);
            }
        }

        @Override
        protected void doCallback() {
            if (this.pane != null) {
                this.pane.setVisible(this.getValue());
            }
            super.doCallback();
        }
    }

    public static enum TabPosition {
        TOP(true),
        LEFT(false),
        RIGHT(true),
        BOTTOM(false);

        final boolean horz;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private TabPosition() {
            void horz;
            this.horz = horz;
        }
    }
}

