/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Alignment;
import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Font;
import de.matthiasmann.twl.renderer.FontCache;
import de.matthiasmann.twl.utils.TextUtil;

public class TextWidget
extends Widget {
    public static final AnimationState.StateKey STATE_HOVER = AnimationState.StateKey.get("hover");
    public static final AnimationState.StateKey STATE_TEXT_CHANGED = AnimationState.StateKey.get("textChanged");
    public static final AnimationState.StateKey STATE_TEXT_SELECTION = AnimationState.StateKey.get("textSelection");
    private static final int NOT_CACHED = -1;
    private Font font;
    private FontCache cache;
    private CharSequence text = "";
    private int cachedTextWidth = -1;
    private int numTextLines;
    private boolean useCache = true;
    private boolean cacheDirty;
    private Alignment alignment = Alignment.TOPLEFT;

    public TextWidget() {
        this(null, false);
    }

    public TextWidget(AnimationState animState) {
        this(animState, false);
    }

    public TextWidget(AnimationState animState, boolean inherit) {
        super(animState, inherit);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (this.cache != null) {
            this.cache.destroy();
            this.cache = null;
        }
        this.font = font;
        this.cachedTextWidth = -1;
        if (this.useCache) {
            this.cacheDirty = true;
        }
    }

    protected void setCharSequence(CharSequence text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        this.text = text;
        this.cachedTextWidth = -1;
        this.numTextLines = TextUtil.countNumLines(text);
        this.cacheDirty = true;
        this.getAnimationState().resetAnimationTime(STATE_TEXT_CHANGED);
    }

    protected CharSequence getCharSequence() {
        return this.text;
    }

    public boolean hasText() {
        return this.numTextLines > 0;
    }

    public boolean isMultilineText() {
        return this.numTextLines > 1;
    }

    public int getNumTextLines() {
        return this.numTextLines;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        if (this.alignment != alignment) {
            this.alignment = alignment;
            this.cacheDirty = true;
        }
    }

    public boolean isCache() {
        return this.useCache;
    }

    public void setCache(boolean cache) {
        if (this.useCache != cache) {
            this.useCache = cache;
            this.cacheDirty = true;
        }
    }

    protected void applyThemeTextWidget(ThemeInfo themeInfo) {
        this.setFont(themeInfo.getFont("font"));
        this.setAlignment((Alignment)themeInfo.getParameter("textAlignment", Alignment.TOPLEFT));
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemeTextWidget(themeInfo);
    }

    @Override
    public void destroy() {
        if (this.cache != null) {
            this.cache.destroy();
            this.cache = null;
        }
        super.destroy();
    }

    protected int computeTextX() {
        int x = this.getInnerX();
        byte pos = this.alignment.hpos;
        if (pos > 0) {
            return x + (this.getInnerWidth() - this.computeTextWidth()) * pos / 2;
        }
        return x;
    }

    protected int computeTextY() {
        int y = this.getInnerY();
        byte pos = this.alignment.vpos;
        if (pos > 0) {
            return y + (this.getInnerHeight() - this.computeTextHeight()) * pos / 2;
        }
        return y;
    }

    @Override
    protected void paintWidget(GUI gui) {
        this.paintLabelText(this.getAnimationState());
    }

    protected void paintLabelText(de.matthiasmann.twl.renderer.AnimationState animState) {
        if (this.cacheDirty) {
            this.updateCache();
        }
        if (this.hasText() && this.font != null) {
            int x = this.computeTextX();
            int y = this.computeTextY();
            this.paintTextAt(animState, x, y);
        }
    }

    protected void paintTextAt(de.matthiasmann.twl.renderer.AnimationState animState, int x, int y) {
        if (this.cache != null) {
            this.cache.draw(animState, x, y);
        } else if (this.numTextLines > 1) {
            this.font.drawMultiLineText(animState, x, y, this.text, this.computeTextWidth(), this.alignment.fontHAlignment);
        } else {
            this.font.drawText(animState, x, y, this.text);
        }
    }

    protected void paintWithSelection(AnimationState animState, int start, int end) {
        this.paintWithSelection(animState, start, end, 0, this.text.length(), this.computeTextY());
    }

    protected void paintWithSelection(AnimationState animState, int start, int end, int lineStart, int lineEnd, int y) {
        if (this.cacheDirty) {
            this.updateCache();
        }
        if (this.hasText() && this.font != null) {
            int x = this.computeTextX();
            start = TextWidget.limit(start, lineStart, lineEnd);
            end = TextWidget.limit(end, lineStart, lineEnd);
            if (start > lineStart) {
                x += this.font.drawText(animState, x, y, this.text, lineStart, start);
            }
            if (end > start) {
                animState.setAnimationState(STATE_TEXT_SELECTION, true);
                x += this.font.drawText(animState, x, y, this.text, start, end);
                animState.setAnimationState(STATE_TEXT_SELECTION, false);
            }
            if (end < lineEnd) {
                this.font.drawText(animState, x, y, this.text, end, lineEnd);
            }
        }
    }

    private static int limit(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    @Override
    public int getPreferredInnerWidth() {
        int prefWidth = super.getPreferredInnerWidth();
        if (this.hasText() && this.font != null) {
            prefWidth = Math.max(prefWidth, this.computeTextWidth());
        }
        return prefWidth;
    }

    @Override
    public int getPreferredInnerHeight() {
        int prefHeight = super.getPreferredInnerHeight();
        if (this.hasText() && this.font != null) {
            prefHeight = Math.max(prefHeight, this.computeTextHeight());
        }
        return prefHeight;
    }

    public int computeRelativeCursorPositionX(int charIndex) {
        return this.computeRelativeCursorPositionX(0, charIndex);
    }

    public int computeRelativeCursorPositionX(int startIndex, int charIndex) {
        if (this.font != null && charIndex > startIndex) {
            return this.font.computeTextWidth(this.text, startIndex, charIndex);
        }
        return 0;
    }

    public int computeTextWidth() {
        if (this.font != null) {
            if (this.cachedTextWidth == -1 || this.cacheDirty) {
                this.cachedTextWidth = this.numTextLines > 1 ? this.font.computeMultiLineTextWidth(this.text) : this.font.computeTextWidth(this.text);
            }
            return this.cachedTextWidth;
        }
        return 0;
    }

    public int computeTextHeight() {
        if (this.font != null) {
            return Math.max(1, this.numTextLines) * this.font.getLineHeight();
        }
        return 0;
    }

    private void updateCache() {
        this.cacheDirty = false;
        if (this.useCache && this.hasText() && this.font != null) {
            this.cache = this.numTextLines > 1 ? this.font.cacheMultiLineText(this.cache, this.text, this.font.computeMultiLineTextWidth(this.text), this.alignment.fontHAlignment) : this.font.cacheText(this.cache, this.text);
            if (this.cache != null) {
                this.cachedTextWidth = this.cache.getWidth();
            }
        } else {
            this.destroy();
        }
    }

    protected void handleMouseHover(Event evt) {
        if (evt.isMouseEvent() && !this.hasSharedAnimationState()) {
            this.getAnimationState().setAnimationState(STATE_HOVER, evt.getType() != Event.Type.MOUSE_EXITED);
        }
    }
}

