/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.BoxLayout;
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.utils.CallbackSupport;

public class TreePathDisplay
extends Widget {
    private final BoxLayout pathBox = new PathBox();
    private final EditField editField;
    private Callback[] callbacks;
    private String separator = "/";
    private TreeTableNode currentNode;
    private boolean allowEdit;

    public TreePathDisplay() {
        this.pathBox.setScroll(true);
        this.pathBox.setClip(true);
        this.editField = new PathEditField();
        this.editField.setVisible(false);
        this.add(this.pathBox);
        this.add(this.editField);
    }

    public void addCallback(Callback cb) {
        this.callbacks = (Callback[])CallbackSupport.addCallbackToList(this.callbacks, cb, Callback.class);
    }

    public void removeCallback(Callback cb) {
        this.callbacks = (Callback[])CallbackSupport.removeCallbackFromList((Object[])this.callbacks, cb);
    }

    public TreeTableNode getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(TreeTableNode currentNode) {
        this.currentNode = currentNode;
        this.rebuildPathBox();
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
        this.rebuildPathBox();
    }

    public boolean isAllowEdit() {
        return this.allowEdit;
    }

    public void setAllowEdit(boolean allowEdit) {
        this.allowEdit = allowEdit;
        this.rebuildPathBox();
    }

    public void setEditErrorMessage(String msg) {
        this.editField.setErrorMessage(msg);
    }

    public EditField getEditField() {
        return this.editField;
    }

    protected String getTextFromNode(TreeTableNode node) {
        String text;
        Object data = node.getData(0);
        String string = text = data != null ? data.toString() : "";
        if (text.endsWith(this.separator)) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    private void rebuildPathBox() {
        this.pathBox.removeAllChildren();
        if (this.currentNode != null) {
            this.recursiveAddNode(this.currentNode, null);
        }
    }

    private void recursiveAddNode(final TreeTableNode node, final TreeTableNode child) {
        if (node.getParent() != null) {
            this.recursiveAddNode(node.getParent(), node);
            Button btn = new Button(this.getTextFromNode(node));
            btn.setTheme("node");
            btn.addCallback(new Runnable(){

                @Override
                public void run() {
                    TreePathDisplay.this.firePathElementClicked(node, child);
                }
            });
            this.pathBox.add(btn);
            Label l = new Label(this.separator);
            l.setTheme("separator");
            if (this.allowEdit) {
                l.addCallback(new CallbackWithReason(){

                    public void callback(Label.CallbackReason reason) {
                        if (reason == Label.CallbackReason.DOUBLE_CLICK) {
                            TreePathDisplay.this.editPath(node);
                        }
                    }
                });
            }
            this.pathBox.add(l);
        }
    }

    void endEdit() {
        this.editField.setVisible(false);
        this.requestKeyboardFocus();
    }

    void editPath(TreeTableNode cursorAfterNode) {
        StringBuilder sb = new StringBuilder();
        int cursorPos = 0;
        if (this.currentNode != null) {
            cursorPos = this.recursiveAddPath(sb, this.currentNode, cursorAfterNode);
        }
        this.editField.setErrorMessage(null);
        this.editField.setText(sb.toString());
        this.editField.setCursorPos(cursorPos, false);
        this.editField.setVisible(true);
        this.editField.requestKeyboardFocus();
    }

    private int recursiveAddPath(StringBuilder sb, TreeTableNode node, TreeTableNode cursorAfterNode) {
        int cursorPos = 0;
        if (node.getParent() != null) {
            cursorPos = this.recursiveAddPath(sb, node.getParent(), cursorAfterNode);
            sb.append(this.getTextFromNode(node)).append(this.separator);
        }
        if (node == cursorAfterNode) {
            return sb.length();
        }
        return cursorPos;
    }

    protected boolean fireResolvePath(String text) {
        if (this.callbacks != null) {
            for (Callback cb : this.callbacks) {
                if (!cb.resolvePath(text)) continue;
                return true;
            }
        }
        return false;
    }

    protected void firePathElementClicked(TreeTableNode node, TreeTableNode child) {
        if (this.callbacks != null) {
            for (Callback cb : this.callbacks) {
                cb.pathElementClicked(node, child);
            }
        }
    }

    @Override
    public int getPreferredInnerWidth() {
        return this.pathBox.getPreferredWidth();
    }

    @Override
    public int getPreferredInnerHeight() {
        return Math.max(this.pathBox.getPreferredHeight(), this.editField.getPreferredHeight());
    }

    @Override
    public int getMinHeight() {
        int minInnerHeight = Math.max(this.pathBox.getMinHeight(), this.editField.getMinHeight());
        return Math.max(super.getMinHeight(), minInnerHeight + this.getBorderVertical());
    }

    @Override
    protected void layout() {
        this.layoutChildFullInnerArea(this.pathBox);
        this.layoutChildFullInnerArea(this.editField);
    }

    private class PathEditField
    extends EditField {
        private PathEditField() {
        }

        @Override
        protected void keyboardFocusLost() {
            if (!this.hasOpenPopups()) {
                this.setVisible(false);
            }
        }

        @Override
        protected void doCallback(int key) {
            super.doCallback(key);
            switch (key) {
                case 28: {
                    if (!TreePathDisplay.this.fireResolvePath(this.getText())) break;
                    TreePathDisplay.this.endEdit();
                    break;
                }
                case 1: {
                    TreePathDisplay.this.endEdit();
                }
            }
        }
    }

    private class PathBox
    extends BoxLayout {
        public PathBox() {
            super(BoxLayout.Direction.HORIZONTAL);
        }

        @Override
        protected boolean handleEvent(Event evt) {
            if (evt.isMouseEvent()) {
                if (evt.getType() == Event.Type.MOUSE_CLICKED && evt.getMouseClickCount() == 2) {
                    TreePathDisplay.this.editPath(TreePathDisplay.this.getCurrentNode());
                    return true;
                }
                return evt.getType() != Event.Type.MOUSE_WHEEL;
            }
            return super.handleEvent(evt);
        }
    }

    public static interface Callback {
        public void pathElementClicked(TreeTableNode var1, TreeTableNode var2);

        public boolean resolvePath(String var1);
    }
}

