/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.TableSelectionModel;
import de.matthiasmann.twl.utils.CallbackSupport;

public abstract class AbstractTableSelectionModel
implements TableSelectionModel {
    protected int leadIndex = -1;
    protected int anchorIndex = -1;
    protected Runnable[] selectionChangeListener;

    protected AbstractTableSelectionModel() {
    }

    @Override
    public int getAnchorIndex() {
        return this.anchorIndex;
    }

    @Override
    public int getLeadIndex() {
        return this.leadIndex;
    }

    @Override
    public void setAnchorIndex(int index) {
        this.anchorIndex = index;
    }

    @Override
    public void setLeadIndex(int index) {
        this.leadIndex = index;
    }

    @Override
    public void addSelectionChangeListener(Runnable cb) {
        this.selectionChangeListener = (Runnable[])CallbackSupport.addCallbackToList(this.selectionChangeListener, cb, Runnable.class);
    }

    @Override
    public void removeSelectionChangeListener(Runnable cb) {
        this.selectionChangeListener = (Runnable[])CallbackSupport.removeCallbackFromList((Object[])this.selectionChangeListener, cb);
    }

    @Override
    public void rowsDeleted(int index, int count) {
        if (this.leadIndex >= index) {
            this.leadIndex = Math.max(index, this.leadIndex - count);
        }
        if (this.anchorIndex >= index) {
            this.anchorIndex = Math.max(index, this.anchorIndex - count);
        }
    }

    @Override
    public void rowsInserted(int index, int count) {
        if (this.leadIndex >= index) {
            this.leadIndex += count;
        }
        if (this.anchorIndex >= index) {
            this.anchorIndex += count;
        }
    }

    protected void fireSelectionChange() {
        CallbackSupport.fireCallbacks(this.selectionChangeListener);
    }

    protected void updateLeadAndAnchor(int index0, int index1) {
        this.anchorIndex = index0;
        this.leadIndex = index1;
    }
}

