/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AbstractTableColumnHeaderModel;
import de.matthiasmann.twl.model.TreeTableModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.utils.CallbackSupport;
import java.util.ArrayList;

public abstract class AbstractTreeTableModel
extends AbstractTableColumnHeaderModel
implements TreeTableModel {
    private final ArrayList children = new ArrayList();
    private TreeTableModel.ChangeListener[] callbacks;

    @Override
    public void addChangeListener(TreeTableModel.ChangeListener listener) {
        this.callbacks = (TreeTableModel.ChangeListener[])CallbackSupport.addCallbackToList(this.callbacks, listener, TreeTableModel.ChangeListener.class);
    }

    @Override
    public void removeChangeListener(TreeTableModel.ChangeListener listener) {
        this.callbacks = (TreeTableModel.ChangeListener[])CallbackSupport.removeCallbackFromList((Object[])this.callbacks, listener);
    }

    @Override
    public Object getData(int column) {
        return null;
    }

    @Override
    public Object getTooltipContent(int column) {
        return null;
    }

    @Override
    public final TreeTableNode getParent() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getNumChildren() {
        return this.children.size();
    }

    @Override
    public TreeTableNode getChild(int idx) {
        return (TreeTableNode)this.children.get(idx);
    }

    @Override
    public int getChildIndex(TreeTableNode child) {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            if (this.children.get(i) != child) continue;
            return i;
        }
        return -1;
    }

    protected void insertChild(TreeTableNode node, int idx) {
        assert (this.getChildIndex(node) < 0);
        assert (node.getParent() == this);
        this.children.add(idx, node);
        this.fireNodesAdded(this, idx, 1);
    }

    protected void removeChild(int idx) {
        this.children.remove(idx);
        this.fireNodesRemoved(this, idx, 1);
    }

    protected void removeAllChildren() {
        int count = this.children.size();
        if (count > 0) {
            this.children.clear();
            this.fireNodesRemoved(this, 0, count);
        }
    }

    protected void fireNodesAdded(TreeTableNode parent, int idx, int count) {
        if (this.callbacks != null) {
            for (TreeTableModel.ChangeListener cl : this.callbacks) {
                cl.nodesAdded(parent, idx, count);
            }
        }
    }

    protected void fireNodesRemoved(TreeTableNode parent, int idx, int count) {
        if (this.callbacks != null) {
            for (TreeTableModel.ChangeListener cl : this.callbacks) {
                cl.nodesRemoved(parent, idx, count);
            }
        }
    }

    protected void fireNodesChanged(TreeTableNode parent, int idx, int count) {
        if (this.callbacks != null) {
            for (TreeTableModel.ChangeListener cl : this.callbacks) {
                cl.nodesChanged(parent, idx, count);
            }
        }
    }

    protected void fireColumnInserted(int idx, int count) {
        if (this.callbacks != null) {
            for (TreeTableModel.ChangeListener cl : this.callbacks) {
                cl.columnInserted(idx, count);
            }
        }
    }

    protected void fireColumnDeleted(int idx, int count) {
        if (this.callbacks != null) {
            for (TreeTableModel.ChangeListener cl : this.callbacks) {
                cl.columnDeleted(idx, count);
            }
        }
    }

    protected void fireColumnHeaderChanged(int column) {
        if (this.callbacks != null) {
            for (TreeTableModel.ChangeListener cl : this.callbacks) {
                cl.columnHeaderChanged(column);
            }
        }
    }
}

