/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.model.SimpleListModel;
import java.util.ArrayList;

public class CombinedListModel
extends SimpleListModel {
    private final ArrayList sublists = new ArrayList();
    private int[] sublistStarts = new int[1];
    private SubListsModel subListsModel;

    @Override
    public int getNumEntries() {
        return this.sublistStarts[this.sublistStarts.length - 1];
    }

    @Override
    public Object getEntry(int index) {
        Sublist sl = this.getSublistForIndex(index);
        if (sl != null) {
            return sl.getEntry(index - sl.startIndex);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object getEntryTooltip(int index) {
        Sublist sl = this.getSublistForIndex(index);
        if (sl != null) {
            return sl.getEntryTooltip(index - sl.startIndex);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getNumSubLists() {
        return this.sublists.size();
    }

    public void addSubList(ListModel model) {
        this.addSubList(this.sublists.size(), model);
    }

    public void addSubList(int index, ListModel model) {
        Sublist sl = new Sublist(model);
        this.sublists.add(index, sl);
        this.adjustStartOffsets();
        int numEntries = sl.getNumEntries();
        if (numEntries > 0) {
            this.fireEntriesInserted(sl.startIndex, sl.startIndex + numEntries - 1);
        }
        if (this.subListsModel != null) {
            this.subListsModel.fireEntriesInserted(index, index);
        }
    }

    public int findSubList(ListModel model) {
        for (int i = 0; i < this.sublists.size(); ++i) {
            Sublist sl = (Sublist)this.sublists.get(i);
            if (sl.list != model) continue;
            return i;
        }
        return -1;
    }

    public void removeAllSubLists() {
        for (int i = 0; i < this.sublists.size(); ++i) {
            ((Sublist)this.sublists.get(i)).removeChangeListener();
        }
        this.sublists.clear();
        this.adjustStartOffsets();
        this.fireAllChanged();
        if (this.subListsModel != null) {
            this.subListsModel.fireAllChanged();
        }
    }

    public boolean removeSubList(ListModel model) {
        int index = this.findSubList(model);
        if (index >= 0) {
            this.removeSubList(index);
            return true;
        }
        return false;
    }

    public ListModel removeSubList(int index) {
        Sublist sl = (Sublist)this.sublists.remove(index);
        sl.removeChangeListener();
        this.adjustStartOffsets();
        int numEntries = sl.getNumEntries();
        if (numEntries > 0) {
            this.fireEntriesDeleted(sl.startIndex, sl.startIndex + numEntries - 1);
        }
        if (this.subListsModel != null) {
            this.subListsModel.fireEntriesDeleted(index, index);
        }
        return sl.list;
    }

    public ListModel getModelForSubLists() {
        if (this.subListsModel == null) {
            this.subListsModel = new SubListsModel();
        }
        return this.subListsModel;
    }

    public int getStartIndexOfSublist(int sublistIndex) {
        return ((Sublist)this.sublists.get((int)sublistIndex)).startIndex;
    }

    private Sublist getSublistForIndex(int index) {
        int[] offsets = this.sublistStarts;
        int lo = 0;
        int hi = offsets.length - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int delta = offsets[mid] - index;
            if (delta <= 0) {
                lo = mid + 1;
            }
            if (delta <= 0) continue;
            hi = mid - 1;
        }
        if (lo > 0 && lo <= this.sublists.size()) {
            Sublist sl = (Sublist)this.sublists.get(lo - 1);
            assert (sl.startIndex <= index);
            return sl;
        }
        return null;
    }

    void adjustStartOffsets() {
        int[] offsets = new int[this.sublists.size() + 1];
        int startIdx = 0;
        int idx = 0;
        while (idx < this.sublists.size()) {
            Sublist sl = (Sublist)this.sublists.get(idx);
            sl.startIndex = startIdx;
            offsets[++idx] = startIdx += sl.getNumEntries();
        }
        this.sublistStarts = offsets;
    }

    class SubListsModel
    extends SimpleListModel {
        SubListsModel() {
        }

        @Override
        public int getNumEntries() {
            return CombinedListModel.this.sublists.size();
        }

        @Override
        public ListModel getEntry(int index) {
            return ((Sublist)((CombinedListModel)CombinedListModel.this).sublists.get((int)index)).list;
        }
    }

    class Sublist
    implements ListModel.ChangeListener {
        final ListModel list;
        int startIndex;

        public Sublist(ListModel list) {
            this.list = list;
            this.list.addChangeListener(this);
        }

        public void removeChangeListener() {
            this.list.removeChangeListener(this);
        }

        public boolean matchPrefix(int index, String prefix) {
            return this.list.matchPrefix(index, prefix);
        }

        public int getNumEntries() {
            return this.list.getNumEntries();
        }

        public Object getEntryTooltip(int index) {
            return this.list.getEntryTooltip(index);
        }

        public Object getEntry(int index) {
            return this.list.getEntry(index);
        }

        @Override
        public void entriesInserted(int first, int last) {
            CombinedListModel.this.adjustStartOffsets();
            CombinedListModel.this.fireEntriesInserted(this.startIndex + first, this.startIndex + last);
        }

        @Override
        public void entriesDeleted(int first, int last) {
            CombinedListModel.this.adjustStartOffsets();
            CombinedListModel.this.fireEntriesDeleted(this.startIndex + first, this.startIndex + last);
        }

        @Override
        public void entriesChanged(int first, int last) {
            CombinedListModel.this.fireEntriesChanged(this.startIndex + first, this.startIndex + last);
        }

        @Override
        public void allChanged() {
            CombinedListModel.this.fireAllChanged();
        }
    }
}

