/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.SimpleListModel;

public class EnumListModel
extends SimpleListModel {
    private final Class enumClass;
    private final Enum[] enumValues;

    public EnumListModel(Class enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("not an enum class");
        }
        this.enumClass = enumClass;
        this.enumValues = (Enum[])enumClass.getEnumConstants();
    }

    public Class getEnumClass() {
        return this.enumClass;
    }

    @Override
    public Enum getEntry(int index) {
        return this.enumValues[index];
    }

    @Override
    public int getNumEntries() {
        return this.enumValues.length;
    }

    public int findEntry(Enum value) {
        int n = this.enumValues.length;
        for (int i = 0; i < n; ++i) {
            if (this.enumValues[i] != value) continue;
            return i;
        }
        return -1;
    }
}

