/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AbstractOptionModel;
import de.matthiasmann.twl.model.IntegerModel;

public class OptionBooleanModel
extends AbstractOptionModel {
    private final IntegerModel optionState;
    private final int optionCode;

    public OptionBooleanModel(IntegerModel optionState, int optionCode) {
        if (optionState == null) {
            throw new NullPointerException("optionState");
        }
        if (optionCode < optionState.getMinValue() || optionCode > optionState.getMaxValue()) {
            throw new IllegalArgumentException("optionCode");
        }
        this.optionState = optionState;
        this.optionCode = optionCode;
    }

    @Override
    public boolean getValue() {
        return this.optionState.getValue() == this.optionCode;
    }

    @Override
    public void setValue(boolean value) {
        if (value) {
            this.optionState.setValue(this.optionCode);
        }
    }

    @Override
    protected void installSrcCallback(Runnable cb) {
        this.optionState.addCallback(cb);
    }

    @Override
    protected void removeSrcCallback(Runnable cb) {
        this.optionState.removeCallback(cb);
    }
}

