/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.SimpleMRUListModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class PersistentMRUListModel
extends SimpleMRUListModel {
    private final Class clazz;
    private final Preferences prefs;
    private final String prefKey;

    public PersistentMRUListModel(int maxEntries, Class clazz, Preferences prefs, String prefKey) {
        super(maxEntries);
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (prefs == null) {
            throw new NullPointerException("prefs");
        }
        if (prefKey == null) {
            throw new NullPointerException("prefKey");
        }
        this.clazz = clazz;
        this.prefs = prefs;
        this.prefKey = prefKey;
        int numEntries = Math.min(prefs.getInt(this.keyForNumEntries(), 0), maxEntries);
        for (int i = 0; i < numEntries; ++i) {
            Serializable entry = null;
            if (clazz == String.class) {
                entry = (Serializable)clazz.cast(prefs.get(this.keyForIndex(i), null));
            } else {
                byte[] data = prefs.getByteArray(this.keyForIndex(i), null);
                if (data != null && data.length > 0) {
                    entry = this.deserialize(data);
                }
            }
            if (entry == null) continue;
            this.entries.add(entry);
        }
    }

    public void addEntry(Serializable entry) {
        if (!this.clazz.isInstance(entry)) {
            throw new ClassCastException();
        }
        super.addEntry(entry);
    }

    @Override
    protected void saveEntries() {
        for (int i = 0; i < this.entries.size(); ++i) {
            Serializable obj = (Serializable)this.entries.get(i);
            if (this.clazz == String.class) {
                this.prefs.put(this.keyForIndex(i), (String)((Object)obj));
                continue;
            }
            byte[] data = this.serialize(obj);
            assert (data != null);
            this.prefs.putByteArray(this.keyForIndex(i), data);
        }
        this.prefs.putInt(this.keyForNumEntries(), this.entries.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serialize(Serializable obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, new Deflater(9));
            try {
                ObjectOutputStream oos = new ObjectOutputStream(dos);
                oos.writeObject(obj);
                oos.close();
            }
            finally {
                this.close(dos);
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Unable to serialize MRU entry", ex);
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Serializable deserialize(byte[] data) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            InflaterInputStream iis = new InflaterInputStream(bais);
            try {
                ObjectInputStream ois = new ObjectInputStream(iis);
                Object obj = ois.readObject();
                if (this.clazz.isInstance(obj)) {
                    Serializable serializable = (Serializable)this.clazz.cast(obj);
                    return serializable;
                }
                this.getLogger().log(Level.WARNING, "Deserialized object of type " + obj.getClass() + " expected " + this.clazz);
                return null;
            }
            finally {
                this.close(iis);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "Unable to deserialize MRU entry", ex);
        }
        return null;
    }

    protected String keyForIndex(int idx) {
        return this.prefKey + "_" + idx;
    }

    protected String keyForNumEntries() {
        return this.prefKey + "_entries";
    }

    private void close(Closeable c) {
        try {
            c.close();
        }
        catch (IOException ex) {
            this.getLogger().log(Level.WARNING, "exception while closing stream", ex);
        }
    }

    Logger getLogger() {
        return Logger.getLogger(PersistentMRUListModel.class.getName());
    }
}

