/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.ButtonModel;
import de.matthiasmann.twl.utils.CallbackSupport;

public class SimpleButtonModel
implements ButtonModel {
    protected static final int STATE_MASK_HOVER = 1;
    protected static final int STATE_MASK_PRESSED = 2;
    protected static final int STATE_MASK_ARMED = 4;
    protected static final int STATE_MASK_DISABLED = 8;
    protected Runnable[] actionCallbacks;
    protected Runnable[] stateCallbacks;
    protected int state;

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public boolean isPressed() {
        return (this.state & 2) != 0;
    }

    @Override
    public boolean isArmed() {
        return (this.state & 4) != 0;
    }

    @Override
    public boolean isHover() {
        return (this.state & 1) != 0;
    }

    @Override
    public boolean isEnabled() {
        return (this.state & 8) == 0;
    }

    @Override
    public void setSelected(boolean selected) {
    }

    @Override
    public void setPressed(boolean pressed) {
        if (pressed != this.isPressed()) {
            boolean fireAction = !pressed && this.isArmed() && this.isEnabled();
            this.setStateBit(2, pressed);
            this.fireStateCallback();
            if (fireAction) {
                this.buttonAction();
            }
        }
    }

    @Override
    public void setArmed(boolean armed) {
        if (armed != this.isArmed()) {
            this.setStateBit(4, armed);
            this.fireStateCallback();
        }
    }

    @Override
    public void setHover(boolean hover) {
        if (hover != this.isHover()) {
            this.setStateBit(1, hover);
            this.fireStateCallback();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            this.setStateBit(8, !enabled);
            this.fireStateCallback();
        }
    }

    protected void buttonAction() {
        this.fireActionCallback();
    }

    protected void setStateBit(int mask, boolean set) {
        this.state = set ? (this.state |= mask) : (this.state &= ~mask);
    }

    protected void fireStateCallback() {
        CallbackSupport.fireCallbacks(this.stateCallbacks);
    }

    @Override
    public void fireActionCallback() {
        CallbackSupport.fireCallbacks(this.actionCallbacks);
    }

    @Override
    public void addActionCallback(Runnable callback) {
        this.actionCallbacks = (Runnable[])CallbackSupport.addCallbackToList(this.actionCallbacks, callback, Runnable.class);
    }

    @Override
    public void removeActionCallback(Runnable callback) {
        this.actionCallbacks = (Runnable[])CallbackSupport.removeCallbackFromList((Object[])this.actionCallbacks, callback);
    }

    @Override
    public boolean hasActionCallbacks() {
        return this.actionCallbacks != null;
    }

    @Override
    public void addStateCallback(Runnable callback) {
        this.stateCallbacks = (Runnable[])CallbackSupport.addCallbackToList(this.stateCallbacks, callback, Runnable.class);
    }

    @Override
    public void removeStateCallback(Runnable callback) {
        this.stateCallbacks = (Runnable[])CallbackSupport.removeCallbackFromList((Object[])this.stateCallbacks, callback);
    }

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
    }
}

