/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class StringList
implements Iterable {
    private final String value;
    private final StringList next;

    public StringList(String value) {
        this(value, null);
    }

    public StringList(String value, StringList next) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value = value;
        this.next = next;
    }

    public StringList getNext() {
        return this.next;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringList)) {
            return false;
        }
        StringList that = (StringList)obj;
        return this.value.equals(that.value) && (this.next == that.next || this.next != null && this.next.equals(that.next));
    }

    public int hashCode() {
        int hash = this.value.hashCode();
        if (this.next != null) {
            hash = 67 * hash + this.next.hashCode();
        }
        return hash;
    }

    public String toString() {
        if (this.next == null) {
            return this.value;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.value);
        StringList list = this.next;
        while (list != null) {
            sb.append(", ").append(list.value);
            list = list.next;
        }
        return sb.toString();
    }

    public Iterator iterator() {
        return new I(this);
    }

    static class I
    implements Iterator {
        private StringList list;

        I(StringList list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.list != null;
        }

        public String next() {
            if (this.list == null) {
                throw new NoSuchElementException();
            }
            String value = this.list.getValue();
            this.list = this.list.getNext();
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

